/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.spring.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.domainlifecycles.domain.types.Identity;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;

public class StringToDomainIdentityConverterFactory
implements ConverterFactory<String, Identity<?>> {
    private final ObjectMapper objectMapper;

    public StringToDomainIdentityConverterFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T extends Identity<?>> Converter<String, T> getConverter(Class<T> targetClass) {
        return new StringToDomainIdentityConverter<T>(targetClass, this.objectMapper);
    }

    private record StringToDomainIdentityConverter<T extends Identity<?>>(Class<T> targetClass, ObjectMapper objectMapper) implements Converter<String, T>
    {
        public T convert(String source) {
            try {
                return (T)((Identity)this.objectMapper.readValue("{\"value\": \"" + source + "\"}", this.targetClass));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Not able to parse identity value", e);
            }
        }
    }
}

