/*
 *     ___
 *     │   ╲                 _
 *     │    ╲ ___ _ __  __ _(_)_ _
 *     |     ╲ _ ╲ '  ╲╱ _` │ │ ' ╲
 *     |_____╱___╱_│_│_╲__,_│_│_||_|
 *     │ │  (_)╱ _│___ __ _  _ __│ |___ ___
 *     │ │__│ │  _╱ -_) _│ ││ ╱ _│ ╱ -_|_-<
 *     │____│_│_│ ╲___╲__│╲_, ╲__│_╲___╱__╱
 *                      |__╱
 *
 *  Copyright 2019-2024 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package io.domainlifecycles.spring.http;

import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

/**
 * Interface for building a {@link ResponseEntity} with a {@link ResponseObject} as body.
 *
 * @author Dominik Galler
 * @author Mario Herb
 */
public interface ResponseEntityBuilder {

    /**
     * Build a {@link ResponseEntity} with a {@link ResponseObject} as body.
     *
     * @param data          the data to be returned
     * @param responseState the http status to be returned
     * @param <T>           the type of the data
     * @return the response entity
     */
    <T> ResponseEntity<ResponseObject<T>> build(T data, HttpStatus responseState);

}
