/*
 * Decompiled with CFR 0.152.
 */
package io.dmuncle.maven;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Mojo(name="dmuncle-send", aggregator=true)
public class DmUncleSendMojo
extends AbstractMojo {
    protected Log LOG = this.getLog();
    public static final String JSON_PACKAGE_FILENAME = "dmuncle-package.json";
    public static final String ERRORS_FILENAME = "dmuncle-errors-log.txt";
    @Parameter(required=true)
    private String serverAddress;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File errorLog = new File(ERRORS_FILENAME);
        if (errorLog.exists()) {
            this.LOG.error((CharSequence)"There are errors that can affect the dependency report for this project! Please check the dmuncle-errors-log.txt file!");
        }
        String url = this.serverAddress + "/import";
        this.LOG.info((CharSequence)("Sending POST request to server " + url));
        Path jsonFilePath = Paths.get(JSON_PACKAGE_FILENAME, new String[0]);
        this.addProjectNameToJSONPackage();
        try {
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json");
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(Files.readAllBytes(jsonFilePath));
            os.flush();
            if (con.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + con.getResponseCode());
            }
            this.LOG.info((CharSequence)"Successfully sent data.");
            con.disconnect();
            Files.delete(jsonFilePath);
            Files.delete(Paths.get("dmuncle-buffer-file.txt", new String[0]));
        }
        catch (MalformedURLException e) {
            this.LOG.error((CharSequence)("Error encountered with server URL: " + e.getMessage()), (Throwable)e);
        }
        catch (ProtocolException e) {
            this.LOG.error((CharSequence)("Error encountered on sending data: " + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            this.LOG.error((CharSequence)("Error encountered on finding json file: " + e.getMessage()), (Throwable)e);
        }
    }

    private void addProjectNameToJSONPackage() {
        try {
            JSONParser parser = new JSONParser();
            FileReader fileReader = new FileReader(JSON_PACKAGE_FILENAME);
            JSONObject jsonPackage = (JSONObject)parser.parse((Reader)fileReader);
            jsonPackage.put((Object)"projectName", (Object)this.project.getName());
            FileUtils.fileWrite((String)JSON_PACKAGE_FILENAME, (String)jsonPackage.toString());
            fileReader.close();
        }
        catch (IOException e) {
            this.LOG.error((CharSequence)("Error encountered on finding json file: " + e.getMessage()), (Throwable)e);
        }
        catch (ParseException e) {
            this.LOG.error((CharSequence)("Error encountered on parsing json file: " + e.getMessage()), (Throwable)e);
        }
    }
}

