/*
 * Decompiled with CFR 0.152.
 */
package io.dmuncle.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.util.FileUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="dmuncle-watch", defaultPhase=LifecyclePhase.PACKAGE, aggregator=true)
public class DmUncleMavenMojo
extends AbstractMojo {
    private static final Logger LOG = LoggerFactory.getLogger(DmUncleMavenMojo.class);
    public static final String JSON_PACKAGE_FILENAME = "dmuncle-package.json";
    public static final String BUFFER_FILENAME = "dmuncle-buffer-file.txt";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    private JSONObject JSONPackage;
    private JSONArray compileDeps;
    private JSONArray testCompileDeps;
    private JSONArray runtimeDeps;
    private JSONArray systemDeps;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.cleanUp();
        LOG.info("Gathering dependencies for project " + this.project.getName());
        File JSONFile = new File(JSON_PACKAGE_FILENAME);
        if (JSONFile.exists()) {
            this.getExistingJSONPackage();
        } else {
            this.initializeJSONPackage();
        }
        this.runCommandToListDependencies();
        List<String> extractedOutputLines = this.processCommandLineOutput();
        this.mapExtractedOutputLinesToDependencies(extractedOutputLines);
        this.saveJSONPackage(this.JSONPackage);
    }

    private void initializeJSONPackage() {
        this.JSONPackage = new JSONObject();
        this.compileDeps = new JSONArray();
        this.testCompileDeps = new JSONArray();
        this.runtimeDeps = new JSONArray();
        this.systemDeps = new JSONArray();
        this.JSONPackage.put((Object)"compileArtifacts", (Object)this.compileDeps);
        this.JSONPackage.put((Object)"testCompileArtifacts", (Object)this.testCompileDeps);
        this.JSONPackage.put((Object)"runtimeArtifacts", (Object)this.runtimeDeps);
        this.JSONPackage.put((Object)"testRuntimeArtifacts", (Object)this.systemDeps);
    }

    private void getExistingJSONPackage() {
        JSONParser parser = new JSONParser();
        try {
            this.JSONPackage = (JSONObject)parser.parse((Reader)new FileReader(JSON_PACKAGE_FILENAME));
            this.compileDeps = (JSONArray)this.JSONPackage.get((Object)"compileArtifacts");
            this.testCompileDeps = (JSONArray)this.JSONPackage.get((Object)"testCompileArtifacts");
            this.runtimeDeps = (JSONArray)this.JSONPackage.get((Object)"runtimeArtifacts");
            this.systemDeps = (JSONArray)this.JSONPackage.get((Object)"testRuntimeArtifacts");
        }
        catch (IOException e) {
            LOG.error("Error encountered on getting json file: " + e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            LOG.error("Error encountered on parsing json file: " + e.getMessage(), (Throwable)e);
        }
    }

    private void addDependencyToJSONPackage(Dependency dependency, String moduleName) {
        JSONObject jsonDep = new JSONObject();
        jsonDep.put((Object)"groupId", (Object)dependency.getGroupId());
        jsonDep.put((Object)"artifactId", (Object)dependency.getArtifactId());
        jsonDep.put((Object)"version", (Object)dependency.getVersion());
        jsonDep.put((Object)"moduleName", (Object)moduleName);
        if (dependency.getScope().equals("compile")) {
            this.compileDeps.add((Object)jsonDep);
        }
        if (dependency.getScope().equals("runtime")) {
            this.runtimeDeps.add((Object)jsonDep);
        }
        if (dependency.getScope().equals("system")) {
            this.systemDeps.add((Object)jsonDep);
        }
        if (dependency.getScope().equals("test")) {
            this.testCompileDeps.add((Object)jsonDep);
        }
    }

    void saveJSONPackage(JSONObject jsonPackage) {
        try {
            FileUtils.fileWrite((String)JSON_PACKAGE_FILENAME, (String)jsonPackage.toString());
        }
        catch (IOException e) {
            LOG.error("Error encountered on saving json file: " + e.getMessage(), (Throwable)e);
        }
    }

    void runCommandToListDependencies() {
        PrintStream oldSystemOut = System.out;
        PrintStream out = null;
        try {
            out = new PrintStream(new FileOutputStream(BUFFER_FILENAME));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        System.setOut(out);
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(new File("pom.xml"));
        request.setGoals(Arrays.asList("dependency:list"));
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            invoker.execute((InvocationRequest)request);
        }
        catch (MavenInvocationException e) {
            // empty catch block
        }
        System.out.flush();
        System.setOut(oldSystemOut);
        try {
            List<String> consoleOutputLines = Files.readAllLines(Paths.get(BUFFER_FILENAME, new String[0]), Charset.defaultCharset());
            for (String outputLine : consoleOutputLines) {
                System.out.println(outputLine);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private List<String> processCommandLineOutput() {
        List<String> outputLines = null;
        ArrayList<String> dependencies = new ArrayList<String>();
        try {
            outputLines = Files.readAllLines(Paths.get(BUFFER_FILENAME, new String[0]), Charset.defaultCharset());
        }
        catch (IOException e) {
            // empty catch block
        }
        String module = null;
        boolean dependencyBlock = false;
        for (int i = 0; i < outputLines.size(); ++i) {
            String processedLine;
            String line = outputLines.get(i);
            if (line.contains("maven-dependency-plugin")) {
                String partialModule = line.substring(line.indexOf("@"));
                module = partialModule.replace("@", "").replace("---", "").trim();
            }
            if (line.contains("The following files have been resolved:")) {
                dependencyBlock = true;
            } else if (line.replace("[INFO]", "").equals(" ") && dependencyBlock) {
                dependencyBlock = false;
            }
            if (!dependencyBlock || (processedLine = line.replace("[INFO]", "").trim()).contains("The following files have been resolved:") || processedLine.equals("none")) continue;
            System.out.println(module + ":" + processedLine);
            dependencies.add(module + ":" + processedLine);
        }
        return dependencies;
    }

    private List<Dependency> mapExtractedOutputLinesToDependencies(List<String> lines) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (String line : lines) {
            String[] dependencyParts = line.split(":");
            Dependency dependency = new Dependency();
            dependency.setGroupId(dependencyParts[1]);
            dependency.setArtifactId(dependencyParts[2]);
            dependency.setType(dependencyParts[3]);
            dependency.setVersion(dependencyParts[4]);
            dependency.setScope(dependencyParts[5]);
            dependencies.add(dependency);
            this.addDependencyToJSONPackage(dependency, dependencyParts[0]);
        }
        return dependencies;
    }

    private void cleanUp() {
        Path json = Paths.get(JSON_PACKAGE_FILENAME, new String[0]);
        Path buffer = Paths.get(BUFFER_FILENAME, new String[0]);
        if (Files.exists(json, new LinkOption[0])) {
            try {
                Files.delete(json);
            }
            catch (IOException e) {
                LOG.error("Error encountered on deleting json file: " + e.getMessage(), (Throwable)e);
            }
        }
        if (Files.exists(buffer, new LinkOption[0])) {
            try {
                Files.delete(buffer);
            }
            catch (IOException e) {
                LOG.error("Error encountered on deleting buffer file: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

