/*
 * Decompiled with CFR 0.152.
 */
package io.divide.server.endpoints;

import com.google.android.gcm.server.Message;
import com.google.android.gcm.server.MulticastResult;
import com.google.android.gcm.server.Sender;
import io.divide.server.auth.SecManager;
import io.divide.server.dao.DAOManager;
import io.divide.server.dao.Session;
import io.divide.server.utils.ResponseUtils;
import io.divide.shared.server.DAO;
import io.divide.shared.transitory.Credentials;
import io.divide.shared.transitory.EncryptedEntity;
import io.divide.shared.transitory.TransientObject;
import io.divide.shared.util.DaoUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Path(value="/push")
public class PushEndpoint {
    Logger logger = Logger.getLogger(PushEndpoint.class.getName());
    @Context
    DAOManager dao;
    @Context
    SecManager keyManager;

    @POST
    @Consumes(value={"application/json"})
    public Response register(@Context Session session, EncryptedEntity.Reader entity) {
        try {
            Credentials credentials = session.getUser();
            entity.setKey(this.keyManager.getPrivateKey());
            credentials.setPushMessagingKey(entity.get("token"));
            this.dao.save(new TransientObject[]{credentials});
        }
        catch (DAO.DAOException e) {
            this.logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
            return ResponseUtils.fromDAOExpection(e);
        }
        catch (Exception e) {
            this.logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
            return Response.serverError().entity((Object)"Shit").build();
        }
        return Response.ok().build();
    }

    @DELETE
    public Response unregister(@Context Session session) {
        try {
            Credentials credentials = session.getUser();
            credentials.setPushMessagingKey("");
            this.dao.save(new TransientObject[]{credentials});
        }
        catch (DAO.DAOException e) {
            this.logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
            return ResponseUtils.fromDAOExpection(e);
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/test/{email}/{data}")
    @Produces(value={"text/html"})
    public Response pushToDevice(@PathParam(value="email") String userId, @PathParam(value="data") String data) {
        try {
            String result = this.sendMessageToDevice(userId, data);
            return Response.ok().entity((Object)result).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    private String sendMessageToDevice(String email, String input) throws DAO.DAOException, IOException {
        Credentials user = DaoUtils.getUserByEmail((DAO)this.dao, (String)email);
        Sender sender = new Sender(this.keyManager.getPushKey());
        Message message = new Message.Builder().addData("body", input).build();
        MulticastResult result = sender.send(message, Arrays.asList(user.getPushMessagingKey()), 5);
        System.out.println("Result = " + result);
        return result.toString();
    }
}

