/*
 * Decompiled with CFR 0.152.
 */
package io.divide.server.endpoints;

import io.divide.server.dao.DAOManager;
import io.divide.server.dao.Session;
import io.divide.server.utils.ResponseUtils;
import io.divide.shared.server.DAO;
import io.divide.shared.transitory.Credentials;
import io.divide.shared.transitory.TransientObject;
import io.divide.shared.transitory.query.Query;
import io.divide.shared.util.ObjectUtils;
import java.util.Collection;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Path(value="/data")
public class DataEndpoint {
    private Logger logger = Logger.getLogger(DataEndpoint.class.getName());
    @Context
    DAOManager dao;

    @POST
    @Path(value="/get/{objectType}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="objectType") String objectType, Collection<String> keys) {
        try {
            this.logger.info("get: " + keys);
            return Response.ok().entity(this.dao.get(objectType, (String[])ObjectUtils.c2v(keys))).build();
        }
        catch (DAO.DAOException e) {
            return ResponseUtils.fromDAOExpection(e);
        }
    }

    @POST
    @Path(value="/query")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response query(@Context Session session, Query query) {
        try {
            this.logger.info("query: " + query);
            if (query.getFrom().equals(Credentials.class.getName())) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Query of Credentials is FORBIDDEN").build();
            }
            return Response.ok().entity(this.dao.query(query)).build();
        }
        catch (DAO.DAOException e) {
            return ResponseUtils.fromDAOExpection(e);
        }
    }

    @POST
    @Path(value="/save")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response save(Collection<ServerObject> objects) {
        try {
            this.logger.info("save: " + objects);
            this.dao.save((TransientObject[])ObjectUtils.c2v(objects));
            return Response.ok().build();
        }
        catch (DAO.DAOException e) {
            return ResponseUtils.fromDAOExpection(e);
        }
    }

    @GET
    @Path(value="/count/{objectType}")
    public Response count(@Context Session session, @PathParam(value="objectType") String objectType) {
        try {
            this.logger.info("count: " + objectType);
            int count = this.dao.count(objectType);
            return Response.ok().entity((Object)count).build();
        }
        catch (Exception e) {
            this.logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
            return Response.serverError().build();
        }
    }

    private static class ServerObject
    extends TransientObject {
        private ServerObject() {
            super(TransientObject.class);
        }

        protected Credentials getLoggedInUser() {
            return new Credentials("", "", ""){

                protected boolean isSystemUser() {
                    return true;
                }
            };
        }
    }
}

