/*
 * Decompiled with CFR 0.152.
 */
package io.divide.server.endpoints;

import io.divide.server.auth.SecManager;
import io.divide.server.auth.UserContext;
import io.divide.server.dao.DAOManager;
import io.divide.server.dao.Session;
import io.divide.server.utils.ResponseUtils;
import io.divide.shared.server.AuthServerLogic;
import io.divide.shared.server.DAO;
import io.divide.shared.server.KeyManager;
import io.divide.shared.transitory.Credentials;
import io.divide.shared.transitory.TransientObject;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Path(value="/auth")
public final class AuthenticationEndpoint {
    Logger logger = Logger.getLogger(AuthenticationEndpoint.class.getName());
    @Context
    DAOManager dao;
    @Context
    SecManager keyManager;
    private static Calendar c = Calendar.getInstance(TimeZone.getDefault());
    AuthServerLogic<TransientObject> authServerLogic;

    @PostConstruct
    public void init() {
        this.authServerLogic = new AuthServerLogic((DAO)this.dao, (KeyManager)this.keyManager);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response userSignUp(@Context ContainerRequestContext context, Credentials credentials) {
        try {
            Credentials toSave = this.authServerLogic.userSignUp(credentials);
            context.setSecurityContext((SecurityContext)new UserContext(context.getUriInfo(), toSave));
            this.logger.info("SignUp Successful. Returning: " + toSave);
            return ResponseUtils.ok(toSave);
        }
        catch (DAO.DAOException e) {
            this.logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
            return ResponseUtils.fromDAOExpection(e);
        }
        catch (Exception e) {
            this.logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
            return Response.serverError().build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response userSignIn(@Context ContainerRequestContext context, Credentials credentials) {
        try {
            Credentials dbCreds = this.authServerLogic.userSignIn(credentials);
            context.setSecurityContext((SecurityContext)new UserContext(context.getUriInfo(), dbCreds));
            this.logger.info("Login Successful. Returning: " + dbCreds);
            return ResponseUtils.ok(dbCreds);
        }
        catch (DAO.DAOException e) {
            this.logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
            return ResponseUtils.fromDAOExpection(e);
        }
        catch (Exception e) {
            this.logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/key")
    @Produces(value={"application/json"})
    public Response getPublicKey() {
        try {
            return Response.ok().entity((Object)this.authServerLogic.getPublicKey()).build();
        }
        catch (Exception e) {
            this.logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/validate/{token}")
    @Produces(value={"application/json"})
    public Response validateAccount(@PathParam(value="token") String token) {
        try {
            if (this.authServerLogic.validateAccount(token)) {
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (DAO.DAOException e) {
            return ResponseUtils.fromDAOExpection(e);
        }
    }

    @GET
    @Path(value="/from/{token}")
    @Produces(value={"application/json"})
    public Response getUserFromToken(@Context ContainerRequestContext context, @PathParam(value="token") String token) {
        try {
            this.logger.warning("getUserFromToken");
            Credentials user = this.authServerLogic.getUserFromAuthToken(token);
            context.setSecurityContext((SecurityContext)new UserContext(context.getUriInfo(), user));
            return Response.ok((Object)user).build();
        }
        catch (DAO.DAOException e) {
            e.printStackTrace();
            this.logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
            return ResponseUtils.fromDAOExpection(e);
        }
    }

    @GET
    @Path(value="/recover/{token}")
    @Produces(value={"application/json"})
    public Response recoverFromOneTimeToken(@Context ContainerRequestContext context, @PathParam(value="token") String token) {
        try {
            Credentials user = this.authServerLogic.getUserFromRecoveryToken(token);
            context.setSecurityContext((SecurityContext)new UserContext(context.getUriInfo(), user));
            return Response.ok((Object)user).build();
        }
        catch (DAO.DAOException e) {
            e.printStackTrace();
            this.logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
            return ResponseUtils.fromDAOExpection(e);
        }
    }

    @POST
    @Path(value="/user/data/{userId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response recieveUserData(@Context Session session, @PathParam(value="userId") String userId, Map<String, ?> data) {
        try {
            this.authServerLogic.recieveUserData(userId, data);
            return Response.ok().build();
        }
        catch (DAO.DAOException e) {
            this.logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
            return ResponseUtils.fromDAOExpection(e);
        }
    }

    @PUT
    @Path(value="/user/data/{userId}")
    @Produces(value={"application/json"})
    public Response sendUserData(@Context Session session, @PathParam(value="userId") String userId) {
        try {
            return Response.ok((Object)this.authServerLogic.sendUserData(userId)).build();
        }
        catch (Exception e) {
            return ResponseUtils.errorResponse(e);
        }
    }
}

