/*
 * Decompiled with CFR 0.152.
 */
package io.divide.server.dao;

import io.divide.dao.ServerDAO;
import io.divide.shared.event.Event;
import io.divide.shared.event.EventManager;
import io.divide.shared.server.DAO;
import io.divide.shared.transitory.TransientObject;
import io.divide.shared.transitory.query.Query;
import io.divide.shared.util.ObjectUtils;
import java.security.KeyPair;
import java.util.Collection;
import java.util.List;

public final class DAOManager
implements ServerDAO {
    public static final String ACTION_QUERY = "action_query";
    public static final String ACTION_GET = "action_get";
    public static final String ACTION_SAVE = "action_save";
    public static final String ACTION_DELETE = "action_delete";
    public static final String ACTION_EXISTS = "action_exists";
    private EventManager eventManager = EventManager.get();
    private ServerDAO serverDao;

    public DAOManager(ServerDAO serverDao) {
        this.serverDao = serverDao;
    }

    public <O extends TransientObject> Collection<O> get(String objectType, String ... keys) throws DAO.DAOException {
        Collection results = this.serverDao.get(objectType, keys);
        this.eventManager.fire(new GET_EVENT(results));
        return results;
    }

    public <O extends TransientObject> List<O> query(Query query) throws DAO.DAOException {
        List results = this.serverDao.query(query);
        this.eventManager.fire(new QUERY_EVENT(results));
        return results;
    }

    public void save(TransientObject ... objects) throws DAO.DAOException {
        this.serverDao.save(objects);
        this.eventManager.fire((Event)new SAVE_EVENT(objects));
    }

    public void delete(TransientObject ... objects) throws DAO.DAOException {
        this.serverDao.delete(objects);
        this.eventManager.fire((Event)new DELETE_EVENT(objects));
    }

    public boolean exists(TransientObject ... objects) {
        boolean exists = this.serverDao.exists(objects);
        this.eventManager.fire((Event)new EXISTS_EVENT(objects));
        return exists;
    }

    public int count(String objectType) {
        return this.serverDao.count(objectType);
    }

    public KeyPair keys(KeyPair keys) {
        return this.serverDao.keys(keys);
    }

    public static final class EXISTS_EVENT
    extends Event {
        Collection<TransientObject> transientObjects;

        protected EXISTS_EVENT(TransientObject ... object) {
            super(DAOManager.class);
            this.transientObjects = ObjectUtils.v2c((Object[])object);
        }
    }

    public static final class DELETE_EVENT
    extends Event {
        Collection<TransientObject> transientObjects;

        protected DELETE_EVENT(TransientObject ... object) {
            super(DAOManager.class);
            this.transientObjects = ObjectUtils.v2c((Object[])object);
        }
    }

    public static final class SAVE_EVENT
    extends Event {
        Collection<TransientObject> transientObjects;

        protected SAVE_EVENT(TransientObject ... object) {
            super(DAOManager.class);
            this.transientObjects = ObjectUtils.v2c((Object[])object);
        }
    }

    public static final class GET_EVENT<T extends TransientObject>
    extends Event {
        Collection<T> transientObjects;

        protected GET_EVENT(Collection<T> transientObjects) {
            super(DAOManager.class);
            this.transientObjects = transientObjects;
        }
    }

    public static final class QUERY_EVENT<T extends TransientObject>
    extends Event {
        Collection<T> transientObjects;

        protected QUERY_EVENT(Collection<T> transientObjects) {
            super(DAOManager.class);
            this.transientObjects = transientObjects;
        }
    }
}

