/*
 * Decompiled with CFR 0.152.
 */
package io.divide.server.dao;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.divide.shared.transitory.Credentials;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CredentialBodyHandler<T extends Credentials>
implements MessageBodyWriter<T> {
    public static final Logger logger = Logger.getLogger(CredentialBodyHandler.class.getName());
    private static final String UTF_8 = "UTF-8";
    private Gson gson;
    private SecurityContext context;

    public CredentialBodyHandler(@Context SecurityContext context) {
        this.context = context;
    }

    private Gson getGson() {
        if (this.gson == null) {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.enableComplexMapKeySerialization();
            gsonBuilder.setPrettyPrinting();
            this.gson = gsonBuilder.create();
        }
        return this.gson;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Credentials.class.isAssignableFrom(type);
    }

    public long getSize(T object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(T object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        OutputStreamWriter writer = new OutputStreamWriter(entityStream, UTF_8);
        try {
            Type jsonType = type.equals(genericType) ? type : genericType;
            if (!CredentialBodyHandler.match(object, this.context)) {
                object = object.getSafe();
            }
            this.getGson().toJson(object, jsonType, (Appendable)writer);
            logger.info("sending: " + object);
        }
        finally {
            writer.close();
        }
    }

    private static final boolean match(Credentials credentials, SecurityContext context) {
        if (credentials == null) {
            logger.warning("credentials null");
            return false;
        }
        if (credentials.getEmailAddress() == null) {
            logger.warning("credentials.getEmailAddress() null");
            return false;
        }
        if (context == null) {
            logger.warning("context null");
            return false;
        }
        if (context.getUserPrincipal() == null) {
            logger.warning("context.getUserPrincipal() null");
            return false;
        }
        if (context.getUserPrincipal().getName() == null) {
            logger.warning("context.getUserPrincipal().getName() null");
            return false;
        }
        logger.info("Logged In: " + credentials.getEmailAddress() + "\n" + "Returning: " + context.getUserPrincipal().getName());
        return credentials.getEmailAddress().equals(context.getUserPrincipal().getName());
    }
}

