/*
 * Decompiled with CFR 0.152.
 */
package io.divide.server.auth;

import io.divide.shared.transitory.Credentials;
import java.security.Principal;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

public class UserContext
implements SecurityContext {
    private Credentials creds;
    private UriInfo uriInfo;
    private Principal principal;

    public UserContext(UriInfo uriInfo, final Credentials user) {
        this.uriInfo = uriInfo;
        this.creds = user;
        this.principal = new Principal(){

            @Override
            public String getName() {
                return user.getEmailAddress();
            }
        };
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        if ("admin".equals(role)) {
            return "admin".equals(this.principal.getName());
        }
        if ("user".equals(role)) {
            if ("admin".equals(this.principal.getName())) {
                return true;
            }
            String pathParam = (String)this.uriInfo.getPathParameters().getFirst((Object)"username");
            if (pathParam != null && this.principal.getName().endsWith(pathParam)) {
                return true;
            }
        }
        return false;
    }

    public boolean isSecure() {
        return "https".equals(this.uriInfo.getRequestUri().getScheme());
    }

    public String getAuthenticationScheme() {
        return "BASIC";
    }

    public Credentials getUser() {
        return this.creds;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }
}

