/*
 * Decompiled with CFR 0.152.
 */
package io.divide.server.auth;

import io.divide.server.auth.SecManager;
import io.divide.server.auth.UserContext;
import io.divide.server.dao.DAOManager;
import io.divide.server.dao.ServerCredentials;
import io.divide.server.utils.ResponseUtils;
import io.divide.shared.server.DAO;
import io.divide.shared.transitory.Credentials;
import io.divide.shared.transitory.TransientObject;
import io.divide.shared.transitory.query.OPERAND;
import io.divide.shared.transitory.query.Query;
import io.divide.shared.transitory.query.QueryBuilder;
import io.divide.shared.transitory.query.SelectOperation;
import io.divide.shared.util.AuthTokenUtils;
import io.divide.shared.util.ObjectUtils;
import java.io.IOException;
import java.util.logging.Logger;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

public class SecurityFilter
implements ContainerRequestFilter {
    Logger log = Logger.getLogger(SecurityFilter.class.getName());
    @Context
    DAOManager dao;
    @Context
    SecManager securityManager;

    public void filter(ContainerRequestContext request) throws IOException {
        this.log.info("Filter(): " + request.getUriInfo().getPath());
        String path = request.getUriInfo().getPath();
        if (!path.startsWith("/auth/user/data") && !path.startsWith("/auth/user/data/") && (path.startsWith("auth") || path.startsWith("/auth") || this.securityManager.getSafePaths().contains(path))) {
            this.log.info("Auth Skipped : (" + path + ")");
            return;
        }
        UserContext context = this.authenticate(request);
        if (context != null) {
            this.log.info("Authenticated: " + context.getUser().getEmailAddress());
        } else {
            this.log.info("Authentication Failed");
        }
        request.setProperty("SESSION_KEY", (Object)context);
        request.setSecurityContext((SecurityContext)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserContext authenticate(ContainerRequestContext request) {
        String authentication = request.getHeaderString("Authorization");
        System.out.println("HeaderCount: " + request.getHeaders().keySet().size());
        System.out.println(request.getHeaders().keySet());
        System.out.println(request.getPropertyNames());
        System.out.println(request.getCookies().keySet());
        if (authentication == null) {
            return this.abort(request, "Authentication credentials are required");
        }
        if (!authentication.startsWith("CUSTOM ")) {
            return this.abort(request, "Only CUSTOM authentication is supported: " + authentication);
        }
        String token = authentication = authentication.substring("CUSTOM ".length());
        if (token == null) {
            return this.abort(request, "Missing token");
        }
        try {
            AuthTokenUtils.AuthToken authToken = new AuthTokenUtils.AuthToken(this.securityManager.getSymmetricKey(), token);
            if (authToken.isExpired()) {
                return this.abort(request, "Auth Token Expired: " + System.currentTimeMillis() + " : " + authToken.expirationDate);
            }
        }
        catch (AuthTokenUtils.AuthenticationException e) {
            return this.abort(request, "Auth Token Expired: " + e.getMessage());
        }
        DAOManager dAOManager = this.dao;
        synchronized (dAOManager) {
            Query q = new QueryBuilder().select(new SelectOperation[0]).from(Credentials.class).where(Credentials.AUTH_TOKEN_KEY, OPERAND.EQ, token).build();
            try {
                TransientObject temp = (TransientObject)ObjectUtils.get1stOrNull(this.dao.query(q));
                if (temp != null) {
                    ServerCredentials creds = new ServerCredentials(temp);
                    return new UserContext(request.getUriInfo(), new ServerCredentials((TransientObject)creds));
                }
                request.abortWith(ResponseUtils.notAuthReponse("Invalid authentication token"));
                return this.abort(request, "Invalid authentication token");
            }
            catch (DAO.DAOException e) {
                this.log.severe("Authentication Failed(" + e.getStatusCode() + ") " + e.getMessage());
                e.printStackTrace();
                return this.abort(request, "Invalid authentication token");
            }
        }
    }

    private UserContext abort(ContainerRequestContext request, String message) {
        this.log.warning("Auth Failed: " + message);
        request.abortWith(ResponseUtils.notAuthReponse(message));
        return null;
    }
}

