/*
 * Decompiled with CFR 0.152.
 */
package io.divide.server.auth;

import io.divide.dao.ServerDAO;
import io.divide.shared.server.KeyManager;
import io.divide.shared.util.Crypto;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SecManager
implements KeyManager {
    private ServerDAO dao;
    private String encryptionKey;
    private String pushKey;
    private KeyPair cachedKeys = null;
    private List<String> safePaths = new ArrayList<String>(Arrays.asList("", "/"));

    public SecManager(ServerDAO dao, String encryptionKey) {
        this.dao = dao;
        this.encryptionKey = encryptionKey;
    }

    private synchronized KeyPair getKeys() {
        if (this.cachedKeys != null) {
            return this.cachedKeys;
        }
        this.cachedKeys = this.dao.keys(null);
        if (this.cachedKeys == null) {
            try {
                this.cachedKeys = Crypto.getNew();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            this.dao.keys(this.cachedKeys);
        }
        return this.cachedKeys;
    }

    public PublicKey getPublicKey() {
        return this.getKeys().getPublic();
    }

    public PrivateKey getPrivateKey() {
        return this.getKeys().getPrivate();
    }

    public String getSymmetricKey() {
        return this.encryptionKey;
    }

    public String getPushKey() {
        return this.pushKey;
    }

    public List<String> getSafePaths() {
        return this.safePaths;
    }

    public void addSafePath(String path) {
        this.safePaths.add(path);
    }
}

