/*
 * Decompiled with CFR 0.152.
 */
package io.divide.server.auth;

import io.divide.server.auth.EnforcePath;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.ws.rs.Path;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"io.divide.authenticator.server.auth.EnforcePath"})
public class EnforcePathProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(EnforcePath.class);
        for (Element element : elements) {
            Path path = element.getAnnotation(Path.class);
            if (path == null || path.value() == null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Java class " + element.getSimpleName().toString() + " must have a @Path annotation");
                continue;
            }
            if (path.value().equals("/auth")) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Java class " + element.getSimpleName().toString() + " must have a @Path(\"/auth\") annotation");
        }
        return false;
    }
}

