/*
 * Decompiled with CFR 0.152.
 */
package io.divide.server;

import io.divide.dao.ServerDAO;
import io.divide.server.auth.ResponseFilter;
import io.divide.server.auth.SecManager;
import io.divide.server.auth.SecurityFilter;
import io.divide.server.auth.UserContext;
import io.divide.server.dao.CredentialBodyHandler;
import io.divide.server.dao.DAOManager;
import io.divide.server.dao.GsonMessageBodyHandler;
import io.divide.server.dao.Session;
import io.divide.server.endpoints.AuthenticationEndpoint;
import io.divide.server.endpoints.DataEndpoint;
import io.divide.server.endpoints.MetaEndpoint;
import io.divide.server.endpoints.PushEndpoint;
import java.util.logging.Logger;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;

public abstract class AuthApplication<T extends ServerDAO>
extends ResourceConfig {
    private static final Logger logger = Logger.getLogger(AuthApplication.class.getSimpleName());

    public AuthApplication(T t, String encryptionKey) {
        this(new MyBinder<T>(t, encryptionKey));
    }

    public AuthApplication(Class<T> daoClass, String encryptionKey) {
        this(new MyBinder<T>(daoClass, encryptionKey));
    }

    private AuthApplication(MyBinder binder) {
        logger.finest("STARTING: " + ((Object)((Object)this)).getClass().getSimpleName());
        logger.info("DAO: " + binder.getDAOName());
        this.reg(AuthenticationEndpoint.class);
        this.reg(DataEndpoint.class);
        this.reg(PushEndpoint.class);
        this.reg(MetaEndpoint.class);
        this.reg(CredentialBodyHandler.class);
        this.reg(GsonMessageBodyHandler.class);
        this.reg(SecurityFilter.class);
        this.reg(ResponseFilter.class);
        this.register((Object)binder);
        this.property("jersey.config.workers.legacyOrdering", true);
    }

    private void reg(Class<?> clazz) {
        this.register(clazz);
    }

    private void isReg(Object o) {
        logger.info("isRegistered(" + o.getClass().getSimpleName() + "): " + this.isRegistered(o));
    }

    private void isReg(Class<?> clazz) {
        logger.info("isRegistered(" + clazz.getSimpleName() + "): " + this.isRegistered(clazz));
    }

    private static class MyBinder<T extends ServerDAO>
    extends AbstractBinder {
        private Class<T> clazz;
        private T t;
        private String encryptionKey;

        public MyBinder(T dao, String encryptionKey) {
            this.t = dao;
            this.encryptionKey = encryptionKey;
        }

        public MyBinder(Class<T> daoClass, String encryptionKey) {
            this.clazz = daoClass;
            this.encryptionKey = encryptionKey;
        }

        protected void configure() {
            try {
                System.out.println("Class: " + this.clazz + " : " + this.t);
                if (this.t == null) {
                    this.t = (ServerDAO)this.clazz.newInstance();
                }
                DAOManager manager = new DAOManager((ServerDAO)this.t);
                this.bind(manager).to(DAOManager.class);
                this.bind(new SecManager(manager, this.encryptionKey)).to(SecManager.class);
                this.bind(UserContext.class).to(SecurityContext.class);
                this.bind(Session.class).to(Session.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String getDAOName() {
            if (this.t != null) {
                return this.t.getClass().getSimpleName();
            }
            return this.clazz.getSimpleName();
        }
    }
}

