/*
 * Decompiled with CFR 0.152.
 */
package io.divide.server.endpoints;

import io.divide.server.ServerTest;
import io.divide.server.TestUtils;
import io.divide.server.endpoints.AuthenticationEndpointTest;
import io.divide.shared.transitory.Credentials;
import io.divide.shared.transitory.EncryptedEntity;
import io.divide.shared.transitory.TransientObject;
import io.divide.shared.transitory.query.Query;
import io.divide.shared.transitory.query.QueryBuilder;
import io.divide.shared.transitory.query.SelectOperation;
import io.divide.shared.util.ObjectUtils;
import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.test.JerseyTest;
import org.junit.Assert;
import org.junit.Test;

public class PushEndpointTest
extends ServerTest {
    private Response registerToken(Credentials user, PublicKey key, JerseyTest test) {
        EncryptedEntity.Writter entity = new EncryptedEntity.Writter(key);
        entity.put("token", "whatwhat");
        Response response = this.target("/push").request().header("Authorization", (Object)("CUSTOM " + user.getAuthToken())).buildPost(TestUtils.toEntity(entity)).invoke();
        int statusCode = response.getStatus();
        Assert.assertEquals((long)200L, (long)statusCode);
        return response;
    }

    @Test
    public void testRegister() throws Exception {
        Credentials user = AuthenticationEndpointTest.signUpUser(this);
        PublicKey key = AuthenticationEndpointTest.getPublicKey(this);
        this.registerToken(user, key, this);
        List list = this.container.serverDao.query(new QueryBuilder().select(new SelectOperation[0]).from(Credentials.class).build());
        TransientObject o = (TransientObject)ObjectUtils.get1stOrNull((Collection)list);
        user = TestUtils.convert(o, Credentials.class);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"whatwhat", (Object)user.getPushMessagingKey());
    }

    @Test
    public void testUnregister() throws Exception {
        Credentials user = AuthenticationEndpointTest.signUpUser(this);
        PublicKey key = AuthenticationEndpointTest.getPublicKey(this);
        Response tokenResponse = this.registerToken(user, key, this);
        String newAuthToken = tokenResponse.getHeaderString("Authorization");
        Response response = this.target("/push").request().header("Authorization", (Object)("CUSTOM " + newAuthToken)).delete();
        int statusCode = response.getStatus();
        Assert.assertEquals((long)200L, (long)statusCode);
        Collection list = this.container.serverDao.get(Query.safeTable(Credentials.class), new String[]{user.getObjectKey()});
        TransientObject o = (TransientObject)ObjectUtils.get1stOrNull((Collection)list);
        user = TestUtils.convert(o, Credentials.class);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"", (Object)user.getPushMessagingKey());
    }
}

