/*
 * Decompiled with CFR 0.152.
 */
package io.divide.server.endpoints;

import io.divide.server.ServerTest;
import io.divide.server.TestUtils;
import io.divide.shared.transitory.Credentials;
import io.divide.shared.util.Crypto;
import java.net.URLEncoder;
import java.security.PublicKey;
import org.glassfish.jersey.test.JerseyTest;
import org.junit.Assert;
import org.junit.Test;

public class AuthenticationEndpointTest
extends ServerTest {
    @Test
    public void testGetPublicKey() throws Exception {
        AuthenticationEndpointTest.getPublicKey(this);
    }

    public static synchronized PublicKey getPublicKey(JerseyTest test) throws Exception {
        String publicKeyBytes = (String)test.target("/auth/key").request().get(String.class);
        byte[] bytes = (byte[])TestUtils.getGson().fromJson(publicKeyBytes, byte[].class);
        return Crypto.pubKeyFromBytes((byte[])bytes);
    }

    @Test
    public void testUserSignUp() throws Exception {
        AuthenticationEndpointTest.signUpUser(this);
    }

    public static synchronized Credentials signUpUser(JerseyTest test) throws Exception {
        PublicKey publicKey = AuthenticationEndpointTest.getPublicKey(test);
        Credentials signInUser = TestUtils.getTestUser();
        signInUser.encryptPassword(publicKey);
        String user = (String)test.target("/auth").request().post(TestUtils.toEntity(signInUser), String.class);
        Credentials returnedUser = (Credentials)TestUtils.getGson().fromJson(user, Credentials.class);
        Assert.assertEquals((Object)signInUser.getUsername(), (Object)returnedUser.getUsername());
        return returnedUser;
    }

    @Test
    public void testUserSignIn() throws Exception {
        Credentials user = AuthenticationEndpointTest.signUpUser(this);
        System.out.println("User1:" + TestUtils.getTestUser());
        user.setPassword(TestUtils.getTestUser().getPassword());
        user.encryptPassword(AuthenticationEndpointTest.getPublicKey(this));
        this.target("/auth").request().put(TestUtils.toEntity(user), String.class);
    }

    @Test
    public void testGetUserFromToken() throws Exception {
        Credentials user = AuthenticationEndpointTest.signUpUser(this);
        String token = user.getAuthToken();
        token = URLEncoder.encode(token, "UTF-8");
        int status = this.target("/auth/from/").path(token).request().buildGet().invoke().getStatus();
        Assert.assertEquals((long)200L, (long)status);
    }

    @Test
    public void testRecoverUserFromToken() throws Exception {
        Credentials user = AuthenticationEndpointTest.signUpUser(this);
        String token = user.getRecoveryToken();
        token = URLEncoder.encode(token, "ISO-8859-1");
        int status = this.target("/auth/recover/").path(token).request().buildGet().invoke().getStatus();
        Assert.assertEquals((long)200L, (long)status);
    }

    @Test
    public void testGetUserData() throws Exception {
        Credentials user = AuthenticationEndpointTest.signUpUser(this);
        int statusCode = this.target("/auth/user/data/" + user.getOwnerId()).request().header("Authorization", (Object)("CUSTOM " + user.getAuthToken())).put(TestUtils.toEntity(1)).getStatus();
        Assert.assertEquals((long)200L, (long)statusCode);
    }
}

