/*
 * Decompiled with CFR 0.152.
 */
package io.divide.server;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.grizzly2.servlet.GrizzlyWebContainerFactory;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.test.spi.TestContainer;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;

public class WebContainerFactory
implements TestContainerFactory {
    private static int count = 0;
    private static boolean incrementPort = true;

    private static synchronized int getCount() {
        if (incrementPort) {
            return count++;
        }
        return count;
    }

    public void enableEncrementPort(boolean incrementPort) {
        WebContainerFactory.incrementPort = incrementPort;
    }

    public TestContainer create(URI baseUri, ApplicationHandler application) throws IllegalArgumentException {
        URI uri = UriBuilder.fromUri((URI)baseUri).port(baseUri.getPort() + WebContainerFactory.getCount()).build(new Object[0]);
        System.out.println("Uri: " + uri);
        System.out.println("App: " + application.getConfiguration().getApplication().getClass().getName());
        return new MyTestContainer(uri, application);
    }

    private static class MyTestContainer
    implements TestContainer {
        private final URI uri;
        private final ApplicationHandler appHandler;
        private HttpServer server;
        private static final Logger LOGGER = Logger.getLogger(WebContainerFactory.class.getName());

        private MyTestContainer(URI uri, ApplicationHandler appHandler) {
            this.appHandler = appHandler;
            this.uri = uri;
            System.out.println(uri);
        }

        public ClientConfig getClientConfig() {
            return null;
        }

        public URI getBaseUri() {
            return this.uri;
        }

        public void start() {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Starting GrizzlyTestContainer...");
            }
            try {
                this.server = GrizzlyWebContainerFactory.create((URI)this.uri, Collections.singletonMap("javax.ws.rs.Application", this.appHandler.getConfiguration().getApplication().getClass().getName()));
            }
            catch (ProcessingException e) {
                throw new TestContainerException((Throwable)e);
            }
            catch (IOException e) {
                throw new TestContainerException((Throwable)e);
            }
        }

        public void stop() {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Stopping GrizzlyTestContainer...");
            }
            this.server.shutdownNow();
        }
    }
}

