/*
 * Decompiled with CFR 0.152.
 */
package io.divide.server;

import com.google.gson.Gson;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import io.divide.dao.ServerDAO;
import io.divide.dao.orientdb.OrientDBDao;
import io.divide.server.AuthApplication;
import io.divide.server.TestApplication;
import io.divide.server.dao.ServerCredentials;
import io.divide.shared.server.DAO;
import io.divide.shared.transitory.Credentials;
import io.divide.shared.transitory.FilePermissions;
import io.divide.shared.transitory.TransientObject;
import io.divide.shared.transitory.query.QueryBuilder;
import io.divide.shared.util.AuthTokenUtils;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;

public class TestUtils {
    public static final String KEY = "saywhatwhat";
    private static Gson gson = new Gson();

    public static TestWrapper setUp() {
        TestWrapper container = new TestWrapper();
        container.time = System.nanoTime();
        container.db = (ODatabaseRecord)new ODatabaseDocumentTx("memory:default");
        if (container.db.exists()) {
            container.db.open("admin", "admin");
        } else {
            container.db.create();
        }
        container.serverDao = new OrientDBDao((ODatabaseDocument)container.db);
        try {
            container.serverDao.query(new QueryBuilder().delete().from(Credentials.class).build());
        }
        catch (DAO.DAOException e) {
            e.printStackTrace();
        }
        container.app = new TestApplication(container.serverDao);
        return container;
    }

    public static Credentials getTestUser() {
        Credentials c = new Credentials("someUsername", "someEmail", "somePassword");
        ServerCredentials sc = new ServerCredentials((TransientObject)c);
        sc.setOwnerId(Integer.valueOf(1));
        FilePermissions fp = sc.getFilePermissions();
        fp.setReadable(true, new FilePermissions.Level[]{FilePermissions.Level.WORLD});
        fp.setWritable(true, new FilePermissions.Level[]{FilePermissions.Level.WORLD});
        sc.setFilePermissions(fp);
        sc.setAuthToken(AuthTokenUtils.getNewToken((String)KEY, (Credentials)sc));
        sc.setRecoveryToken(AuthTokenUtils.getNewToken((String)KEY, (Credentials)sc));
        return sc;
    }

    public static Entity<String> toEntity(Object o) {
        return Entity.entity((Object)TestUtils.getGson().toJson(o), (MediaType)MediaType.APPLICATION_JSON_TYPE);
    }

    public static Entity<String> getTestUserEntity() throws Exception {
        return Entity.entity((Object)TestUtils.getGson().toJson((Object)TestUtils.getTestUser()), (MediaType)MediaType.APPLICATION_JSON_TYPE);
    }

    public static <T extends TransientObject> T convert(TransientObject o, Class<T> to) {
        return (T)((TransientObject)gson.fromJson(gson.toJson((Object)o), to));
    }

    public static Gson getGson() {
        return gson;
    }

    public static class TestWrapper {
        private ODatabaseRecord db;
        public ServerDAO serverDao;
        public AuthApplication app;
        public long time;

        public void tearDown() throws DAO.DAOException {
            this.serverDao.query(new QueryBuilder().delete().from(Credentials.class).build());
            this.db.drop();
            this.db.close();
        }
    }
}

