/*
 * Decompiled with CFR 0.152.
 */
package io.divide.server;

import io.divide.server.TestUtils;
import io.divide.server.auth.SecManager;
import io.divide.server.dao.DAOManager;
import io.divide.server.dao.ServerCredentials;
import io.divide.shared.server.DAO;
import io.divide.shared.transitory.Credentials;
import io.divide.shared.transitory.TransientObject;
import io.divide.shared.transitory.query.QueryBuilder;
import io.divide.shared.util.AuthTokenUtils;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.mindrot.jbcrypt.BCrypt;

@Path(value="/test")
public class TestEndpoint {
    private Logger logger = Logger.getLogger(TestEndpoint.class.getName());
    @Inject
    SecManager securityManager;
    @Context
    DAOManager dao;

    @PostConstruct
    private void addPaths() {
        this.securityManager.addSafePath("/test/setup");
        this.securityManager.addSafePath("/test/teardown");
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/setup")
    public Response setup() throws Exception {
        ServerCredentials toSave = new ServerCredentials((TransientObject)TestUtils.getTestUser());
        String ha = BCrypt.hashpw((String)toSave.getPassword(), (String)BCrypt.gensalt((int)10));
        toSave.setPassword(ha);
        toSave.setAuthToken(AuthTokenUtils.getNewToken((String)this.securityManager.getSymmetricKey(), (Credentials)toSave));
        toSave.setRecoveryToken(AuthTokenUtils.getNewToken((String)this.securityManager.getSymmetricKey(), (Credentials)toSave));
        toSave.setOwnerId(Integer.valueOf(this.dao.count(Credentials.class.getName()) + 1));
        this.dao.save(new TransientObject[]{toSave});
        return Response.ok().entity((Object)toSave).build();
    }

    @GET
    @Path(value="/teardown")
    public Response tearDown() {
        this.logger.info("teardown");
        try {
            this.dao.query(new QueryBuilder().delete().from(Credentials.class).build());
        }
        catch (DAO.DAOException e) {
            e.printStackTrace();
        }
        return Response.ok().build();
    }
}

