/*
 * Decompiled with CFR 0.152.
 */
package io.divide.server;

import io.divide.server.TestApplication;
import io.divide.server.TestUtils;
import io.divide.server.WebContainerFactory;
import io.divide.shared.server.DAO;
import io.divide.shared.transitory.Credentials;
import java.net.URI;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.test.spi.TestContainer;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.http.GET;

public class AuthServerHelper {
    TestContainer container;
    final Credentials admin = TestUtils.getTestUser();
    final String token = "CUSTOM " + this.admin.getAuthToken();
    private TestService testService;

    public void init(String url) throws Exception {
        URI uri = URI.create(url);
        ApplicationHandler h = new ApplicationHandler(TestApplication.class);
        WebContainerFactory factory = new WebContainerFactory();
        factory.enableEncrementPort(false);
        this.container = factory.create(uri, h);
        this.container.start();
    }

    public void destroy() {
        if (this.container != null) {
            this.container.stop();
        }
    }

    public void setUp(String url) throws DAO.DAOException {
        TestService service = this.buildTestService(url);
        service.setup();
    }

    public void tearDown(String url) throws Exception {
        TestService service = this.buildTestService(url);
        service.tearDown();
    }

    private TestService buildTestService(String url) {
        if (this.testService == null) {
            RestAdapter restAdapter = new RestAdapter.Builder().setClient((Client)new OkClient()).setEndpoint(url).setLogLevel(RestAdapter.LogLevel.FULL).setLog(new RestAdapter.Log(){

                public void log(String s) {
                    System.out.println(s);
                }
            }).build();
            this.testService = (TestService)restAdapter.create(TestService.class);
        }
        return this.testService;
    }

    private static interface TestService {
        @GET(value="/test/setup")
        public Credentials setup();

        @GET(value="/test/teardown")
        public Response tearDown();
    }
}

