/*
 * Decompiled with CFR 0.152.
 */
package io.divide.dao;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.divide.dao.Keyable;
import io.divide.dao.TestObject1;
import io.divide.dao.TestObject2;
import io.divide.shared.server.DAO;
import io.divide.shared.transitory.TransientObject;
import io.divide.shared.transitory.query.OPERAND;
import io.divide.shared.transitory.query.Query;
import io.divide.shared.transitory.query.QueryBuilder;
import io.divide.shared.transitory.query.SelectOperation;
import io.divide.shared.util.ObjectUtils;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class DAOTest<BaseObject extends Keyable> {
    protected DAO dao;
    public static final TestObject1 testObject1 = new TestObject1("key1", "1", "key2", "value2", "key3", "value3");
    public static final TestObject1 testObject2 = new TestObject1("key1", "3", "key2", "value2", "key3", "value3");
    public static final TestObject1 testObject3 = new TestObject1("key1", "1", "key2", "2", "key3", "value3");
    public static final TestObject2 testObject4 = new TestObject2("key1", "1", "key2", "2", "key3", "value3");
    BaseObject object1;
    BaseObject object2;
    BaseObject object3;
    BaseObject object4;
    String testObject1Table = Query.safeTable(TestObject1.class);
    String testObject2Table = Query.safeTable(TestObject2.class);

    protected DAOTest(DAO dao) {
        this.dao = dao;
    }

    @Before
    public void setUp() {
        this.object1 = this.toBaseObject(testObject1);
        this.object2 = this.toBaseObject(testObject2);
        this.object3 = this.toBaseObject(testObject3);
        this.object4 = this.toBaseObject(testObject4);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testQuery() throws Exception {
        this.rawSave(new Keyable[]{this.object1, this.object2, this.object3, this.object4});
        String key = testObject1.getObjectKey();
        Query q = new QueryBuilder().select(new SelectOperation[0]).from(TestObject1.class).where(TransientObject.OBJECT_KEY, OPERAND.EQ, key).build();
        List results = this.dao.query(q);
        Assert.assertNotNull((String)"1.", (Object)results);
        Assert.assertEquals((String)"2.", (long)1L, (long)results.size());
        TransientObject to = (TransientObject)ObjectUtils.get1stOrNull((Collection)results);
        Assert.assertEquals((String)(results + ""), (Object)to.getObjectKey(), (Object)testObject1.getObjectKey());
        q = new QueryBuilder().select(new SelectOperation[0]).from(TestObject1.class).build();
        results = this.dao.query(q);
        Assert.assertNotEquals((String)"Select All", null, (Object)results);
        Assert.assertEquals((String)"Select All", (long)3L, (long)results.size());
        q = new QueryBuilder().select(new SelectOperation[0]).from(TestObject1.class).where("key1", OPERAND.EQ, "1").build();
        results = this.dao.query(q);
        Assert.assertNotEquals((String)"key1=", null, (Object)results);
        Assert.assertEquals((String)"key1=", (long)2L, (long)results.size());
        q = new QueryBuilder().select(new SelectOperation[0]).from(TestObject1.class).where("key1", OPERAND.GREATER_THAN, "1").build();
        results = this.dao.query(q);
        Assert.assertNotEquals((String)"key1>", null, (Object)results);
        Assert.assertEquals((String)"key1>", (long)1L, (long)results.size());
        q = new QueryBuilder().select(new SelectOperation[0]).from(TestObject1.class).where("key1", OPERAND.GREATER_THAN_EQ, "1").build();
        results = this.dao.query(q);
        Assert.assertNotEquals((String)"key1>=", null, (Object)results);
        Assert.assertEquals((String)"key1>=", (long)3L, (long)results.size());
        q = new QueryBuilder().select(new SelectOperation[0]).from(TestObject1.class).where("key1", OPERAND.LESS_THAN, "3").build();
        results = this.dao.query(q);
        Assert.assertNotEquals((String)"key1<", null, (Object)results);
        Assert.assertEquals((String)"key1<", (long)2L, (long)results.size());
        q = new QueryBuilder().select(new SelectOperation[0]).from(TestObject1.class).where("key1", OPERAND.LESS_THAN_EQ, "3").build();
        results = this.dao.query(q);
        Assert.assertNotEquals((String)"key1<=", null, (Object)results);
        Assert.assertEquals((String)"key1<=", (long)3L, (long)results.size());
        q = new QueryBuilder().select(new SelectOperation[0]).from(TestObject2.class).where("key1", OPERAND.EQ, "1").or("key2", OPERAND.EQ, "2").build();
        results = this.dao.query(q);
        Assert.assertNotEquals((String)"2where", null, (Object)results);
        Assert.assertEquals((String)"2where", (long)1L, (long)results.size());
        Assert.assertEquals((String)"2where", (Object)testObject4.getObjectKey(), (Object)((TransientObject)ObjectUtils.get1stOrNull((Collection)results)).getObjectKey());
        q = new QueryBuilder().select(new SelectOperation[0]).from(TestObject1.class).where("key1", OPERAND.LESS_THAN_EQ, "3").limit(Integer.valueOf(2)).build();
        results = this.dao.query(q);
        Assert.assertNotEquals((String)"limit test failed", null, (Object)results);
        Assert.assertEquals((String)"limit test failed", (long)2L, (long)results.size());
    }

    @Test
    public void testQueryEmbededCollections() throws Exception {
        TestObject1 t1 = new TestObject1();
        List<String> l1 = Arrays.asList("2");
        t1.put("players_key", l1);
        System.out.println("embeded: " + Arrays.asList(t1));
        TestObject1 t2 = new TestObject1();
        List<String> l2 = Arrays.asList("3", "4", "5");
        t2.put("players_key", l2);
        this.dao.save(new TransientObject[]{t1, t2});
        Query q = new QueryBuilder().select(new SelectOperation[0]).from(TestObject1.class).where("players_key", OPERAND.CONTAINS, "2").build();
        List results = this.dao.query(q);
        Assert.assertNotEquals(null, (Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)t1.getObjectKey(), (Object)((TransientObject)ObjectUtils.get1stOrNull((Collection)results)).getObjectKey());
        Assert.assertEquals(l1, (Object)((TransientObject)ObjectUtils.get1stOrNull((Collection)results)).get(l1.getClass(), "players_key"));
        q = new QueryBuilder().select(new SelectOperation[0]).from(TestObject1.class).where("players_key", OPERAND.CONTAINS, "4").build();
        results = this.dao.query(q);
        Assert.assertNotEquals(null, (Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)t2.getObjectKey(), (Object)((TransientObject)ObjectUtils.get1stOrNull((Collection)results)).getObjectKey());
        Assert.assertEquals(l2, (Object)((TransientObject)ObjectUtils.get1stOrNull((Collection)results)).get(l2.getClass(), "players_key"));
        Gson g = new GsonBuilder().create();
        g.fromJson(g.toJson((Object)t1), TransientObject.class);
    }

    @Test
    public void testGet() throws Exception {
        this.rawSave(new Keyable[]{this.object1, this.object2, this.object3, this.object4});
        String[] keys = new String[]{this.object1.getKey(), this.object3.getKey()};
        Collection results = this.dao.get(this.testObject1Table, keys);
        Assert.assertNotEquals(null, (Object)results);
        Assert.assertEquals((String)String.valueOf(results), (long)2L, (long)results.size());
        String[] keys2 = new String[]{this.object1.getKey(), this.object2.getKey(), this.object3.getKey(), this.object4.getKey()};
        results = this.dao.get(this.testObject2Table, keys2);
        Assert.assertNotEquals(null, (Object)results);
        Assert.assertEquals((String)(results + ""), (long)1L, (long)results.size());
    }

    @Test
    public void testSave() throws Exception {
        this.dao.save(new TransientObject[]{testObject1, testObject2});
        String testObject1Table = Query.safeTable(TestObject1.class);
        Collection results = this.dao.get(testObject1Table, new String[]{testObject1.getObjectKey(), testObject2.getObjectKey()});
        Assert.assertNotEquals(null, (Object)results);
        Assert.assertEquals((String)String.valueOf(results), (long)2L, (long)results.size());
        Assert.assertEquals(null, (Object)testObject1.get(String.class, "someKey"));
        testObject1.put("someKey", "someValue");
        this.dao.save(new TransientObject[]{testObject1});
        Collection objects = this.dao.get(testObject1Table, new String[]{testObject1.getObjectKey()});
        Assert.assertEquals((String)"Returned wrong number of objects", (long)1L, (long)objects.size());
        TransientObject o = (TransientObject)ObjectUtils.get1stOrNull((Collection)objects);
        Assert.assertEquals((String)"Value not updated", (Object)"someValue", (Object)o.get(String.class, "someKey"));
        String bigString = CharBuffer.allocate(600).toString();
        testObject1.put("big_string", bigString);
        this.dao.save(new TransientObject[]{testObject1});
    }

    @Test
    public void testDelete() throws Exception {
        this.rawSave(new Keyable[]{this.object1, this.object2, this.object3, this.object4});
        this.dao.delete(new TransientObject[]{testObject1});
        this.dao.delete(new TransientObject[]{testObject4});
        Collection results = this.dao.get(this.testObject1Table, new String[]{testObject1.getObjectKey(), testObject2.getObjectKey()});
        Assert.assertNotEquals(null, (Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)((TransientObject)ObjectUtils.get1stOrNull((Collection)results)).getObjectKey(), (Object)testObject2.getObjectKey());
        Query q = new QueryBuilder().select(new SelectOperation[0]).from(TestObject1.class).build();
        results = this.dao.query(q);
        Assert.assertNotEquals((String)"Select All", null, (Object)results);
        Assert.assertEquals((String)"Select All", (long)2L, (long)results.size());
        q = new QueryBuilder().select(new SelectOperation[0]).from(TestObject2.class).build();
        results = this.dao.query(q);
        Assert.assertNotEquals((String)"Select All", null, (Object)results);
        Assert.assertEquals((String)"Select All", (long)0L, (long)results.size());
    }

    @Test
    public void testExists() throws Exception {
        this.rawSave(new Keyable[]{this.object1, this.object2});
        boolean exists = this.dao.exists(new TransientObject[]{testObject1, testObject2});
        Assert.assertTrue((boolean)exists);
        exists = this.dao.exists(new TransientObject[]{testObject1});
        Assert.assertTrue((boolean)exists);
        exists = this.dao.exists(new TransientObject[]{testObject3});
        Assert.assertEquals((String)testObject3.getObjectKey(), (Object)false, (Object)exists);
    }

    @Test
    public void testCount() throws Exception {
        this.rawSave(new Keyable[]{this.object1, this.object2, this.object3, this.object4});
        int count = this.dao.count(this.testObject1Table);
        Assert.assertEquals((long)3L, (long)count);
        count = this.dao.count(this.testObject2Table);
        Assert.assertEquals((long)1L, (long)count);
        count = this.dao.count(Query.safeTable(TransientObject.class));
        Assert.assertEquals((long)0L, (long)count);
    }

    public abstract BaseObject toBaseObject(TransientObject var1);

    public abstract void rawSave(List<BaseObject> var1);

    private void rawSave(BaseObject ... objects) {
        this.rawSave(Arrays.asList(objects));
    }
}

