/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.tenant.service.rest;

import io.dialob.security.spring.tenant.TenantGrantedAuthority;
import io.dialob.security.tenant.ImmutableTenant;
import io.dialob.security.tenant.Tenant;
import io.dialob.tenant.service.rest.TenantsProvider;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

class GrantedAuthorityTenantsProvider
implements TenantsProvider {
    GrantedAuthorityTenantsProvider() {
    }

    @Override
    @NonNull
    public List<Tenant> getTenants() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        List<Object> tenants = Collections.emptyList();
        if (authentication instanceof AbstractAuthenticationToken) {
            AbstractAuthenticationToken token = (AbstractAuthenticationToken)authentication;
            tenants = token.getAuthorities().stream().filter(a -> a instanceof TenantGrantedAuthority).map(a -> (TenantGrantedAuthority)a).map(a -> ImmutableTenant.of((String)a.getTenantId(), Optional.ofNullable(a.getAuthority()))).collect(Collectors.toList());
        }
        return tenants;
    }
}

