/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.tenant.service.rest;

import io.dialob.security.tenant.CurrentTenant;
import io.dialob.tenant.service.rest.FixedTenantsProvider;
import io.dialob.tenant.service.rest.GrantedAuthorityTenantsProvider;
import io.dialob.tenant.service.rest.TenantsProvider;
import io.dialob.tenant.service.rest.TenantsRestController;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@Import(value={TenantsRestController.class})
public class DialobTenantServiceAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(name={"dialob.security.enabled"}, havingValue="false", matchIfMissing=true)
    static class DialobTenantServiceWithoutSecurityConfiguration {
        DialobTenantServiceWithoutSecurityConfiguration() {
        }

        @Bean
        public TenantsProvider fixedTenantService(CurrentTenant currentTenant) {
            return new FixedTenantsProvider(currentTenant);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(name={"dialob.security.enabled"}, havingValue="true")
    static class DialobTenantServiceWithSecurityConfiguration {
        DialobTenantServiceWithSecurityConfiguration() {
        }

        @ConditionalOnProperty(prefix="dialob.tenant", name={"mode"}, havingValue="URL_PARAM", matchIfMissing=true)
        @Bean
        public TenantsProvider grantedAuthorityTenantService() {
            return new GrantedAuthorityTenantsProvider();
        }

        @ConditionalOnProperty(prefix="dialob.tenant", name={"mode"}, havingValue="FIXED")
        @Bean
        public TenantsProvider fixedTenantService(CurrentTenant currentTenant) {
            return new FixedTenantsProvider(currentTenant);
        }
    }
}

