/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.spring.boot.redis;

import com.google.common.collect.ImmutableSet;
import io.dialob.questionnaire.service.api.event.QuestionnaireEventPublisher;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.dialob.session.engine.DialobProgramService;
import io.dialob.session.engine.program.DialobSessionEvalContextFactory;
import io.dialob.session.engine.sp.AsyncFunctionInvoker;
import io.dialob.settings.DialobSettings;
import io.dialob.spring.boot.redis.QuestionnaireDialobSessionRedisSerializer;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Optional;
import java.util.Set;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.NonNull;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"dialob.session.cache.type"}, matchIfMissing=false, havingValue="REDIS")
public class RedisQuestionnaireDialobSessionCacheConfiguration {
    @Bean
    public QuestionnaireDialobSessionRedisSerializer dialobSessionSerializer(@NonNull QuestionnaireSessionService questionnaireSessionService, @NonNull DialobProgramService dialobProgramService, @NonNull Optional<MeterRegistry> meterRegistry, @NonNull DialobSettings dialobSettings, @NonNull QuestionnaireEventPublisher eventPublisher, @NonNull DialobSessionEvalContextFactory sessionContextFactory, @NonNull AsyncFunctionInvoker asyncFunctionInvoker) {
        return new QuestionnaireDialobSessionRedisSerializer(questionnaireSessionService, eventPublisher, dialobProgramService, sessionContextFactory, asyncFunctionInvoker, meterRegistry, dialobSettings.getSession().getCache().getBufferSize());
    }

    @Bean(name={"sessionCacheManager"})
    public RedisCacheManager sessionCacheManager(@NonNull RedisConnectionFactory redisConnectionFactory, @NonNull QuestionnaireDialobSessionRedisSerializer dialobSessionSerializer) {
        return RedisCacheManager.builder((RedisConnectionFactory)redisConnectionFactory).cacheDefaults(RedisCacheConfiguration.defaultCacheConfig().serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)dialobSessionSerializer))).initialCacheNames((Set)ImmutableSet.of((Object)"sessionCache")).disableCreateOnMissingCache().build();
    }
}

