/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.settings;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.util.CollectionUtils;
import org.springframework.web.cors.CorsConfiguration;

public class CorsSettings {
    private List<String> allowedOrigins = new ArrayList<String>();
    private List<String> allowedMethods = new ArrayList<String>();
    private List<String> allowedHeaders = new ArrayList<String>();
    private List<String> exposedHeaders = new ArrayList<String>();
    private Boolean allowCredentials;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration maxAge = Duration.ofSeconds(1800L);

    public Optional<CorsConfiguration> toCorsConfiguration() {
        if (CollectionUtils.isEmpty(this.allowedOrigins)) {
            return Optional.empty();
        }
        PropertyMapper map = PropertyMapper.get();
        CorsConfiguration configuration = new CorsConfiguration();
        map.from(this::getAllowedOrigins).to(arg_0 -> ((CorsConfiguration)configuration).setAllowedOrigins(arg_0));
        map.from(this::getAllowedHeaders).whenNot(CollectionUtils::isEmpty).to(arg_0 -> ((CorsConfiguration)configuration).setAllowedHeaders(arg_0));
        map.from(this::getAllowedMethods).whenNot(CollectionUtils::isEmpty).to(arg_0 -> ((CorsConfiguration)configuration).setAllowedMethods(arg_0));
        map.from(this::getExposedHeaders).whenNot(CollectionUtils::isEmpty).to(arg_0 -> ((CorsConfiguration)configuration).setExposedHeaders(arg_0));
        map.from(this::getMaxAge).whenNonNull().as(Duration::getSeconds).to(arg_0 -> ((CorsConfiguration)configuration).setMaxAge(arg_0));
        map.from(this::getAllowCredentials).whenNonNull().to(arg_0 -> ((CorsConfiguration)configuration).setAllowCredentials(arg_0));
        return Optional.of(configuration);
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public List<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public Boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    public Duration getMaxAge() {
        return this.maxAge;
    }

    public void setAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public void setAllowedMethods(List<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public void setAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public void setExposedHeaders(List<String> exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
    }

    public void setAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public void setMaxAge(Duration maxAge) {
        this.maxAge = maxAge;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CorsSettings)) {
            return false;
        }
        CorsSettings other = (CorsSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$allowCredentials = this.getAllowCredentials();
        Boolean other$allowCredentials = other.getAllowCredentials();
        if (this$allowCredentials == null ? other$allowCredentials != null : !((Object)this$allowCredentials).equals(other$allowCredentials)) {
            return false;
        }
        List<String> this$allowedOrigins = this.getAllowedOrigins();
        List<String> other$allowedOrigins = other.getAllowedOrigins();
        if (this$allowedOrigins == null ? other$allowedOrigins != null : !((Object)this$allowedOrigins).equals(other$allowedOrigins)) {
            return false;
        }
        List<String> this$allowedMethods = this.getAllowedMethods();
        List<String> other$allowedMethods = other.getAllowedMethods();
        if (this$allowedMethods == null ? other$allowedMethods != null : !((Object)this$allowedMethods).equals(other$allowedMethods)) {
            return false;
        }
        List<String> this$allowedHeaders = this.getAllowedHeaders();
        List<String> other$allowedHeaders = other.getAllowedHeaders();
        if (this$allowedHeaders == null ? other$allowedHeaders != null : !((Object)this$allowedHeaders).equals(other$allowedHeaders)) {
            return false;
        }
        List<String> this$exposedHeaders = this.getExposedHeaders();
        List<String> other$exposedHeaders = other.getExposedHeaders();
        if (this$exposedHeaders == null ? other$exposedHeaders != null : !((Object)this$exposedHeaders).equals(other$exposedHeaders)) {
            return false;
        }
        Duration this$maxAge = this.getMaxAge();
        Duration other$maxAge = other.getMaxAge();
        return !(this$maxAge == null ? other$maxAge != null : !((Object)this$maxAge).equals(other$maxAge));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CorsSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $allowCredentials = this.getAllowCredentials();
        result = result * 59 + ($allowCredentials == null ? 43 : ((Object)$allowCredentials).hashCode());
        List<String> $allowedOrigins = this.getAllowedOrigins();
        result = result * 59 + ($allowedOrigins == null ? 43 : ((Object)$allowedOrigins).hashCode());
        List<String> $allowedMethods = this.getAllowedMethods();
        result = result * 59 + ($allowedMethods == null ? 43 : ((Object)$allowedMethods).hashCode());
        List<String> $allowedHeaders = this.getAllowedHeaders();
        result = result * 59 + ($allowedHeaders == null ? 43 : ((Object)$allowedHeaders).hashCode());
        List<String> $exposedHeaders = this.getExposedHeaders();
        result = result * 59 + ($exposedHeaders == null ? 43 : ((Object)$exposedHeaders).hashCode());
        Duration $maxAge = this.getMaxAge();
        result = result * 59 + ($maxAge == null ? 43 : ((Object)$maxAge).hashCode());
        return result;
    }

    public String toString() {
        return "CorsSettings(allowedOrigins=" + this.getAllowedOrigins() + ", allowedMethods=" + this.getAllowedMethods() + ", allowedHeaders=" + this.getAllowedHeaders() + ", exposedHeaders=" + this.getExposedHeaders() + ", allowCredentials=" + this.getAllowCredentials() + ", maxAge=" + this.getMaxAge() + ")";
    }
}

