/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.settings;

import io.dialob.settings.CorsSettings;
import io.dialob.settings.SessionSettings;
import io.dialob.settings.SubmitHandlerSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="dialob")
@Validated
public class DialobSettings {
    private SessionSettings session = new SessionSettings();
    private DatabaseSettings db = new DatabaseSettings();
    private DatabaseSettings formDatabase = new DatabaseSettings();
    private DatabaseSettings questionnaireDatabase = new DatabaseSettings();
    private TenantSettings tenant = new TenantSettings();
    private ApiSettings api = new ApiSettings();
    private UaaSettings uaa = new UaaSettings();
    private SecuritySettings security = new SecuritySettings();
    private Map<String, SubmitHandlerSettings> submitHandlers = new HashMap<String, SubmitHandlerSettings>();
    private DialobAssetsSettings assets = new DialobAssetsSettings();
    private AwsSettings aws = new AwsSettings();
    private GcpSettings gcp = new GcpSettings();
    Map<String, Tags> tags = new HashMap<String, Tags>();

    public SessionSettings getSession() {
        return this.session;
    }

    public DatabaseSettings getDb() {
        return this.db;
    }

    public DatabaseSettings getFormDatabase() {
        return this.formDatabase;
    }

    public DatabaseSettings getQuestionnaireDatabase() {
        return this.questionnaireDatabase;
    }

    public TenantSettings getTenant() {
        return this.tenant;
    }

    public ApiSettings getApi() {
        return this.api;
    }

    public UaaSettings getUaa() {
        return this.uaa;
    }

    public SecuritySettings getSecurity() {
        return this.security;
    }

    public Map<String, SubmitHandlerSettings> getSubmitHandlers() {
        return this.submitHandlers;
    }

    public DialobAssetsSettings getAssets() {
        return this.assets;
    }

    public AwsSettings getAws() {
        return this.aws;
    }

    public GcpSettings getGcp() {
        return this.gcp;
    }

    public Map<String, Tags> getTags() {
        return this.tags;
    }

    public void setSession(SessionSettings session) {
        this.session = session;
    }

    public void setDb(DatabaseSettings db) {
        this.db = db;
    }

    public void setFormDatabase(DatabaseSettings formDatabase) {
        this.formDatabase = formDatabase;
    }

    public void setQuestionnaireDatabase(DatabaseSettings questionnaireDatabase) {
        this.questionnaireDatabase = questionnaireDatabase;
    }

    public void setTenant(TenantSettings tenant) {
        this.tenant = tenant;
    }

    public void setApi(ApiSettings api) {
        this.api = api;
    }

    public void setUaa(UaaSettings uaa) {
        this.uaa = uaa;
    }

    public void setSecurity(SecuritySettings security) {
        this.security = security;
    }

    public void setSubmitHandlers(Map<String, SubmitHandlerSettings> submitHandlers) {
        this.submitHandlers = submitHandlers;
    }

    public void setAssets(DialobAssetsSettings assets) {
        this.assets = assets;
    }

    public void setAws(AwsSettings aws) {
        this.aws = aws;
    }

    public void setGcp(GcpSettings gcp) {
        this.gcp = gcp;
    }

    public void setTags(Map<String, Tags> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DialobSettings)) {
            return false;
        }
        DialobSettings other = (DialobSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SessionSettings this$session = this.getSession();
        SessionSettings other$session = other.getSession();
        if (this$session == null ? other$session != null : !((Object)this$session).equals(other$session)) {
            return false;
        }
        DatabaseSettings this$db = this.getDb();
        DatabaseSettings other$db = other.getDb();
        if (this$db == null ? other$db != null : !((Object)this$db).equals(other$db)) {
            return false;
        }
        DatabaseSettings this$formDatabase = this.getFormDatabase();
        DatabaseSettings other$formDatabase = other.getFormDatabase();
        if (this$formDatabase == null ? other$formDatabase != null : !((Object)this$formDatabase).equals(other$formDatabase)) {
            return false;
        }
        DatabaseSettings this$questionnaireDatabase = this.getQuestionnaireDatabase();
        DatabaseSettings other$questionnaireDatabase = other.getQuestionnaireDatabase();
        if (this$questionnaireDatabase == null ? other$questionnaireDatabase != null : !((Object)this$questionnaireDatabase).equals(other$questionnaireDatabase)) {
            return false;
        }
        TenantSettings this$tenant = this.getTenant();
        TenantSettings other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !((Object)this$tenant).equals(other$tenant)) {
            return false;
        }
        ApiSettings this$api = this.getApi();
        ApiSettings other$api = other.getApi();
        if (this$api == null ? other$api != null : !((Object)this$api).equals(other$api)) {
            return false;
        }
        UaaSettings this$uaa = this.getUaa();
        UaaSettings other$uaa = other.getUaa();
        if (this$uaa == null ? other$uaa != null : !((Object)this$uaa).equals(other$uaa)) {
            return false;
        }
        SecuritySettings this$security = this.getSecurity();
        SecuritySettings other$security = other.getSecurity();
        if (this$security == null ? other$security != null : !((Object)this$security).equals(other$security)) {
            return false;
        }
        Map<String, SubmitHandlerSettings> this$submitHandlers = this.getSubmitHandlers();
        Map<String, SubmitHandlerSettings> other$submitHandlers = other.getSubmitHandlers();
        if (this$submitHandlers == null ? other$submitHandlers != null : !((Object)this$submitHandlers).equals(other$submitHandlers)) {
            return false;
        }
        DialobAssetsSettings this$assets = this.getAssets();
        DialobAssetsSettings other$assets = other.getAssets();
        if (this$assets == null ? other$assets != null : !((Object)this$assets).equals(other$assets)) {
            return false;
        }
        AwsSettings this$aws = this.getAws();
        AwsSettings other$aws = other.getAws();
        if (this$aws == null ? other$aws != null : !((Object)this$aws).equals(other$aws)) {
            return false;
        }
        GcpSettings this$gcp = this.getGcp();
        GcpSettings other$gcp = other.getGcp();
        if (this$gcp == null ? other$gcp != null : !((Object)this$gcp).equals(other$gcp)) {
            return false;
        }
        Map<String, Tags> this$tags = this.getTags();
        Map<String, Tags> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DialobSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SessionSettings $session = this.getSession();
        result = result * 59 + ($session == null ? 43 : ((Object)$session).hashCode());
        DatabaseSettings $db = this.getDb();
        result = result * 59 + ($db == null ? 43 : ((Object)$db).hashCode());
        DatabaseSettings $formDatabase = this.getFormDatabase();
        result = result * 59 + ($formDatabase == null ? 43 : ((Object)$formDatabase).hashCode());
        DatabaseSettings $questionnaireDatabase = this.getQuestionnaireDatabase();
        result = result * 59 + ($questionnaireDatabase == null ? 43 : ((Object)$questionnaireDatabase).hashCode());
        TenantSettings $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : ((Object)$tenant).hashCode());
        ApiSettings $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : ((Object)$api).hashCode());
        UaaSettings $uaa = this.getUaa();
        result = result * 59 + ($uaa == null ? 43 : ((Object)$uaa).hashCode());
        SecuritySettings $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : ((Object)$security).hashCode());
        Map<String, SubmitHandlerSettings> $submitHandlers = this.getSubmitHandlers();
        result = result * 59 + ($submitHandlers == null ? 43 : ((Object)$submitHandlers).hashCode());
        DialobAssetsSettings $assets = this.getAssets();
        result = result * 59 + ($assets == null ? 43 : ((Object)$assets).hashCode());
        AwsSettings $aws = this.getAws();
        result = result * 59 + ($aws == null ? 43 : ((Object)$aws).hashCode());
        GcpSettings $gcp = this.getGcp();
        result = result * 59 + ($gcp == null ? 43 : ((Object)$gcp).hashCode());
        Map<String, Tags> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "DialobSettings(session=" + this.getSession() + ", db=" + this.getDb() + ", formDatabase=" + this.getFormDatabase() + ", questionnaireDatabase=" + this.getQuestionnaireDatabase() + ", tenant=" + this.getTenant() + ", api=" + this.getApi() + ", uaa=" + this.getUaa() + ", security=" + this.getSecurity() + ", submitHandlers=" + this.getSubmitHandlers() + ", assets=" + this.getAssets() + ", aws=" + this.getAws() + ", gcp=" + this.getGcp() + ", tags=" + this.getTags() + ")";
    }

    public static class Tags {
        Set<String> predefined = new HashSet<String>();

        public Set<String> getPredefined() {
            return this.predefined;
        }

        public void setPredefined(Set<String> predefined) {
            this.predefined = predefined;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tags)) {
                return false;
            }
            Tags other = (Tags)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<String> this$predefined = this.getPredefined();
            Set<String> other$predefined = other.getPredefined();
            return !(this$predefined == null ? other$predefined != null : !((Object)this$predefined).equals(other$predefined));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Tags;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $predefined = this.getPredefined();
            result = result * 59 + ($predefined == null ? 43 : ((Object)$predefined).hashCode());
            return result;
        }

        public String toString() {
            return "DialobSettings.Tags(predefined=" + this.getPredefined() + ")";
        }
    }

    public static class GcpSettings {
        boolean enabled = false;
        private PubSubSettings pubsub = new PubSubSettings();

        public boolean isEnabled() {
            return this.enabled;
        }

        public PubSubSettings getPubsub() {
            return this.pubsub;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setPubsub(PubSubSettings pubsub) {
            this.pubsub = pubsub;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GcpSettings)) {
                return false;
            }
            GcpSettings other = (GcpSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            PubSubSettings this$pubsub = this.getPubsub();
            PubSubSettings other$pubsub = other.getPubsub();
            return !(this$pubsub == null ? other$pubsub != null : !((Object)this$pubsub).equals(other$pubsub));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GcpSettings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            PubSubSettings $pubsub = this.getPubsub();
            result = result * 59 + ($pubsub == null ? 43 : ((Object)$pubsub).hashCode());
            return result;
        }

        public String toString() {
            return "DialobSettings.GcpSettings(enabled=" + this.isEnabled() + ", pubsub=" + this.getPubsub() + ")";
        }

        public static class PubSubSettings {
            boolean enabled = false;
            String formEventsTopic;
            String questionnaireEventsTopic;

            public boolean isEnabled() {
                return this.enabled;
            }

            public String getFormEventsTopic() {
                return this.formEventsTopic;
            }

            public String getQuestionnaireEventsTopic() {
                return this.questionnaireEventsTopic;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public void setFormEventsTopic(String formEventsTopic) {
                this.formEventsTopic = formEventsTopic;
            }

            public void setQuestionnaireEventsTopic(String questionnaireEventsTopic) {
                this.questionnaireEventsTopic = questionnaireEventsTopic;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PubSubSettings)) {
                    return false;
                }
                PubSubSettings other = (PubSubSettings)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isEnabled() != other.isEnabled()) {
                    return false;
                }
                String this$formEventsTopic = this.getFormEventsTopic();
                String other$formEventsTopic = other.getFormEventsTopic();
                if (this$formEventsTopic == null ? other$formEventsTopic != null : !this$formEventsTopic.equals(other$formEventsTopic)) {
                    return false;
                }
                String this$questionnaireEventsTopic = this.getQuestionnaireEventsTopic();
                String other$questionnaireEventsTopic = other.getQuestionnaireEventsTopic();
                return !(this$questionnaireEventsTopic == null ? other$questionnaireEventsTopic != null : !this$questionnaireEventsTopic.equals(other$questionnaireEventsTopic));
            }

            protected boolean canEqual(Object other) {
                return other instanceof PubSubSettings;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isEnabled() ? 79 : 97);
                String $formEventsTopic = this.getFormEventsTopic();
                result = result * 59 + ($formEventsTopic == null ? 43 : $formEventsTopic.hashCode());
                String $questionnaireEventsTopic = this.getQuestionnaireEventsTopic();
                result = result * 59 + ($questionnaireEventsTopic == null ? 43 : $questionnaireEventsTopic.hashCode());
                return result;
            }

            public String toString() {
                return "DialobSettings.GcpSettings.PubSubSettings(enabled=" + this.isEnabled() + ", formEventsTopic=" + this.getFormEventsTopic() + ", questionnaireEventsTopic=" + this.getQuestionnaireEventsTopic() + ")";
            }
        }
    }

    public static class AwsSettings {
        boolean enabled = false;
        private String region = "eu-central-1";
        private SnsSettings sns = new SnsSettings();
        ElbSettings elb = new ElbSettings();

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getRegion() {
            return this.region;
        }

        public SnsSettings getSns() {
            return this.sns;
        }

        public ElbSettings getElb() {
            return this.elb;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public void setSns(SnsSettings sns) {
            this.sns = sns;
        }

        public void setElb(ElbSettings elb) {
            this.elb = elb;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AwsSettings)) {
                return false;
            }
            AwsSettings other = (AwsSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            SnsSettings this$sns = this.getSns();
            SnsSettings other$sns = other.getSns();
            if (this$sns == null ? other$sns != null : !((Object)this$sns).equals(other$sns)) {
                return false;
            }
            ElbSettings this$elb = this.getElb();
            ElbSettings other$elb = other.getElb();
            return !(this$elb == null ? other$elb != null : !((Object)this$elb).equals(other$elb));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AwsSettings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            SnsSettings $sns = this.getSns();
            result = result * 59 + ($sns == null ? 43 : ((Object)$sns).hashCode());
            ElbSettings $elb = this.getElb();
            result = result * 59 + ($elb == null ? 43 : ((Object)$elb).hashCode());
            return result;
        }

        public String toString() {
            return "DialobSettings.AwsSettings(enabled=" + this.isEnabled() + ", region=" + this.getRegion() + ", sns=" + this.getSns() + ", elb=" + this.getElb() + ")";
        }

        public static class ElbSettings {
            boolean authEnabled = false;
            Set<String> algorithms = Set.of("ES256");
            Optional<String> principalRequestHeader = Optional.of("X-Amzn-Oidc-Identity");
            Optional<String> credentialsRequestHeader = Optional.of("X-Amzn-Oidc-Data");

            public boolean isAuthEnabled() {
                return this.authEnabled;
            }

            public Set<String> getAlgorithms() {
                return this.algorithms;
            }

            public Optional<String> getPrincipalRequestHeader() {
                return this.principalRequestHeader;
            }

            public Optional<String> getCredentialsRequestHeader() {
                return this.credentialsRequestHeader;
            }

            public void setAuthEnabled(boolean authEnabled) {
                this.authEnabled = authEnabled;
            }

            public void setAlgorithms(Set<String> algorithms) {
                this.algorithms = algorithms;
            }

            public void setPrincipalRequestHeader(Optional<String> principalRequestHeader) {
                this.principalRequestHeader = principalRequestHeader;
            }

            public void setCredentialsRequestHeader(Optional<String> credentialsRequestHeader) {
                this.credentialsRequestHeader = credentialsRequestHeader;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ElbSettings)) {
                    return false;
                }
                ElbSettings other = (ElbSettings)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isAuthEnabled() != other.isAuthEnabled()) {
                    return false;
                }
                Set<String> this$algorithms = this.getAlgorithms();
                Set<String> other$algorithms = other.getAlgorithms();
                if (this$algorithms == null ? other$algorithms != null : !((Object)this$algorithms).equals(other$algorithms)) {
                    return false;
                }
                Optional<String> this$principalRequestHeader = this.getPrincipalRequestHeader();
                Optional<String> other$principalRequestHeader = other.getPrincipalRequestHeader();
                if (this$principalRequestHeader == null ? other$principalRequestHeader != null : !((Object)this$principalRequestHeader).equals(other$principalRequestHeader)) {
                    return false;
                }
                Optional<String> this$credentialsRequestHeader = this.getCredentialsRequestHeader();
                Optional<String> other$credentialsRequestHeader = other.getCredentialsRequestHeader();
                return !(this$credentialsRequestHeader == null ? other$credentialsRequestHeader != null : !((Object)this$credentialsRequestHeader).equals(other$credentialsRequestHeader));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ElbSettings;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isAuthEnabled() ? 79 : 97);
                Set<String> $algorithms = this.getAlgorithms();
                result = result * 59 + ($algorithms == null ? 43 : ((Object)$algorithms).hashCode());
                Optional<String> $principalRequestHeader = this.getPrincipalRequestHeader();
                result = result * 59 + ($principalRequestHeader == null ? 43 : ((Object)$principalRequestHeader).hashCode());
                Optional<String> $credentialsRequestHeader = this.getCredentialsRequestHeader();
                result = result * 59 + ($credentialsRequestHeader == null ? 43 : ((Object)$credentialsRequestHeader).hashCode());
                return result;
            }

            public String toString() {
                return "DialobSettings.AwsSettings.ElbSettings(authEnabled=" + this.isAuthEnabled() + ", algorithms=" + this.getAlgorithms() + ", principalRequestHeader=" + this.getPrincipalRequestHeader() + ", credentialsRequestHeader=" + this.getCredentialsRequestHeader() + ")";
            }
        }

        public static class SnsSettings {
            boolean enabled = false;
            String formEventsTopicARN;
            String questionnaireEventsTopicARN;

            public boolean isEnabled() {
                return this.enabled;
            }

            public String getFormEventsTopicARN() {
                return this.formEventsTopicARN;
            }

            public String getQuestionnaireEventsTopicARN() {
                return this.questionnaireEventsTopicARN;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public void setFormEventsTopicARN(String formEventsTopicARN) {
                this.formEventsTopicARN = formEventsTopicARN;
            }

            public void setQuestionnaireEventsTopicARN(String questionnaireEventsTopicARN) {
                this.questionnaireEventsTopicARN = questionnaireEventsTopicARN;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SnsSettings)) {
                    return false;
                }
                SnsSettings other = (SnsSettings)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isEnabled() != other.isEnabled()) {
                    return false;
                }
                String this$formEventsTopicARN = this.getFormEventsTopicARN();
                String other$formEventsTopicARN = other.getFormEventsTopicARN();
                if (this$formEventsTopicARN == null ? other$formEventsTopicARN != null : !this$formEventsTopicARN.equals(other$formEventsTopicARN)) {
                    return false;
                }
                String this$questionnaireEventsTopicARN = this.getQuestionnaireEventsTopicARN();
                String other$questionnaireEventsTopicARN = other.getQuestionnaireEventsTopicARN();
                return !(this$questionnaireEventsTopicARN == null ? other$questionnaireEventsTopicARN != null : !this$questionnaireEventsTopicARN.equals(other$questionnaireEventsTopicARN));
            }

            protected boolean canEqual(Object other) {
                return other instanceof SnsSettings;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isEnabled() ? 79 : 97);
                String $formEventsTopicARN = this.getFormEventsTopicARN();
                result = result * 59 + ($formEventsTopicARN == null ? 43 : $formEventsTopicARN.hashCode());
                String $questionnaireEventsTopicARN = this.getQuestionnaireEventsTopicARN();
                result = result * 59 + ($questionnaireEventsTopicARN == null ? 43 : $questionnaireEventsTopicARN.hashCode());
                return result;
            }

            public String toString() {
                return "DialobSettings.AwsSettings.SnsSettings(enabled=" + this.isEnabled() + ", formEventsTopicARN=" + this.getFormEventsTopicARN() + ", questionnaireEventsTopicARN=" + this.getQuestionnaireEventsTopicARN() + ")";
            }
        }
    }

    public static class SecuritySettings {
        private boolean enabled;
        private AuthenticationMethod authenticationMethod = AuthenticationMethod.OAUTH2;
        private Map<String, Set<String>> groupPermissions = new HashMap<String, Set<String>>();

        public boolean isEnabled() {
            return this.enabled;
        }

        public AuthenticationMethod getAuthenticationMethod() {
            return this.authenticationMethod;
        }

        public Map<String, Set<String>> getGroupPermissions() {
            return this.groupPermissions;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setAuthenticationMethod(AuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
        }

        public void setGroupPermissions(Map<String, Set<String>> groupPermissions) {
            this.groupPermissions = groupPermissions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SecuritySettings)) {
                return false;
            }
            SecuritySettings other = (SecuritySettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            AuthenticationMethod this$authenticationMethod = this.getAuthenticationMethod();
            AuthenticationMethod other$authenticationMethod = other.getAuthenticationMethod();
            if (this$authenticationMethod == null ? other$authenticationMethod != null : !((Object)((Object)this$authenticationMethod)).equals((Object)other$authenticationMethod)) {
                return false;
            }
            Map<String, Set<String>> this$groupPermissions = this.getGroupPermissions();
            Map<String, Set<String>> other$groupPermissions = other.getGroupPermissions();
            return !(this$groupPermissions == null ? other$groupPermissions != null : !((Object)this$groupPermissions).equals(other$groupPermissions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SecuritySettings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            AuthenticationMethod $authenticationMethod = this.getAuthenticationMethod();
            result = result * 59 + ($authenticationMethod == null ? 43 : ((Object)((Object)$authenticationMethod)).hashCode());
            Map<String, Set<String>> $groupPermissions = this.getGroupPermissions();
            result = result * 59 + ($groupPermissions == null ? 43 : ((Object)$groupPermissions).hashCode());
            return result;
        }

        public String toString() {
            return "DialobSettings.SecuritySettings(enabled=" + this.isEnabled() + ", authenticationMethod=" + this.getAuthenticationMethod() + ", groupPermissions=" + this.getGroupPermissions() + ")";
        }

        public static class AuditSettings {
            private boolean enabled;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AuditSettings)) {
                    return false;
                }
                AuditSettings other = (AuditSettings)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.isEnabled() == other.isEnabled();
            }

            protected boolean canEqual(Object other) {
                return other instanceof AuditSettings;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isEnabled() ? 79 : 97);
                return result;
            }

            public String toString() {
                return "DialobSettings.SecuritySettings.AuditSettings(enabled=" + this.isEnabled() + ")";
            }
        }

        public static enum AuthenticationMethod {
            OAUTH2,
            AWSELB;

        }
    }

    public static class UaaSettings {
        private String url;
        private String clientId;
        private String clientSecret;

        public String getUrl() {
            return this.url;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UaaSettings)) {
                return false;
            }
            UaaSettings other = (UaaSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$clientId = this.getClientId();
            String other$clientId = other.getClientId();
            if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
                return false;
            }
            String this$clientSecret = this.getClientSecret();
            String other$clientSecret = other.getClientSecret();
            return !(this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UaaSettings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            String $clientSecret = this.getClientSecret();
            result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
            return result;
        }

        public String toString() {
            return "DialobSettings.UaaSettings(url=" + this.getUrl() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ")";
        }
    }

    public static class ApiSettings {
        private String contextPath = "/api";
        private String apiKeySalt = "secret";
        private List<ApiKey> apiKeys = new ArrayList<ApiKey>();
        private List<SecurityScheme> schemes;
        CorsSettings cors = new CorsSettings();

        public String getContextPath() {
            return this.contextPath;
        }

        public String getApiKeySalt() {
            return this.apiKeySalt;
        }

        public List<ApiKey> getApiKeys() {
            return this.apiKeys;
        }

        public List<SecurityScheme> getSchemes() {
            return this.schemes;
        }

        public CorsSettings getCors() {
            return this.cors;
        }

        public void setContextPath(String contextPath) {
            this.contextPath = contextPath;
        }

        public void setApiKeySalt(String apiKeySalt) {
            this.apiKeySalt = apiKeySalt;
        }

        public void setApiKeys(List<ApiKey> apiKeys) {
            this.apiKeys = apiKeys;
        }

        public void setSchemes(List<SecurityScheme> schemes) {
            this.schemes = schemes;
        }

        public void setCors(CorsSettings cors) {
            this.cors = cors;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiSettings)) {
                return false;
            }
            ApiSettings other = (ApiSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$contextPath = this.getContextPath();
            String other$contextPath = other.getContextPath();
            if (this$contextPath == null ? other$contextPath != null : !this$contextPath.equals(other$contextPath)) {
                return false;
            }
            String this$apiKeySalt = this.getApiKeySalt();
            String other$apiKeySalt = other.getApiKeySalt();
            if (this$apiKeySalt == null ? other$apiKeySalt != null : !this$apiKeySalt.equals(other$apiKeySalt)) {
                return false;
            }
            List<ApiKey> this$apiKeys = this.getApiKeys();
            List<ApiKey> other$apiKeys = other.getApiKeys();
            if (this$apiKeys == null ? other$apiKeys != null : !((Object)this$apiKeys).equals(other$apiKeys)) {
                return false;
            }
            List<SecurityScheme> this$schemes = this.getSchemes();
            List<SecurityScheme> other$schemes = other.getSchemes();
            if (this$schemes == null ? other$schemes != null : !((Object)this$schemes).equals(other$schemes)) {
                return false;
            }
            CorsSettings this$cors = this.getCors();
            CorsSettings other$cors = other.getCors();
            return !(this$cors == null ? other$cors != null : !((Object)this$cors).equals(other$cors));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApiSettings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $contextPath = this.getContextPath();
            result = result * 59 + ($contextPath == null ? 43 : $contextPath.hashCode());
            String $apiKeySalt = this.getApiKeySalt();
            result = result * 59 + ($apiKeySalt == null ? 43 : $apiKeySalt.hashCode());
            List<ApiKey> $apiKeys = this.getApiKeys();
            result = result * 59 + ($apiKeys == null ? 43 : ((Object)$apiKeys).hashCode());
            List<SecurityScheme> $schemes = this.getSchemes();
            result = result * 59 + ($schemes == null ? 43 : ((Object)$schemes).hashCode());
            CorsSettings $cors = this.getCors();
            result = result * 59 + ($cors == null ? 43 : ((Object)$cors).hashCode());
            return result;
        }

        public String toString() {
            return "DialobSettings.ApiSettings(contextPath=" + this.getContextPath() + ", apiKeySalt=" + this.getApiKeySalt() + ", apiKeys=" + this.getApiKeys() + ", schemes=" + this.getSchemes() + ", cors=" + this.getCors() + ")";
        }

        public static class ApiKey {
            private String tenantId;
            private String clientId;
            private String hash;
            private Set<String> permissions = new HashSet<String>();

            public String getTenantId() {
                return this.tenantId;
            }

            public String getClientId() {
                return this.clientId;
            }

            public String getHash() {
                return this.hash;
            }

            public Set<String> getPermissions() {
                return this.permissions;
            }

            public void setTenantId(String tenantId) {
                this.tenantId = tenantId;
            }

            public void setClientId(String clientId) {
                this.clientId = clientId;
            }

            public void setHash(String hash) {
                this.hash = hash;
            }

            public void setPermissions(Set<String> permissions) {
                this.permissions = permissions;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ApiKey)) {
                    return false;
                }
                ApiKey other = (ApiKey)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$tenantId = this.getTenantId();
                String other$tenantId = other.getTenantId();
                if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
                    return false;
                }
                String this$clientId = this.getClientId();
                String other$clientId = other.getClientId();
                if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
                    return false;
                }
                String this$hash = this.getHash();
                String other$hash = other.getHash();
                if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
                    return false;
                }
                Set<String> this$permissions = this.getPermissions();
                Set<String> other$permissions = other.getPermissions();
                return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ApiKey;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $tenantId = this.getTenantId();
                result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
                String $clientId = this.getClientId();
                result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
                String $hash = this.getHash();
                result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
                Set<String> $permissions = this.getPermissions();
                result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
                return result;
            }

            public String toString() {
                return "DialobSettings.ApiSettings.ApiKey(tenantId=" + this.getTenantId() + ", clientId=" + this.getClientId() + ", hash=" + this.getHash() + ", permissions=" + this.getPermissions() + ")";
            }
        }

        public static class SecurityScheme {
            private String type;
            private String name;
            private String keyName;
            private String passAs;

            public String getType() {
                return this.type;
            }

            public String getName() {
                return this.name;
            }

            public String getKeyName() {
                return this.keyName;
            }

            public String getPassAs() {
                return this.passAs;
            }

            public void setType(String type) {
                this.type = type;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setKeyName(String keyName) {
                this.keyName = keyName;
            }

            public void setPassAs(String passAs) {
                this.passAs = passAs;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SecurityScheme)) {
                    return false;
                }
                SecurityScheme other = (SecurityScheme)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$keyName = this.getKeyName();
                String other$keyName = other.getKeyName();
                if (this$keyName == null ? other$keyName != null : !this$keyName.equals(other$keyName)) {
                    return false;
                }
                String this$passAs = this.getPassAs();
                String other$passAs = other.getPassAs();
                return !(this$passAs == null ? other$passAs != null : !this$passAs.equals(other$passAs));
            }

            protected boolean canEqual(Object other) {
                return other instanceof SecurityScheme;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $keyName = this.getKeyName();
                result = result * 59 + ($keyName == null ? 43 : $keyName.hashCode());
                String $passAs = this.getPassAs();
                result = result * 59 + ($passAs == null ? 43 : $passAs.hashCode());
                return result;
            }

            public String toString() {
                return "DialobSettings.ApiSettings.SecurityScheme(type=" + this.getType() + ", name=" + this.getName() + ", keyName=" + this.getKeyName() + ", passAs=" + this.getPassAs() + ")";
            }
        }
    }

    public static class TenantSettings {
        private Mode mode = Mode.FIXED;
        private String fixedId = "00000000-0000-0000-0000-000000000000";
        private String env = "test";
        private String urlParameter = "tenantId";

        public Mode getMode() {
            return this.mode;
        }

        public String getFixedId() {
            return this.fixedId;
        }

        public String getEnv() {
            return this.env;
        }

        public String getUrlParameter() {
            return this.urlParameter;
        }

        public void setMode(Mode mode) {
            this.mode = mode;
        }

        public void setFixedId(String fixedId) {
            this.fixedId = fixedId;
        }

        public void setEnv(String env) {
            this.env = env;
        }

        public void setUrlParameter(String urlParameter) {
            this.urlParameter = urlParameter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TenantSettings)) {
                return false;
            }
            TenantSettings other = (TenantSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Mode this$mode = this.getMode();
            Mode other$mode = other.getMode();
            if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
                return false;
            }
            String this$fixedId = this.getFixedId();
            String other$fixedId = other.getFixedId();
            if (this$fixedId == null ? other$fixedId != null : !this$fixedId.equals(other$fixedId)) {
                return false;
            }
            String this$env = this.getEnv();
            String other$env = other.getEnv();
            if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
                return false;
            }
            String this$urlParameter = this.getUrlParameter();
            String other$urlParameter = other.getUrlParameter();
            return !(this$urlParameter == null ? other$urlParameter != null : !this$urlParameter.equals(other$urlParameter));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TenantSettings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Mode $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
            String $fixedId = this.getFixedId();
            result = result * 59 + ($fixedId == null ? 43 : $fixedId.hashCode());
            String $env = this.getEnv();
            result = result * 59 + ($env == null ? 43 : $env.hashCode());
            String $urlParameter = this.getUrlParameter();
            result = result * 59 + ($urlParameter == null ? 43 : $urlParameter.hashCode());
            return result;
        }

        public String toString() {
            return "DialobSettings.TenantSettings(mode=" + this.getMode() + ", fixedId=" + this.getFixedId() + ", env=" + this.getEnv() + ", urlParameter=" + this.getUrlParameter() + ")";
        }

        public static enum Mode {
            FIXED,
            URL_PARAM;

        }
    }

    public static class DatabaseSettings {
        @NotNull
        private DatabaseType databaseType;
        private JdbcSettings jdbc = new JdbcSettings();
        private FileSettings file = new FileSettings();
        private S3Settings s3 = new S3Settings();

        public DatabaseType getDatabaseType() {
            return this.databaseType;
        }

        public JdbcSettings getJdbc() {
            return this.jdbc;
        }

        public FileSettings getFile() {
            return this.file;
        }

        public S3Settings getS3() {
            return this.s3;
        }

        public void setDatabaseType(DatabaseType databaseType) {
            this.databaseType = databaseType;
        }

        public void setJdbc(JdbcSettings jdbc) {
            this.jdbc = jdbc;
        }

        public void setFile(FileSettings file) {
            this.file = file;
        }

        public void setS3(S3Settings s3) {
            this.s3 = s3;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DatabaseSettings)) {
                return false;
            }
            DatabaseSettings other = (DatabaseSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DatabaseType this$databaseType = this.getDatabaseType();
            DatabaseType other$databaseType = other.getDatabaseType();
            if (this$databaseType == null ? other$databaseType != null : !((Object)((Object)this$databaseType)).equals((Object)other$databaseType)) {
                return false;
            }
            JdbcSettings this$jdbc = this.getJdbc();
            JdbcSettings other$jdbc = other.getJdbc();
            if (this$jdbc == null ? other$jdbc != null : !((Object)this$jdbc).equals(other$jdbc)) {
                return false;
            }
            FileSettings this$file = this.getFile();
            FileSettings other$file = other.getFile();
            if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
                return false;
            }
            S3Settings this$s3 = this.getS3();
            S3Settings other$s3 = other.getS3();
            return !(this$s3 == null ? other$s3 != null : !((Object)this$s3).equals(other$s3));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DatabaseSettings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DatabaseType $databaseType = this.getDatabaseType();
            result = result * 59 + ($databaseType == null ? 43 : ((Object)((Object)$databaseType)).hashCode());
            JdbcSettings $jdbc = this.getJdbc();
            result = result * 59 + ($jdbc == null ? 43 : ((Object)$jdbc).hashCode());
            FileSettings $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
            S3Settings $s3 = this.getS3();
            result = result * 59 + ($s3 == null ? 43 : ((Object)$s3).hashCode());
            return result;
        }

        public String toString() {
            return "DialobSettings.DatabaseSettings(databaseType=" + this.getDatabaseType() + ", jdbc=" + this.getJdbc() + ", file=" + this.getFile() + ", s3=" + this.getS3() + ")";
        }

        public static class S3Settings {
            private String bucket;
            private String prefix = "";

            public String getBucket() {
                return this.bucket;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public void setBucket(String bucket) {
                this.bucket = bucket;
            }

            public void setPrefix(String prefix) {
                this.prefix = prefix;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof S3Settings)) {
                    return false;
                }
                S3Settings other = (S3Settings)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$bucket = this.getBucket();
                String other$bucket = other.getBucket();
                if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
                    return false;
                }
                String this$prefix = this.getPrefix();
                String other$prefix = other.getPrefix();
                return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
            }

            protected boolean canEqual(Object other) {
                return other instanceof S3Settings;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $bucket = this.getBucket();
                result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
                String $prefix = this.getPrefix();
                result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
                return result;
            }

            public String toString() {
                return "DialobSettings.DatabaseSettings.S3Settings(bucket=" + this.getBucket() + ", prefix=" + this.getPrefix() + ")";
            }
        }

        public static class FileSettings {
            private String directory;

            public String getDirectory() {
                return this.directory;
            }

            public void setDirectory(String directory) {
                this.directory = directory;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FileSettings)) {
                    return false;
                }
                FileSettings other = (FileSettings)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$directory = this.getDirectory();
                String other$directory = other.getDirectory();
                return !(this$directory == null ? other$directory != null : !this$directory.equals(other$directory));
            }

            protected boolean canEqual(Object other) {
                return other instanceof FileSettings;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $directory = this.getDirectory();
                result = result * 59 + ($directory == null ? 43 : $directory.hashCode());
                return result;
            }

            public String toString() {
                return "DialobSettings.DatabaseSettings.FileSettings(directory=" + this.getDirectory() + ")";
            }
        }

        public static class JdbcSettings {
            private String schema;
            private Map<String, String> remap;

            public String getSchema() {
                return this.schema;
            }

            public Map<String, String> getRemap() {
                return this.remap;
            }

            public void setSchema(String schema) {
                this.schema = schema;
            }

            public void setRemap(Map<String, String> remap) {
                this.remap = remap;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof JdbcSettings)) {
                    return false;
                }
                JdbcSettings other = (JdbcSettings)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$schema = this.getSchema();
                String other$schema = other.getSchema();
                if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
                    return false;
                }
                Map<String, String> this$remap = this.getRemap();
                Map<String, String> other$remap = other.getRemap();
                return !(this$remap == null ? other$remap != null : !((Object)this$remap).equals(other$remap));
            }

            protected boolean canEqual(Object other) {
                return other instanceof JdbcSettings;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $schema = this.getSchema();
                result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
                Map<String, String> $remap = this.getRemap();
                result = result * 59 + ($remap == null ? 43 : ((Object)$remap).hashCode());
                return result;
            }

            public String toString() {
                return "DialobSettings.DatabaseSettings.JdbcSettings(schema=" + this.getSchema() + ", remap=" + this.getRemap() + ")";
            }
        }
    }

    public static class DialobAssetsServiceSettings {
        private String url;
        private String authorization;

        public String getUrl() {
            return this.url;
        }

        public String getAuthorization() {
            return this.authorization;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setAuthorization(String authorization) {
            this.authorization = authorization;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DialobAssetsServiceSettings)) {
                return false;
            }
            DialobAssetsServiceSettings other = (DialobAssetsServiceSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$authorization = this.getAuthorization();
            String other$authorization = other.getAuthorization();
            return !(this$authorization == null ? other$authorization != null : !this$authorization.equals(other$authorization));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DialobAssetsServiceSettings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $authorization = this.getAuthorization();
            result = result * 59 + ($authorization == null ? 43 : $authorization.hashCode());
            return result;
        }

        public String toString() {
            return "DialobSettings.DialobAssetsServiceSettings(url=" + this.getUrl() + ", authorization=" + this.getAuthorization() + ")";
        }
    }

    public static class DialobAssetsSettings {
        private DialobAssetsServiceSettings service = new DialobAssetsServiceSettings();

        public DialobAssetsServiceSettings getService() {
            return this.service;
        }

        public void setService(DialobAssetsServiceSettings service) {
            this.service = service;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DialobAssetsSettings)) {
                return false;
            }
            DialobAssetsSettings other = (DialobAssetsSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DialobAssetsServiceSettings this$service = this.getService();
            DialobAssetsServiceSettings other$service = other.getService();
            return !(this$service == null ? other$service != null : !((Object)this$service).equals(other$service));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DialobAssetsSettings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DialobAssetsServiceSettings $service = this.getService();
            result = result * 59 + ($service == null ? 43 : ((Object)$service).hashCode());
            return result;
        }

        public String toString() {
            return "DialobSettings.DialobAssetsSettings(service=" + this.getService() + ")";
        }
    }

    public static enum DatabaseType {
        NONE,
        COUCHDB,
        MONGODB,
        FILEDB,
        DIALOBAPIDB,
        JDBC,
        ASSETS,
        S3;

    }
}

