/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.rest;

import io.dialob.api.proto.Action;
import io.dialob.api.proto.Actions;
import io.dialob.api.proto.ImmutableAction;
import io.dialob.api.proto.ImmutableActions;
import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.questionnaire.service.api.ActionProcessingService;
import io.dialob.questionnaire.service.api.FormActions;
import io.dialob.questionnaire.service.api.FormActionsUpdatesCallback;
import io.dialob.questionnaire.service.api.QuestionnaireActionsService;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.dialob.security.user.CurrentUser;
import io.dialob.security.user.CurrentUserProvider;
import io.dialob.session.rest.AnswerController;
import io.dialob.session.rest.SessionPermissionEvaluator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DefaultAnswerController
implements AnswerController,
QuestionnaireActionsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAnswerController.class);
    private final QuestionnaireSessionService questionnaireSessionService;
    private final boolean returnStackTrace;
    private final ActionProcessingService actionProcessingService;
    private final SessionPermissionEvaluator sessionPermissionEvaluator;
    private final Optional<CurrentUserProvider> currentUserProvider;
    private long warningThreshold = 2000000000L;

    DefaultAnswerController(QuestionnaireSessionService questionnaireSessionService, ActionProcessingService actionProcessingService, SessionPermissionEvaluator sessionPermissionEvaluator, boolean returnStackTrace, Optional<CurrentUserProvider> currentUserProvider) {
        this.questionnaireSessionService = questionnaireSessionService;
        this.actionProcessingService = actionProcessingService;
        this.sessionPermissionEvaluator = sessionPermissionEvaluator;
        this.returnStackTrace = returnStackTrace;
        this.currentUserProvider = currentUserProvider;
    }

    public void setWarningThreshold(long warningThreshold) {
        this.warningThreshold = warningThreshold;
    }

    @Override
    public ResponseEntity<Actions> getState(String sessionId) {
        long start = System.nanoTime();
        LOGGER.debug("Received 'GET /{}' request", (Object)sessionId);
        if (!this.sessionPermissionEvaluator.hasAccess(sessionId, this.currentUser())) {
            return this.createQuestionnaireNotFoundResponse(sessionId, null);
        }
        ImmutableActions.Builder actions = ImmutableActions.builder();
        try {
            QuestionnaireSession questionnaireSession = this.getQuestionnaireSession(sessionId);
            FormActions formActions = new FormActions();
            questionnaireSession.buildFullForm((QuestionnaireSession.UpdatesCallback)new FormActionsUpdatesCallback(formActions));
            actions.actions((Iterable)formActions.getActions());
            actions.rev(questionnaireSession.getRevision());
        }
        catch (DocumentNotFoundException e) {
            return this.createQuestionnaireNotFoundResponse(sessionId, e);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Dialog fetch failed: %s", e.getMessage()), (Throwable)e);
            return this.createServiceErrorResponse(e);
        }
        long time = System.nanoTime() - start;
        if (time > this.warningThreshold) {
            LOGGER.warn("Request time {}ns exceeds warning threshold {}.", (Object)time, (Object)this.warningThreshold);
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Request time {}ms", (Object)((double)time / 1000000.0));
        }
        return ResponseEntity.ok((Object)actions.build());
    }

    private String currentUser() {
        if (this.currentUserProvider.isPresent()) {
            CurrentUser currentUser = this.currentUserProvider.get().get();
            if (currentUser != null) {
                return currentUser.getUserId();
            }
        } else {
            LOGGER.debug("No currentUserProvider defined");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseEntity<Actions> answers(@NonNull String sessionId, Actions actions) {
        if (!this.sessionPermissionEvaluator.hasAccess(sessionId, this.currentUser())) {
            return this.createQuestionnaireNotFoundResponse(sessionId, null);
        }
        long start = System.nanoTime();
        try {
            ResponseEntity responseEntity = ResponseEntity.ok((Object)this.answerQuestion(sessionId, actions.getRev(), actions.getActions()));
            return responseEntity;
        }
        catch (DocumentNotFoundException e) {
            ResponseEntity<Actions> responseEntity = this.createQuestionnaireNotFoundResponse(sessionId, e);
            return responseEntity;
        }
        catch (Exception e) {
            LOGGER.error(String.format("Dialog update failed: %s", e.getMessage()), (Throwable)e);
            ResponseEntity<Actions> responseEntity = this.createServiceErrorResponse(e);
            return responseEntity;
        }
        finally {
            long time = System.nanoTime() - start;
            if (time > this.warningThreshold) {
                LOGGER.warn("Request time {}ns exceeds warning threshold {}.", (Object)time, (Object)this.warningThreshold);
            } else if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Request time {}ms", (Object)((double)time / 1000000.0));
            }
        }
    }

    @NonNull
    protected QuestionnaireSession getQuestionnaireSession(String sessionId) {
        QuestionnaireSession questionnaireSession = this.questionnaireSessionService.findOne(sessionId);
        if (questionnaireSession == null) {
            throw new DocumentNotFoundException("Questionnaire " + sessionId + " not found");
        }
        return questionnaireSession;
    }

    protected ResponseEntity<Actions> createQuestionnaireNotFoundResponse(String sessionId, DocumentNotFoundException e) {
        LOGGER.debug("Action QUESTIONNAIRE_NOT_FOUND: backend response '{}'", (Object)(e != null ? e.getMessage() : "Security block"));
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)ImmutableActions.builder().addActions((Action)ImmutableAction.builder().type(Action.Type.SERVER_ERROR).serverEvent(Boolean.valueOf(true)).message("not found").id(sessionId).build()).build());
    }

    private ResponseEntity<Actions> createServiceErrorResponse(Exception e) {
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ImmutableActions.builder().addActions(this.createNotifyServerErrorAction(e)).build());
    }

    private Action createNotifyServerErrorAction(Exception e) {
        ImmutableAction.Builder action = ImmutableAction.builder();
        action.type(Action.Type.SERVER_ERROR);
        action.serverEvent(Boolean.valueOf(true));
        if (this.returnStackTrace) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            action.message(e.getMessage());
            action.trace(sw.toString());
        }
        return action.build();
    }

    @NonNull
    public Actions answerQuestion(@NonNull String questionnaireId, String revision, @NonNull List<Action> actions) {
        return this.actionProcessingService.answerQuestion(questionnaireId, revision, actions);
    }
}

