/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.rest;

import io.dialob.questionnaire.service.api.ActionProcessingService;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.dialob.security.user.CurrentUserProvider;
import io.dialob.session.rest.AnswerController;
import io.dialob.session.rest.DefaultAnswerController;
import io.dialob.session.rest.SessionPermissionEvaluator;
import io.dialob.settings.DialobSettings;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class DialobSessionRestAutoConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="dialob.session.rest", name={"enabled"}, havingValue="true")
    public AnswerController answerController(QuestionnaireSessionService questionnaireSessionService, ActionProcessingService actionProcessingService, SessionPermissionEvaluator sessionPermissionEvaluator, DialobSettings dialobSettings, Optional<CurrentUserProvider> currentUserProvider) {
        return new DefaultAnswerController(questionnaireSessionService, actionProcessingService, sessionPermissionEvaluator, dialobSettings.getSession().isReturnStackTrace(), currentUserProvider);
    }

    @Bean
    @ConditionalOnMissingBean(value={SessionPermissionEvaluator.class})
    public SessionPermissionEvaluator sessionPermissionEvaluator() {
        return (sessionId, userId) -> true;
    }
}

