/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.rest;

import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.dialob.session.rest.SessionPermissionEvaluator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlyOwnerCanAccessSessionPermissionEvaluator
implements SessionPermissionEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlyOwnerCanAccessSessionPermissionEvaluator.class);
    private final QuestionnaireSessionService questionnaireSessionService;

    public OnlyOwnerCanAccessSessionPermissionEvaluator(QuestionnaireSessionService questionnaireSessionService) {
        this.questionnaireSessionService = questionnaireSessionService;
    }

    @Override
    public boolean hasAccess(String sessionId, String userId) {
        if (StringUtils.isBlank((CharSequence)userId) || StringUtils.isBlank((CharSequence)sessionId)) {
            LOGGER.trace("{} access to {} denied", (Object)userId, (Object)sessionId);
            return false;
        }
        QuestionnaireSession questionnaireSession = this.questionnaireSessionService.findOne(sessionId);
        boolean access = userId.equals(questionnaireSession.getOwner());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} access to {} {}. Onwer id {}", new Object[]{userId, sessionId, access ? "granted" : "denied", questionnaireSession.getOwner()});
        }
        return access;
    }
}

