/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.session.boot;

import io.dialob.db.spi.exceptions.DocumentNotFoundException;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionService;
import io.dialob.security.tenant.ImmutableTenant;
import io.dialob.security.tenant.Tenant;
import io.dialob.session.boot.TenantFromRequestResolver;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;

public class SessionRestTenantFromRequestResolver
implements TenantFromRequestResolver {
    private final QuestionnaireSessionService questionnaireSessionService;

    public SessionRestTenantFromRequestResolver(@NonNull QuestionnaireSessionService questionnaireSessionService) {
        this.questionnaireSessionService = questionnaireSessionService;
    }

    public Optional<Tenant> resolveTenantFromRequest(HttpServletRequest request) {
        String pathInfo = request.getRequestURI();
        if (StringUtils.isNotBlank((CharSequence)pathInfo)) {
            String sessionId = this.getSessionId(pathInfo);
            try {
                return this.getQuestionnaireSession(sessionId).map(QuestionnaireSession::getTenantId).map(tId -> ImmutableTenant.of((String)tId, Optional.empty()));
            }
            catch (DocumentNotFoundException dnfe) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    protected String getSessionId(String pathInfo) {
        if (pathInfo.startsWith("/session/socket/-/")) {
            pathInfo = pathInfo.substring(18);
            return StringUtils.substringBefore((String)pathInfo, (String)"/");
        }
        return StringUtils.substringAfterLast((String)pathInfo, (String)"/");
    }

    @NonNull
    protected Optional<QuestionnaireSession> getQuestionnaireSession(String sessionId) {
        return Optional.ofNullable(this.questionnaireSessionService.findOne(sessionId));
    }
}

