/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.service.common;

import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.dialob.service.common.rest.ServiceExceptionMapper;
import io.dialob.service.common.security.SecurityDisabledConfigurer;
import io.dialob.settings.DialobSettings;
import java.nio.charset.Charset;
import java.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.converter.StringHttpMessageConverter;

@Configuration(proxyBeanMethods=false)
@Import(value={ServiceExceptionMapper.class})
public class DialobServiceCommonAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobServiceCommonAutoConfiguration.class);

    @Bean
    public StringHttpMessageConverter stringEncodingConverter() {
        LOGGER.debug("Constructing bean stringEncodingConverter");
        return new StringHttpMessageConverter(Charset.forName("UTF-8"));
    }

    @Bean
    public Clock clock() {
        return Clock.systemDefaultZone();
    }

    @Bean
    public JavaTimeModule javaTimeModule() {
        return new JavaTimeModule();
    }

    @Bean
    public Jdk8Module jdk8Module() {
        return new Jdk8Module();
    }

    @Bean
    @ConditionalOnProperty(name={"dialob.security.enabled"}, havingValue="false")
    public SecurityDisabledConfigurer securityDisabledConfigurer(DialobSettings dialobSettings) {
        return new SecurityDisabledConfigurer(dialobSettings);
    }
}

