/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.service.common;

import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.dialob.service.common.rest.ServiceExceptionMapper;
import io.dialob.service.common.security.SecurityDisabledConfiguration;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.converter.StringHttpMessageConverter;

@Configuration(proxyBeanMethods=false)
@Import(value={ServiceExceptionMapper.class, SecurityDisabledConfiguration.class})
public class DialobServiceCommonAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialobServiceCommonAutoConfiguration.class);

    @Bean
    public StringHttpMessageConverter stringEncodingConverter() {
        LOGGER.debug("Constructing bean stringEncodingConverter");
        return new StringHttpMessageConverter(StandardCharsets.UTF_8);
    }

    @Bean
    public Clock clock() {
        return Clock.systemDefaultZone();
    }

    @Bean
    public JavaTimeModule javaTimeModule() {
        return new JavaTimeModule();
    }

    @Bean
    public Jdk8Module jdk8Module() {
        return new Jdk8Module();
    }
}

