/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.service.common.security;

import io.dialob.security.spring.tenant.DefaultTenantSupplier;
import io.dialob.security.spring.tenant.RequestParameterTenantScopeFilter;
import io.dialob.security.spring.tenant.TenantAccessEvaluator;
import io.dialob.security.tenant.ImmutableTenant;
import io.dialob.settings.DialobSettings;
import java.util.Arrays;
import java.util.Optional;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="dialob.security", name={"enabled"}, havingValue="false")
public class SecurityDisabledConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityDisabledConfiguration.class);
    private static final CorsConfiguration PERMIT_ALL_CORS = new CorsConfiguration();
    private DialobSettings.TenantSettings tenantSettings;

    public SecurityDisabledConfiguration(DialobSettings dialobSettings) {
        this.tenantSettings = dialobSettings.getTenant();
    }

    @Bean
    SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        LOGGER.warn("Security disabled!");
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/**").authorizeRequests().anyRequest()).permitAll().and()).csrf().disable()).cors().configurationSource(request -> PERMIT_ALL_CORS).and()).headers().frameOptions().disable();
        this.configureRequestParameterTenantScopeFilter(http);
        return (SecurityFilterChain)http.build();
    }

    protected HttpSecurity configureRequestParameterTenantScopeFilter(HttpSecurity http) {
        this.getRequestParameterTenantScopeFilter().ifPresent(requestParameterTenantScopeFilter -> http.addFilterAfter((Filter)requestParameterTenantScopeFilter, ExceptionTranslationFilter.class));
        return http;
    }

    @NonNull
    protected Optional<RequestParameterTenantScopeFilter> getRequestParameterTenantScopeFilter() {
        RequestParameterTenantScopeFilter requestParameterTenantScopeFilter = new RequestParameterTenantScopeFilter(this.getTenantPermissionEvaluator(), this.getDefaultTenantSupplier());
        requestParameterTenantScopeFilter.setTenantRequiredMatcher(this.getTenantRequiredMatcher());
        requestParameterTenantScopeFilter.setParameterName(this.tenantSettings.getUrlParameter());
        return Optional.of(requestParameterTenantScopeFilter);
    }

    private DefaultTenantSupplier getDefaultTenantSupplier() {
        if (StringUtils.isEmpty((CharSequence)this.tenantSettings.getFixedId())) {
            return () -> Optional.empty();
        }
        return () -> Optional.of(ImmutableTenant.of((String)this.tenantSettings.getFixedId(), Optional.empty()));
    }

    @NonNull
    protected RequestMatcher getTenantRequiredMatcher() {
        return request -> this.tenantSettings.getMode() == DialobSettings.TenantSettings.Mode.URL_PARAM;
    }

    @NonNull
    protected TenantAccessEvaluator getTenantPermissionEvaluator() {
        return tenant -> true;
    }

    static {
        PERMIT_ALL_CORS.setAllowedMethods(Arrays.asList("GET", "HEAD", "POST", "PUT", "DELETE"));
        PERMIT_ALL_CORS.applyPermitDefaultValues();
    }
}

