/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security.tenant;

import io.dialob.security.tenant.CurrentTenant;
import io.dialob.security.tenant.ImmutableTenant;
import io.dialob.security.tenant.Tenant;
import java.util.Objects;
import java.util.Optional;

public class FixedCurrentTenant
implements CurrentTenant {
    private final Tenant tenant;

    public FixedCurrentTenant(String tenantId) {
        this(tenantId, null);
    }

    public FixedCurrentTenant(String tenantId, String name) {
        this(ImmutableTenant.of(Objects.requireNonNull(tenantId, "tenant id may no be null"), Optional.ofNullable(name)));
    }

    public FixedCurrentTenant(Tenant tenant) {
        this.tenant = Objects.requireNonNull(tenant, "tenant may no be null");
    }

    @Override
    public Tenant get() {
        return this.tenant;
    }

    @Override
    public boolean isInTenantScope() {
        return true;
    }
}

