/*
 * Copyright © 2015 - 2021 ReSys (info@dialob.io)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.dialob.security.key;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Optional;

import org.immutables.value.Value;

@Value.Immutable
@Value.Style()
public interface ApiKey extends Serializable {

  @Value.Parameter
  String getClientId();

  Optional<String> getToken();

  Optional<String> getHash();

  default boolean isValid() {
    return getHash().isPresent() && !getToken().isPresent();
  }

  Optional<String> getTenantId();

  Optional<String> getOwner();

  Optional<LocalDateTime> getCreated();

  Optional<LocalDateTime> getStartDateTime();

  Optional<LocalDateTime> getEndDateTime();

}
