package io.dialob.security.key;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ApiKey}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableApiKey.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableApiKey.of()}.
 */
@Generated(from = "ApiKey", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableApiKey implements ApiKey {
  private final String clientId;
  private final @Nullable String token;
  private final @Nullable String hash;
  private final @Nullable String tenantId;
  private final @Nullable String owner;
  private final @Nullable LocalDateTime created;
  private final @Nullable LocalDateTime startDateTime;
  private final @Nullable LocalDateTime endDateTime;

  private ImmutableApiKey(String clientId) {
    this.clientId = Objects.requireNonNull(clientId, "clientId");
    this.token = null;
    this.hash = null;
    this.tenantId = null;
    this.owner = null;
    this.created = null;
    this.startDateTime = null;
    this.endDateTime = null;
  }

  private ImmutableApiKey(
      String clientId,
      @Nullable String token,
      @Nullable String hash,
      @Nullable String tenantId,
      @Nullable String owner,
      @Nullable LocalDateTime created,
      @Nullable LocalDateTime startDateTime,
      @Nullable LocalDateTime endDateTime) {
    this.clientId = clientId;
    this.token = token;
    this.hash = hash;
    this.tenantId = tenantId;
    this.owner = owner;
    this.created = created;
    this.startDateTime = startDateTime;
    this.endDateTime = endDateTime;
  }

  /**
   * @return The value of the {@code clientId} attribute
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @Override
  public Optional<String> getToken() {
    return Optional.ofNullable(token);
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @Override
  public Optional<String> getHash() {
    return Optional.ofNullable(hash);
  }

  /**
   * @return The value of the {@code tenantId} attribute
   */
  @Override
  public Optional<String> getTenantId() {
    return Optional.ofNullable(tenantId);
  }

  /**
   * @return The value of the {@code owner} attribute
   */
  @Override
  public Optional<String> getOwner() {
    return Optional.ofNullable(owner);
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @Override
  public Optional<LocalDateTime> getCreated() {
    return Optional.ofNullable(created);
  }

  /**
   * @return The value of the {@code startDateTime} attribute
   */
  @Override
  public Optional<LocalDateTime> getStartDateTime() {
    return Optional.ofNullable(startDateTime);
  }

  /**
   * @return The value of the {@code endDateTime} attribute
   */
  @Override
  public Optional<LocalDateTime> getEndDateTime() {
    return Optional.ofNullable(endDateTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ApiKey#getClientId() clientId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for clientId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableApiKey withClientId(String value) {
    String newValue = Objects.requireNonNull(value, "clientId");
    if (this.clientId.equals(newValue)) return this;
    return new ImmutableApiKey(
        newValue,
        this.token,
        this.hash,
        this.tenantId,
        this.owner,
        this.created,
        this.startDateTime,
        this.endDateTime);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ApiKey#getToken() token} attribute.
   * @param value The value for token
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApiKey withToken(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "token");
    if (Objects.equals(this.token, newValue)) return this;
    return new ImmutableApiKey(
        this.clientId,
        newValue,
        this.hash,
        this.tenantId,
        this.owner,
        this.created,
        this.startDateTime,
        this.endDateTime);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ApiKey#getToken() token} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for token
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApiKey withToken(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.token, value)) return this;
    return new ImmutableApiKey(
        this.clientId,
        value,
        this.hash,
        this.tenantId,
        this.owner,
        this.created,
        this.startDateTime,
        this.endDateTime);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ApiKey#getHash() hash} attribute.
   * @param value The value for hash
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApiKey withHash(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "hash");
    if (Objects.equals(this.hash, newValue)) return this;
    return new ImmutableApiKey(
        this.clientId,
        this.token,
        newValue,
        this.tenantId,
        this.owner,
        this.created,
        this.startDateTime,
        this.endDateTime);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ApiKey#getHash() hash} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for hash
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApiKey withHash(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.hash, value)) return this;
    return new ImmutableApiKey(
        this.clientId,
        this.token,
        value,
        this.tenantId,
        this.owner,
        this.created,
        this.startDateTime,
        this.endDateTime);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ApiKey#getTenantId() tenantId} attribute.
   * @param value The value for tenantId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApiKey withTenantId(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "tenantId");
    if (Objects.equals(this.tenantId, newValue)) return this;
    return new ImmutableApiKey(
        this.clientId,
        this.token,
        this.hash,
        newValue,
        this.owner,
        this.created,
        this.startDateTime,
        this.endDateTime);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ApiKey#getTenantId() tenantId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for tenantId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApiKey withTenantId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableApiKey(
        this.clientId,
        this.token,
        this.hash,
        value,
        this.owner,
        this.created,
        this.startDateTime,
        this.endDateTime);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ApiKey#getOwner() owner} attribute.
   * @param value The value for owner
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApiKey withOwner(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "owner");
    if (Objects.equals(this.owner, newValue)) return this;
    return new ImmutableApiKey(
        this.clientId,
        this.token,
        this.hash,
        this.tenantId,
        newValue,
        this.created,
        this.startDateTime,
        this.endDateTime);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ApiKey#getOwner() owner} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for owner
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApiKey withOwner(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.owner, value)) return this;
    return new ImmutableApiKey(
        this.clientId,
        this.token,
        this.hash,
        this.tenantId,
        value,
        this.created,
        this.startDateTime,
        this.endDateTime);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ApiKey#getCreated() created} attribute.
   * @param value The value for created
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApiKey withCreated(LocalDateTime value) {
    @Nullable LocalDateTime newValue = Objects.requireNonNull(value, "created");
    if (this.created == newValue) return this;
    return new ImmutableApiKey(
        this.clientId,
        this.token,
        this.hash,
        this.tenantId,
        this.owner,
        newValue,
        this.startDateTime,
        this.endDateTime);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ApiKey#getCreated() created} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for created
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableApiKey withCreated(Optional<? extends LocalDateTime> optional) {
    @Nullable LocalDateTime value = optional.orElse(null);
    if (this.created == value) return this;
    return new ImmutableApiKey(
        this.clientId,
        this.token,
        this.hash,
        this.tenantId,
        this.owner,
        value,
        this.startDateTime,
        this.endDateTime);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ApiKey#getStartDateTime() startDateTime} attribute.
   * @param value The value for startDateTime
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApiKey withStartDateTime(LocalDateTime value) {
    @Nullable LocalDateTime newValue = Objects.requireNonNull(value, "startDateTime");
    if (this.startDateTime == newValue) return this;
    return new ImmutableApiKey(
        this.clientId,
        this.token,
        this.hash,
        this.tenantId,
        this.owner,
        this.created,
        newValue,
        this.endDateTime);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ApiKey#getStartDateTime() startDateTime} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for startDateTime
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableApiKey withStartDateTime(Optional<? extends LocalDateTime> optional) {
    @Nullable LocalDateTime value = optional.orElse(null);
    if (this.startDateTime == value) return this;
    return new ImmutableApiKey(
        this.clientId,
        this.token,
        this.hash,
        this.tenantId,
        this.owner,
        this.created,
        value,
        this.endDateTime);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ApiKey#getEndDateTime() endDateTime} attribute.
   * @param value The value for endDateTime
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApiKey withEndDateTime(LocalDateTime value) {
    @Nullable LocalDateTime newValue = Objects.requireNonNull(value, "endDateTime");
    if (this.endDateTime == newValue) return this;
    return new ImmutableApiKey(
        this.clientId,
        this.token,
        this.hash,
        this.tenantId,
        this.owner,
        this.created,
        this.startDateTime,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ApiKey#getEndDateTime() endDateTime} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for endDateTime
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableApiKey withEndDateTime(Optional<? extends LocalDateTime> optional) {
    @Nullable LocalDateTime value = optional.orElse(null);
    if (this.endDateTime == value) return this;
    return new ImmutableApiKey(
        this.clientId,
        this.token,
        this.hash,
        this.tenantId,
        this.owner,
        this.created,
        this.startDateTime,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableApiKey} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableApiKey
        && equalTo((ImmutableApiKey) another);
  }

  private boolean equalTo(ImmutableApiKey another) {
    return clientId.equals(another.clientId)
        && Objects.equals(token, another.token)
        && Objects.equals(hash, another.hash)
        && Objects.equals(tenantId, another.tenantId)
        && Objects.equals(owner, another.owner)
        && Objects.equals(created, another.created)
        && Objects.equals(startDateTime, another.startDateTime)
        && Objects.equals(endDateTime, another.endDateTime);
  }

  /**
   * Computes a hash code from attributes: {@code clientId}, {@code token}, {@code hash}, {@code tenantId}, {@code owner}, {@code created}, {@code startDateTime}, {@code endDateTime}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + Objects.hashCode(token);
    h += (h << 5) + Objects.hashCode(hash);
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Objects.hashCode(owner);
    h += (h << 5) + Objects.hashCode(created);
    h += (h << 5) + Objects.hashCode(startDateTime);
    h += (h << 5) + Objects.hashCode(endDateTime);
    return h;
  }

  /**
   * Prints the immutable value {@code ApiKey} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ApiKey{");
    builder.append("clientId=").append(clientId);
    if (token != null) {
      builder.append(", ");
      builder.append("token=").append(token);
    }
    if (hash != null) {
      builder.append(", ");
      builder.append("hash=").append(hash);
    }
    if (tenantId != null) {
      builder.append(", ");
      builder.append("tenantId=").append(tenantId);
    }
    if (owner != null) {
      builder.append(", ");
      builder.append("owner=").append(owner);
    }
    if (created != null) {
      builder.append(", ");
      builder.append("created=").append(created);
    }
    if (startDateTime != null) {
      builder.append(", ");
      builder.append("startDateTime=").append(startDateTime);
    }
    if (endDateTime != null) {
      builder.append(", ");
      builder.append("endDateTime=").append(endDateTime);
    }
    return builder.append("}").toString();
  }

  /**
   * Construct a new immutable {@code ApiKey} instance.
   * @param clientId The value for the {@code clientId} attribute
   * @return An immutable ApiKey instance
   */
  public static ImmutableApiKey of(String clientId) {
    return new ImmutableApiKey(clientId);
  }

  /**
   * Creates an immutable copy of a {@link ApiKey} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ApiKey instance
   */
  public static ImmutableApiKey copyOf(ApiKey instance) {
    if (instance instanceof ImmutableApiKey) {
      return (ImmutableApiKey) instance;
    }
    return ImmutableApiKey.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableApiKey ImmutableApiKey}.
   * <pre>
   * ImmutableApiKey.builder()
   *    .clientId(String) // required {@link ApiKey#getClientId() clientId}
   *    .token(String) // optional {@link ApiKey#getToken() token}
   *    .hash(String) // optional {@link ApiKey#getHash() hash}
   *    .tenantId(String) // optional {@link ApiKey#getTenantId() tenantId}
   *    .owner(String) // optional {@link ApiKey#getOwner() owner}
   *    .created(java.time.LocalDateTime) // optional {@link ApiKey#getCreated() created}
   *    .startDateTime(java.time.LocalDateTime) // optional {@link ApiKey#getStartDateTime() startDateTime}
   *    .endDateTime(java.time.LocalDateTime) // optional {@link ApiKey#getEndDateTime() endDateTime}
   *    .build();
   * </pre>
   * @return A new ImmutableApiKey builder
   */
  public static ImmutableApiKey.Builder builder() {
    return new ImmutableApiKey.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableApiKey ImmutableApiKey}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ApiKey", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String clientId;
    private @Nullable String token;
    private @Nullable String hash;
    private @Nullable String tenantId;
    private @Nullable String owner;
    private @Nullable LocalDateTime created;
    private @Nullable LocalDateTime startDateTime;
    private @Nullable LocalDateTime endDateTime;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApiKey} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApiKey instance) {
      Objects.requireNonNull(instance, "instance");
      clientId(instance.getClientId());
      Optional<String> tokenOptional = instance.getToken();
      if (tokenOptional.isPresent()) {
        token(tokenOptional);
      }
      Optional<String> hashOptional = instance.getHash();
      if (hashOptional.isPresent()) {
        hash(hashOptional);
      }
      Optional<String> tenantIdOptional = instance.getTenantId();
      if (tenantIdOptional.isPresent()) {
        tenantId(tenantIdOptional);
      }
      Optional<String> ownerOptional = instance.getOwner();
      if (ownerOptional.isPresent()) {
        owner(ownerOptional);
      }
      Optional<LocalDateTime> createdOptional = instance.getCreated();
      if (createdOptional.isPresent()) {
        created(createdOptional);
      }
      Optional<LocalDateTime> startDateTimeOptional = instance.getStartDateTime();
      if (startDateTimeOptional.isPresent()) {
        startDateTime(startDateTimeOptional);
      }
      Optional<LocalDateTime> endDateTimeOptional = instance.getEndDateTime();
      if (endDateTimeOptional.isPresent()) {
        endDateTime(endDateTimeOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ApiKey#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link ApiKey#getToken() token} to token.
     * @param token The value for token
     * @return {@code this} builder for chained invocation
     */
    public final Builder token(String token) {
      this.token = Objects.requireNonNull(token, "token");
      return this;
    }

    /**
     * Initializes the optional value {@link ApiKey#getToken() token} to token.
     * @param token The value for token
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder token(Optional<String> token) {
      this.token = token.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ApiKey#getHash() hash} to hash.
     * @param hash The value for hash
     * @return {@code this} builder for chained invocation
     */
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      return this;
    }

    /**
     * Initializes the optional value {@link ApiKey#getHash() hash} to hash.
     * @param hash The value for hash
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hash(Optional<String> hash) {
      this.hash = hash.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ApiKey#getTenantId() tenantId} to tenantId.
     * @param tenantId The value for tenantId
     * @return {@code this} builder for chained invocation
     */
    public final Builder tenantId(String tenantId) {
      this.tenantId = Objects.requireNonNull(tenantId, "tenantId");
      return this;
    }

    /**
     * Initializes the optional value {@link ApiKey#getTenantId() tenantId} to tenantId.
     * @param tenantId The value for tenantId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tenantId(Optional<String> tenantId) {
      this.tenantId = tenantId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ApiKey#getOwner() owner} to owner.
     * @param owner The value for owner
     * @return {@code this} builder for chained invocation
     */
    public final Builder owner(String owner) {
      this.owner = Objects.requireNonNull(owner, "owner");
      return this;
    }

    /**
     * Initializes the optional value {@link ApiKey#getOwner() owner} to owner.
     * @param owner The value for owner
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder owner(Optional<String> owner) {
      this.owner = owner.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ApiKey#getCreated() created} to created.
     * @param created The value for created
     * @return {@code this} builder for chained invocation
     */
    public final Builder created(LocalDateTime created) {
      this.created = Objects.requireNonNull(created, "created");
      return this;
    }

    /**
     * Initializes the optional value {@link ApiKey#getCreated() created} to created.
     * @param created The value for created
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder created(Optional<? extends LocalDateTime> created) {
      this.created = created.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ApiKey#getStartDateTime() startDateTime} to startDateTime.
     * @param startDateTime The value for startDateTime
     * @return {@code this} builder for chained invocation
     */
    public final Builder startDateTime(LocalDateTime startDateTime) {
      this.startDateTime = Objects.requireNonNull(startDateTime, "startDateTime");
      return this;
    }

    /**
     * Initializes the optional value {@link ApiKey#getStartDateTime() startDateTime} to startDateTime.
     * @param startDateTime The value for startDateTime
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startDateTime(Optional<? extends LocalDateTime> startDateTime) {
      this.startDateTime = startDateTime.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ApiKey#getEndDateTime() endDateTime} to endDateTime.
     * @param endDateTime The value for endDateTime
     * @return {@code this} builder for chained invocation
     */
    public final Builder endDateTime(LocalDateTime endDateTime) {
      this.endDateTime = Objects.requireNonNull(endDateTime, "endDateTime");
      return this;
    }

    /**
     * Initializes the optional value {@link ApiKey#getEndDateTime() endDateTime} to endDateTime.
     * @param endDateTime The value for endDateTime
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder endDateTime(Optional<? extends LocalDateTime> endDateTime) {
      this.endDateTime = endDateTime.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableApiKey ImmutableApiKey}.
     * @return An immutable instance of ApiKey
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableApiKey build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableApiKey(clientId, token, hash, tenantId, owner, created, startDateTime, endDateTime);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      return "Cannot build ApiKey, some of required attributes are not set " + attributes;
    }
  }
}
