package io.dialob.security;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ErrorsResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableErrorsResponse.builder()}.
 */
@Generated(from = "ErrorsResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableErrorsResponse implements ErrorsResponse {
  private final @Nullable Date timestamp;
  private final @Nullable Integer status;
  private final @Nullable String error;
  private final @Nullable String message;

  private ImmutableErrorsResponse(ImmutableErrorsResponse.Builder builder) {
    this.status = builder.status;
    this.error = builder.error;
    this.message = builder.message;
    this.timestamp = builder.timestampIsSet()
        ? builder.timestamp
        : ErrorsResponse.super.getTimestamp();
  }

  private ImmutableErrorsResponse(
      @Nullable Date timestamp,
      @Nullable Integer status,
      @Nullable String error,
      @Nullable String message) {
    this.timestamp = timestamp;
    this.status = status;
    this.error = error;
    this.message = message;
  }

  /**
   * @return The value of the {@code timestamp} attribute
   */
  @JsonProperty("timestamp")
  @Override
  public @Nullable Date getTimestamp() {
    return timestamp;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty("status")
  @Override
  public @Nullable Integer getStatus() {
    return status;
  }

  /**
   * @return The value of the {@code error} attribute
   */
  @JsonProperty("error")
  @Override
  public @Nullable String getError() {
    return error;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @JsonProperty("message")
  @Override
  public @Nullable String getMessage() {
    return message;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErrorsResponse#getTimestamp() timestamp} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timestamp (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrorsResponse withTimestamp(@Nullable Date value) {
    if (this.timestamp == value) return this;
    return new ImmutableErrorsResponse(value, this.status, this.error, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErrorsResponse#getStatus() status} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrorsResponse withStatus(@Nullable Integer value) {
    if (Objects.equals(this.status, value)) return this;
    return new ImmutableErrorsResponse(this.timestamp, value, this.error, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErrorsResponse#getError() error} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for error (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrorsResponse withError(@Nullable String value) {
    if (Objects.equals(this.error, value)) return this;
    return new ImmutableErrorsResponse(this.timestamp, this.status, value, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErrorsResponse#getMessage() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableErrorsResponse withMessage(@Nullable String value) {
    if (Objects.equals(this.message, value)) return this;
    return new ImmutableErrorsResponse(this.timestamp, this.status, this.error, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableErrorsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableErrorsResponse
        && equalTo((ImmutableErrorsResponse) another);
  }

  private boolean equalTo(ImmutableErrorsResponse another) {
    return Objects.equals(timestamp, another.timestamp)
        && Objects.equals(status, another.status)
        && Objects.equals(error, another.error)
        && Objects.equals(message, another.message);
  }

  /**
   * Computes a hash code from attributes: {@code timestamp}, {@code status}, {@code error}, {@code message}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(timestamp);
    h += (h << 5) + Objects.hashCode(status);
    h += (h << 5) + Objects.hashCode(error);
    h += (h << 5) + Objects.hashCode(message);
    return h;
  }

  /**
   * Prints the immutable value {@code ErrorsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ErrorsResponse{"
        + "timestamp=" + timestamp
        + ", status=" + status
        + ", error=" + error
        + ", message=" + message
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ErrorsResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ErrorsResponse {
    @Nullable Date timestamp;
    boolean timestampIsSet;
    @Nullable Integer status;
    @Nullable String error;
    @Nullable String message;
    @JsonProperty("timestamp")
    public void setTimestamp(@Nullable Date timestamp) {
      this.timestamp = timestamp;
      this.timestampIsSet = true;
    }
    @JsonProperty("status")
    public void setStatus(@Nullable Integer status) {
      this.status = status;
    }
    @JsonProperty("error")
    public void setError(@Nullable String error) {
      this.error = error;
    }
    @JsonProperty("message")
    public void setMessage(@Nullable String message) {
      this.message = message;
    }
    @Override
    public Date getTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getStatus() { throw new UnsupportedOperationException(); }
    @Override
    public String getError() { throw new UnsupportedOperationException(); }
    @Override
    public String getMessage() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableErrorsResponse fromJson(Json json) {
    ImmutableErrorsResponse.Builder builder = ImmutableErrorsResponse.builder();
    if (json.timestampIsSet) {
      builder.timestamp(json.timestamp);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    if (json.error != null) {
      builder.error(json.error);
    }
    if (json.message != null) {
      builder.message(json.message);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ErrorsResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ErrorsResponse instance
   */
  public static ImmutableErrorsResponse copyOf(ErrorsResponse instance) {
    if (instance instanceof ImmutableErrorsResponse) {
      return (ImmutableErrorsResponse) instance;
    }
    return ImmutableErrorsResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableErrorsResponse ImmutableErrorsResponse}.
   * <pre>
   * ImmutableErrorsResponse.builder()
   *    .timestamp(Date | null) // nullable {@link ErrorsResponse#getTimestamp() timestamp}
   *    .status(Integer | null) // nullable {@link ErrorsResponse#getStatus() status}
   *    .error(String | null) // nullable {@link ErrorsResponse#getError() error}
   *    .message(String | null) // nullable {@link ErrorsResponse#getMessage() message}
   *    .build();
   * </pre>
   * @return A new ImmutableErrorsResponse builder
   */
  public static ImmutableErrorsResponse.Builder builder() {
    return new ImmutableErrorsResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableErrorsResponse ImmutableErrorsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ErrorsResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_TIMESTAMP = 0x1L;
    private long optBits;

    private @Nullable Date timestamp;
    private @Nullable Integer status;
    private @Nullable String error;
    private @Nullable String message;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ErrorsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ErrorsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Date timestampValue = instance.getTimestamp();
      if (timestampValue != null) {
        timestamp(timestampValue);
      }
      @Nullable Integer statusValue = instance.getStatus();
      if (statusValue != null) {
        status(statusValue);
      }
      @Nullable String errorValue = instance.getError();
      if (errorValue != null) {
        error(errorValue);
      }
      @Nullable String messageValue = instance.getMessage();
      if (messageValue != null) {
        message(messageValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ErrorsResponse#getTimestamp() timestamp} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ErrorsResponse#getTimestamp() timestamp}.</em>
     * @param timestamp The value for timestamp (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("timestamp")
    public final Builder timestamp(@Nullable Date timestamp) {
      this.timestamp = timestamp;
      optBits |= OPT_BIT_TIMESTAMP;
      return this;
    }

    /**
     * Initializes the value for the {@link ErrorsResponse#getStatus() status} attribute.
     * @param status The value for status (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("status")
    public final Builder status(@Nullable Integer status) {
      this.status = status;
      return this;
    }

    /**
     * Initializes the value for the {@link ErrorsResponse#getError() error} attribute.
     * @param error The value for error (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("error")
    public final Builder error(@Nullable String error) {
      this.error = error;
      return this;
    }

    /**
     * Initializes the value for the {@link ErrorsResponse#getMessage() message} attribute.
     * @param message The value for message (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("message")
    public final Builder message(@Nullable String message) {
      this.message = message;
      return this;
    }

    /**
     * Builds a new {@link ImmutableErrorsResponse ImmutableErrorsResponse}.
     * @return An immutable instance of ErrorsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableErrorsResponse build() {
      return new ImmutableErrorsResponse(this);
    }

    private boolean timestampIsSet() {
      return (optBits & OPT_BIT_TIMESTAMP) != 0;
    }
  }
}
