/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security.tenant;

import io.dialob.security.tenant.CurrentTenant;
import io.dialob.security.tenant.NoTenantInScopeException;
import io.dialob.security.tenant.Tenant;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.MDC;

public class TenantContextHolderCurrentTenant
implements CurrentTenant {
    private static final ThreadLocal<Tenant> TENANT_THREAD_LOCAL = new ThreadLocal();
    public static final CurrentTenant INSTANCE = new TenantContextHolderCurrentTenant();

    protected TenantContextHolderCurrentTenant() {
    }

    public static void runInTenantContext(@Nonnull Tenant tenant, @Nonnull Runnable runnable) {
        Tenant originalTenant = TENANT_THREAD_LOCAL.get();
        TENANT_THREAD_LOCAL.set(Objects.requireNonNull(tenant));
        MDC.put((String)"tenantId", (String)tenant.getId());
        try {
            runnable.run();
        }
        finally {
            if (originalTenant == null) {
                MDC.remove((String)"tenantId");
            } else {
                MDC.put((String)"tenantId", (String)originalTenant.getId());
            }
            TENANT_THREAD_LOCAL.set(originalTenant);
        }
    }

    public static void setTenant(Tenant tenant) {
        MDC.put((String)"tenantId", (String)tenant.getId());
        TENANT_THREAD_LOCAL.set(tenant);
    }

    public static void removeTenant() {
        TENANT_THREAD_LOCAL.remove();
        MDC.remove((String)"tenantId");
    }

    @Override
    public Tenant get() {
        Tenant tenant = TENANT_THREAD_LOCAL.get();
        if (tenant == null) {
            throw new NoTenantInScopeException();
        }
        return tenant;
    }

    @Override
    public boolean isInTenantScope() {
        return TENANT_THREAD_LOCAL.get() != null;
    }
}

