/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.security.ErrorsResponse;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ErrorsResponse", generator="Immutables")
@Immutable
public final class ImmutableErrorsResponse
implements ErrorsResponse {
    @Nullable
    private final Date timestamp;
    @Nullable
    private final Integer status;
    @Nullable
    private final String error;
    @Nullable
    private final String message;

    private ImmutableErrorsResponse(Builder builder) {
        this.status = builder.status;
        this.error = builder.error;
        this.message = builder.message;
        this.timestamp = builder.timestampIsSet() ? builder.timestamp : ErrorsResponse.super.getTimestamp();
    }

    private ImmutableErrorsResponse(@Nullable Date timestamp, @Nullable Integer status, @Nullable String error, @Nullable String message) {
        this.timestamp = timestamp;
        this.status = status;
        this.error = error;
        this.message = message;
    }

    @Override
    @JsonProperty(value="timestamp")
    @Nullable
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty(value="status")
    @Nullable
    public Integer getStatus() {
        return this.status;
    }

    @Override
    @JsonProperty(value="error")
    @Nullable
    public String getError() {
        return this.error;
    }

    @Override
    @JsonProperty(value="message")
    @Nullable
    public String getMessage() {
        return this.message;
    }

    public final ImmutableErrorsResponse withTimestamp(@Nullable Date value) {
        if (this.timestamp == value) {
            return this;
        }
        return new ImmutableErrorsResponse(value, this.status, this.error, this.message);
    }

    public final ImmutableErrorsResponse withStatus(@Nullable Integer value) {
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableErrorsResponse(this.timestamp, value, this.error, this.message);
    }

    public final ImmutableErrorsResponse withError(@Nullable String value) {
        if (Objects.equals(this.error, value)) {
            return this;
        }
        return new ImmutableErrorsResponse(this.timestamp, this.status, value, this.message);
    }

    public final ImmutableErrorsResponse withMessage(@Nullable String value) {
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return new ImmutableErrorsResponse(this.timestamp, this.status, this.error, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorsResponse && this.equalTo((ImmutableErrorsResponse)another);
    }

    private boolean equalTo(ImmutableErrorsResponse another) {
        return Objects.equals(this.timestamp, another.timestamp) && Objects.equals(this.status, another.status) && Objects.equals(this.error, another.error) && Objects.equals(this.message, another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.timestamp);
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + Objects.hashCode(this.message);
        return h;
    }

    public String toString() {
        return "ErrorsResponse{timestamp=" + this.timestamp + ", status=" + this.status + ", error=" + this.error + ", message=" + this.message + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableErrorsResponse fromJson(Json json) {
        Builder builder = ImmutableErrorsResponse.builder();
        if (json.timestampIsSet) {
            builder.timestamp(json.timestamp);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        return builder.build();
    }

    public static ImmutableErrorsResponse copyOf(ErrorsResponse instance) {
        if (instance instanceof ImmutableErrorsResponse) {
            return (ImmutableErrorsResponse)instance;
        }
        return ImmutableErrorsResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ErrorsResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_TIMESTAMP = 1L;
        private long optBits;
        @Nullable
        private Date timestamp;
        @Nullable
        private Integer status;
        @Nullable
        private String error;
        @Nullable
        private String message;

        private Builder() {
        }

        public final Builder from(ErrorsResponse instance) {
            String messageValue;
            String errorValue;
            Integer statusValue;
            Objects.requireNonNull(instance, "instance");
            Date timestampValue = instance.getTimestamp();
            if (timestampValue != null) {
                this.timestamp(timestampValue);
            }
            if ((statusValue = instance.getStatus()) != null) {
                this.status(statusValue);
            }
            if ((errorValue = instance.getError()) != null) {
                this.error(errorValue);
            }
            if ((messageValue = instance.getMessage()) != null) {
                this.message(messageValue);
            }
            return this;
        }

        @JsonProperty(value="timestamp")
        public final Builder timestamp(@Nullable Date timestamp) {
            this.timestamp = timestamp;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="status")
        public final Builder status(@Nullable Integer status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="error")
        public final Builder error(@Nullable String error) {
            this.error = error;
            return this;
        }

        @JsonProperty(value="message")
        public final Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        public ImmutableErrorsResponse build() {
            return new ImmutableErrorsResponse(this);
        }

        private boolean timestampIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ErrorsResponse", generator="Immutables")
    static final class Json
    implements ErrorsResponse {
        @Nullable
        Date timestamp;
        boolean timestampIsSet;
        @Nullable
        Integer status;
        @Nullable
        String error;
        @Nullable
        String message;

        Json() {
        }

        @JsonProperty(value="timestamp")
        public void setTimestamp(@Nullable Date timestamp) {
            this.timestamp = timestamp;
            this.timestampIsSet = true;
        }

        @JsonProperty(value="status")
        public void setStatus(@Nullable Integer status) {
            this.status = status;
        }

        @JsonProperty(value="error")
        public void setError(@Nullable String error) {
            this.error = error;
        }

        @JsonProperty(value="message")
        public void setMessage(@Nullable String message) {
            this.message = message;
        }

        @Override
        public Date getTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessage() {
            throw new UnsupportedOperationException();
        }
    }
}

