/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security.user;

import io.dialob.security.user.CurrentUser;
import io.dialob.security.user.CurrentUserProvider;
import io.dialob.security.user.UnauthenticatedCurrentUserProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public class DelegateCurrentUserProvider
implements CurrentUserProvider {
    private final List<CurrentUserProvider> currentUserProviders;

    public DelegateCurrentUserProvider(CurrentUserProvider ... currentUserProviders) {
        this(Arrays.asList(currentUserProviders));
    }

    public DelegateCurrentUserProvider(Collection<CurrentUserProvider> currentUserProviders) {
        this.currentUserProviders = new ArrayList<CurrentUserProvider>(currentUserProviders);
        this.currentUserProviders.add(UnauthenticatedCurrentUserProvider.INSTANCE);
    }

    @Override
    @Nonnull
    public CurrentUser get() {
        CurrentUser currentUser = null;
        for (CurrentUserProvider currentUserProvider : this.currentUserProviders) {
            currentUser = currentUserProvider.get();
            if (!this.isValidUser(currentUser)) continue;
            return currentUser;
        }
        if (currentUser == null) {
            throw new IllegalStateException("No valid current user found.");
        }
        return currentUser;
    }

    private boolean isValidUser(CurrentUser currentUser) {
        return !currentUser.getUserId().equals("unauthenticated");
    }
}

