/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security;

import java.nio.ByteBuffer;
import java.util.UUID;
import javax.annotation.Nonnull;

public final class UUIDUtils {
    private UUIDUtils() {
    }

    public static UUID toUUID(@Nonnull byte[] oid) {
        if (oid.length != 16) {
            throw new IllegalArgumentException("UUID is 16 bytes long. oid is " + oid.length + " bytes.");
        }
        ByteBuffer bb = ByteBuffer.wrap(oid);
        long firstLong = bb.getLong();
        long secondLong = bb.getLong();
        return new UUID(firstLong, secondLong);
    }

    public static byte[] toBytes(@Nonnull UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }
}

