package io.dialob.security.tenant;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Tenant}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTenant.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableTenant.of()}.
 */
@Generated(from = "Tenant", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableTenant implements Tenant {
  private final String id;
  private final @Nullable String name;

  private ImmutableTenant(String id, Optional<String> name) {
    this.id = Objects.requireNonNull(id, "id");
    this.name = name.orElse(null);
  }

  private ImmutableTenant(ImmutableTenant original, String id, @Nullable String name) {
    this.id = id;
    this.name = name;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public Optional<String> getName() {
    return Optional.ofNullable(name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Tenant#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTenant withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableTenant(this, newValue, this.name);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Tenant#getName() name} attribute.
   * @param value The value for name
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTenant withName(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "name");
    if (Objects.equals(this.name, newValue)) return this;
    return new ImmutableTenant(this, this.id, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Tenant#getName() name} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for name
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTenant withName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableTenant(this, this.id, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTenant} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTenant
        && equalTo((ImmutableTenant) another);
  }

  private boolean equalTo(ImmutableTenant another) {
    return id.equals(another.id)
        && Objects.equals(name, another.name);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(name);
    return h;
  }

  /**
   * Prints the immutable value {@code Tenant} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Tenant{");
    builder.append("id=").append(id);
    if (name != null) {
      builder.append(", ");
      builder.append("name=").append(name);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Tenant", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Tenant {
    @Nullable String id;
    @Nullable Optional<String> name = Optional.empty();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setName(Optional<String> name) {
      this.name = name;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTenant fromJson(Json json) {
    ImmutableTenant.Builder builder = ImmutableTenant.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code Tenant} instance.
   * @param id The value for the {@code id} attribute
   * @param name The value for the {@code name} attribute
   * @return An immutable Tenant instance
   */
  public static ImmutableTenant of(String id, Optional<String> name) {
    return new ImmutableTenant(id, name);
  }

  /**
   * Creates an immutable copy of a {@link Tenant} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Tenant instance
   */
  public static ImmutableTenant copyOf(Tenant instance) {
    if (instance instanceof ImmutableTenant) {
      return (ImmutableTenant) instance;
    }
    return ImmutableTenant.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTenant ImmutableTenant}.
   * <pre>
   * ImmutableTenant.builder()
   *    .id(String) // required {@link Tenant#getId() id}
   *    .name(String) // optional {@link Tenant#getName() name}
   *    .build();
   * </pre>
   * @return A new ImmutableTenant builder
   */
  public static ImmutableTenant.Builder builder() {
    return new ImmutableTenant.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTenant ImmutableTenant}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Tenant", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private @Nullable String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Tenant} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Tenant instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      Optional<String> nameOptional = instance.getName();
      if (nameOptional.isPresent()) {
        name(nameOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Tenant#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link Tenant#getName() name} to name.
     * @param name The value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      return this;
    }

    /**
     * Initializes the optional value {@link Tenant#getName() name} to name.
     * @param name The value for name
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(Optional<String> name) {
      this.name = name.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTenant ImmutableTenant}.
     * @return An immutable instance of Tenant
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTenant build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTenant(null, id, name);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build Tenant, some of required attributes are not set " + attributes;
    }
  }
}
