/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security.tenant;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.security.tenant.Tenant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Tenant", generator="Immutables")
@Immutable
public final class ImmutableTenant
implements Tenant {
    private final String id;
    @Nullable
    private final String name;

    private ImmutableTenant(String id, Optional<String> name) {
        this.id = Objects.requireNonNull(id, "id");
        this.name = name.orElse(null);
    }

    private ImmutableTenant(ImmutableTenant original, String id, @Nullable String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public final ImmutableTenant withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableTenant(this, newValue, this.name);
    }

    public final ImmutableTenant withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new ImmutableTenant(this, this.id, newValue);
    }

    public final ImmutableTenant withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableTenant(this, this.id, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTenant && this.equalTo((ImmutableTenant)another);
    }

    private boolean equalTo(ImmutableTenant another) {
        return this.id.equals(another.id) && Objects.equals(this.name, another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.name);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Tenant{");
        builder.append("id=").append(this.id);
        if (this.name != null) {
            builder.append(", ");
            builder.append("name=").append(this.name);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTenant fromJson(Json json) {
        Builder builder = ImmutableTenant.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        return builder.build();
    }

    public static ImmutableTenant of(String id, Optional<String> name) {
        return new ImmutableTenant(id, name);
    }

    public static ImmutableTenant copyOf(Tenant instance) {
        if (instance instanceof ImmutableTenant) {
            return (ImmutableTenant)instance;
        }
        return ImmutableTenant.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Tenant", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private String name;

        private Builder() {
        }

        public final Builder from(Tenant instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            Optional<String> nameOptional = instance.getName();
            if (nameOptional.isPresent()) {
                this.name(nameOptional);
            }
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        public ImmutableTenant build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTenant(null, this.id, this.name);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build Tenant, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Tenant", generator="Immutables")
    static final class Json
    implements Tenant {
        @Nullable
        String id;
        @Nullable
        Optional<String> name = Optional.empty();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getName() {
            throw new UnsupportedOperationException();
        }
    }
}

