/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security.key;

import io.dialob.security.key.ApiKey;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ApiKey", generator="Immutables")
@Immutable
public final class ImmutableApiKey
implements ApiKey {
    private final String clientId;
    @Nullable
    private final String token;
    @Nullable
    private final String hash;
    @Nullable
    private final String tenantId;
    @Nullable
    private final String owner;
    @Nullable
    private final LocalDateTime created;
    @Nullable
    private final LocalDateTime startDateTime;
    @Nullable
    private final LocalDateTime endDateTime;

    private ImmutableApiKey(String clientId) {
        this.clientId = Objects.requireNonNull(clientId, "clientId");
        this.token = null;
        this.hash = null;
        this.tenantId = null;
        this.owner = null;
        this.created = null;
        this.startDateTime = null;
        this.endDateTime = null;
    }

    private ImmutableApiKey(String clientId, @Nullable String token, @Nullable String hash, @Nullable String tenantId, @Nullable String owner, @Nullable LocalDateTime created, @Nullable LocalDateTime startDateTime, @Nullable LocalDateTime endDateTime) {
        this.clientId = clientId;
        this.token = token;
        this.hash = hash;
        this.tenantId = tenantId;
        this.owner = owner;
        this.created = created;
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    @Override
    public Optional<String> getHash() {
        return Optional.ofNullable(this.hash);
    }

    @Override
    public Optional<String> getTenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    @Override
    public Optional<String> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    @Override
    public Optional<LocalDateTime> getCreated() {
        return Optional.ofNullable(this.created);
    }

    @Override
    public Optional<LocalDateTime> getStartDateTime() {
        return Optional.ofNullable(this.startDateTime);
    }

    @Override
    public Optional<LocalDateTime> getEndDateTime() {
        return Optional.ofNullable(this.endDateTime);
    }

    public final ImmutableApiKey withClientId(String value) {
        String newValue = Objects.requireNonNull(value, "clientId");
        if (this.clientId.equals(newValue)) {
            return this;
        }
        return new ImmutableApiKey(newValue, this.token, this.hash, this.tenantId, this.owner, this.created, this.startDateTime, this.endDateTime);
    }

    public final ImmutableApiKey withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (Objects.equals(this.token, newValue)) {
            return this;
        }
        return new ImmutableApiKey(this.clientId, newValue, this.hash, this.tenantId, this.owner, this.created, this.startDateTime, this.endDateTime);
    }

    public final ImmutableApiKey withToken(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return new ImmutableApiKey(this.clientId, value, this.hash, this.tenantId, this.owner, this.created, this.startDateTime, this.endDateTime);
    }

    public final ImmutableApiKey withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (Objects.equals(this.hash, newValue)) {
            return this;
        }
        return new ImmutableApiKey(this.clientId, this.token, newValue, this.tenantId, this.owner, this.created, this.startDateTime, this.endDateTime);
    }

    public final ImmutableApiKey withHash(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.hash, value)) {
            return this;
        }
        return new ImmutableApiKey(this.clientId, this.token, value, this.tenantId, this.owner, this.created, this.startDateTime, this.endDateTime);
    }

    public final ImmutableApiKey withTenantId(String value) {
        String newValue = Objects.requireNonNull(value, "tenantId");
        if (Objects.equals(this.tenantId, newValue)) {
            return this;
        }
        return new ImmutableApiKey(this.clientId, this.token, this.hash, newValue, this.owner, this.created, this.startDateTime, this.endDateTime);
    }

    public final ImmutableApiKey withTenantId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableApiKey(this.clientId, this.token, this.hash, value, this.owner, this.created, this.startDateTime, this.endDateTime);
    }

    public final ImmutableApiKey withOwner(String value) {
        String newValue = Objects.requireNonNull(value, "owner");
        if (Objects.equals(this.owner, newValue)) {
            return this;
        }
        return new ImmutableApiKey(this.clientId, this.token, this.hash, this.tenantId, newValue, this.created, this.startDateTime, this.endDateTime);
    }

    public final ImmutableApiKey withOwner(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.owner, value)) {
            return this;
        }
        return new ImmutableApiKey(this.clientId, this.token, this.hash, this.tenantId, value, this.created, this.startDateTime, this.endDateTime);
    }

    public final ImmutableApiKey withCreated(LocalDateTime value) {
        LocalDateTime newValue = Objects.requireNonNull(value, "created");
        if (this.created == newValue) {
            return this;
        }
        return new ImmutableApiKey(this.clientId, this.token, this.hash, this.tenantId, this.owner, newValue, this.startDateTime, this.endDateTime);
    }

    public final ImmutableApiKey withCreated(Optional<? extends LocalDateTime> optional) {
        LocalDateTime value = optional.orElse(null);
        if (this.created == value) {
            return this;
        }
        return new ImmutableApiKey(this.clientId, this.token, this.hash, this.tenantId, this.owner, value, this.startDateTime, this.endDateTime);
    }

    public final ImmutableApiKey withStartDateTime(LocalDateTime value) {
        LocalDateTime newValue = Objects.requireNonNull(value, "startDateTime");
        if (this.startDateTime == newValue) {
            return this;
        }
        return new ImmutableApiKey(this.clientId, this.token, this.hash, this.tenantId, this.owner, this.created, newValue, this.endDateTime);
    }

    public final ImmutableApiKey withStartDateTime(Optional<? extends LocalDateTime> optional) {
        LocalDateTime value = optional.orElse(null);
        if (this.startDateTime == value) {
            return this;
        }
        return new ImmutableApiKey(this.clientId, this.token, this.hash, this.tenantId, this.owner, this.created, value, this.endDateTime);
    }

    public final ImmutableApiKey withEndDateTime(LocalDateTime value) {
        LocalDateTime newValue = Objects.requireNonNull(value, "endDateTime");
        if (this.endDateTime == newValue) {
            return this;
        }
        return new ImmutableApiKey(this.clientId, this.token, this.hash, this.tenantId, this.owner, this.created, this.startDateTime, newValue);
    }

    public final ImmutableApiKey withEndDateTime(Optional<? extends LocalDateTime> optional) {
        LocalDateTime value = optional.orElse(null);
        if (this.endDateTime == value) {
            return this;
        }
        return new ImmutableApiKey(this.clientId, this.token, this.hash, this.tenantId, this.owner, this.created, this.startDateTime, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableApiKey && this.equalTo((ImmutableApiKey)another);
    }

    private boolean equalTo(ImmutableApiKey another) {
        return this.clientId.equals(another.clientId) && Objects.equals(this.token, another.token) && Objects.equals(this.hash, another.hash) && Objects.equals(this.tenantId, another.tenantId) && Objects.equals(this.owner, another.owner) && Objects.equals(this.created, another.created) && Objects.equals(this.startDateTime, another.startDateTime) && Objects.equals(this.endDateTime, another.endDateTime);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + Objects.hashCode(this.token);
        h += (h << 5) + Objects.hashCode(this.hash);
        h += (h << 5) + Objects.hashCode(this.tenantId);
        h += (h << 5) + Objects.hashCode(this.owner);
        h += (h << 5) + Objects.hashCode(this.created);
        h += (h << 5) + Objects.hashCode(this.startDateTime);
        h += (h << 5) + Objects.hashCode(this.endDateTime);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ApiKey{");
        builder.append("clientId=").append(this.clientId);
        if (this.token != null) {
            builder.append(", ");
            builder.append("token=").append(this.token);
        }
        if (this.hash != null) {
            builder.append(", ");
            builder.append("hash=").append(this.hash);
        }
        if (this.tenantId != null) {
            builder.append(", ");
            builder.append("tenantId=").append(this.tenantId);
        }
        if (this.owner != null) {
            builder.append(", ");
            builder.append("owner=").append(this.owner);
        }
        if (this.created != null) {
            builder.append(", ");
            builder.append("created=").append(this.created);
        }
        if (this.startDateTime != null) {
            builder.append(", ");
            builder.append("startDateTime=").append(this.startDateTime);
        }
        if (this.endDateTime != null) {
            builder.append(", ");
            builder.append("endDateTime=").append(this.endDateTime);
        }
        return builder.append("}").toString();
    }

    public static ImmutableApiKey of(String clientId) {
        return new ImmutableApiKey(clientId);
    }

    public static ImmutableApiKey copyOf(ApiKey instance) {
        if (instance instanceof ImmutableApiKey) {
            return (ImmutableApiKey)instance;
        }
        return ImmutableApiKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ApiKey", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String clientId;
        @Nullable
        private String token;
        @Nullable
        private String hash;
        @Nullable
        private String tenantId;
        @Nullable
        private String owner;
        @Nullable
        private LocalDateTime created;
        @Nullable
        private LocalDateTime startDateTime;
        @Nullable
        private LocalDateTime endDateTime;

        private Builder() {
        }

        public final Builder from(ApiKey instance) {
            Optional<LocalDateTime> endDateTimeOptional;
            Optional<LocalDateTime> startDateTimeOptional;
            Optional<LocalDateTime> createdOptional;
            Optional<String> ownerOptional;
            Optional<String> tenantIdOptional;
            Optional<String> hashOptional;
            Objects.requireNonNull(instance, "instance");
            this.clientId(instance.getClientId());
            Optional<String> tokenOptional = instance.getToken();
            if (tokenOptional.isPresent()) {
                this.token(tokenOptional);
            }
            if ((hashOptional = instance.getHash()).isPresent()) {
                this.hash(hashOptional);
            }
            if ((tenantIdOptional = instance.getTenantId()).isPresent()) {
                this.tenantId(tenantIdOptional);
            }
            if ((ownerOptional = instance.getOwner()).isPresent()) {
                this.owner(ownerOptional);
            }
            if ((createdOptional = instance.getCreated()).isPresent()) {
                this.created(createdOptional);
            }
            if ((startDateTimeOptional = instance.getStartDateTime()).isPresent()) {
                this.startDateTime(startDateTimeOptional);
            }
            if ((endDateTimeOptional = instance.getEndDateTime()).isPresent()) {
                this.endDateTime(endDateTimeOptional);
            }
            return this;
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder token(String token) {
            this.token = Objects.requireNonNull(token, "token");
            return this;
        }

        public final Builder token(Optional<String> token) {
            this.token = token.orElse(null);
            return this;
        }

        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            return this;
        }

        public final Builder hash(Optional<String> hash) {
            this.hash = hash.orElse(null);
            return this;
        }

        public final Builder tenantId(String tenantId) {
            this.tenantId = Objects.requireNonNull(tenantId, "tenantId");
            return this;
        }

        public final Builder tenantId(Optional<String> tenantId) {
            this.tenantId = tenantId.orElse(null);
            return this;
        }

        public final Builder owner(String owner) {
            this.owner = Objects.requireNonNull(owner, "owner");
            return this;
        }

        public final Builder owner(Optional<String> owner) {
            this.owner = owner.orElse(null);
            return this;
        }

        public final Builder created(LocalDateTime created) {
            this.created = Objects.requireNonNull(created, "created");
            return this;
        }

        public final Builder created(Optional<? extends LocalDateTime> created) {
            this.created = created.orElse(null);
            return this;
        }

        public final Builder startDateTime(LocalDateTime startDateTime) {
            this.startDateTime = Objects.requireNonNull(startDateTime, "startDateTime");
            return this;
        }

        public final Builder startDateTime(Optional<? extends LocalDateTime> startDateTime) {
            this.startDateTime = startDateTime.orElse(null);
            return this;
        }

        public final Builder endDateTime(LocalDateTime endDateTime) {
            this.endDateTime = Objects.requireNonNull(endDateTime, "endDateTime");
            return this;
        }

        public final Builder endDateTime(Optional<? extends LocalDateTime> endDateTime) {
            this.endDateTime = endDateTime.orElse(null);
            return this;
        }

        public ImmutableApiKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableApiKey(this.clientId, this.token, this.hash, this.tenantId, this.owner, this.created, this.startDateTime, this.endDateTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            return "Cannot build ApiKey, some of required attributes are not set " + attributes;
        }
    }
}

