/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security.uaa.spi.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.security.uaa.spi.model.UaaEntity;
import io.dialob.security.uaa.spi.model.UaaMeta;
import io.dialob.security.uaa.spi.model.UaaUser;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="UaaUser", generator="Immutables")
@Immutable
public final class ImmutableUaaUser
implements UaaUser {
    private final String id;
    private final List<String> schemas;
    private final UaaMeta meta;
    private final UaaUser.Name name;
    private final List<UaaUser.Email> emails;
    private final String externalId;
    private final String userName;
    private final List<UaaUser.Group> groups;
    private final List<UaaUser.Approval> approvals;
    private final Boolean active;
    private final Boolean verified;
    private final String origin;
    private final String zoneId;
    private final OffsetDateTime passwordLastModified;
    private final Long previousLogonTime;
    private final Long lastLogonTime;

    private ImmutableUaaUser(String id, List<String> schemas, UaaMeta meta, UaaUser.Name name, List<UaaUser.Email> emails, String externalId, String userName, List<UaaUser.Group> groups, List<UaaUser.Approval> approvals, Boolean active, Boolean verified, String origin, String zoneId, OffsetDateTime passwordLastModified, Long previousLogonTime, Long lastLogonTime) {
        this.id = id;
        this.schemas = schemas;
        this.meta = meta;
        this.name = name;
        this.emails = emails;
        this.externalId = externalId;
        this.userName = userName;
        this.groups = groups;
        this.approvals = approvals;
        this.active = active;
        this.verified = verified;
        this.origin = origin;
        this.zoneId = zoneId;
        this.passwordLastModified = passwordLastModified;
        this.previousLogonTime = previousLogonTime;
        this.lastLogonTime = lastLogonTime;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    @Override
    @JsonProperty(value="meta")
    public UaaMeta getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty(value="name")
    public UaaUser.Name getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="emails")
    public List<UaaUser.Email> getEmails() {
        return this.emails;
    }

    @Override
    @JsonProperty(value="externalId")
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    @Override
    @JsonProperty(value="groups")
    public List<UaaUser.Group> getGroups() {
        return this.groups;
    }

    @Override
    @JsonProperty(value="approvals")
    public List<UaaUser.Approval> getApprovals() {
        return this.approvals;
    }

    @Override
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    @Override
    @JsonProperty(value="verified")
    public Boolean getVerified() {
        return this.verified;
    }

    @Override
    @JsonProperty(value="origin")
    public String getOrigin() {
        return this.origin;
    }

    @Override
    @JsonProperty(value="zoneId")
    public String getZoneId() {
        return this.zoneId;
    }

    @Override
    @JsonProperty(value="passwordLastModified")
    public OffsetDateTime getPasswordLastModified() {
        return this.passwordLastModified;
    }

    @Override
    @JsonProperty(value="previousLogonTime")
    public Long getPreviousLogonTime() {
        return this.previousLogonTime;
    }

    @Override
    @JsonProperty(value="lastLogonTime")
    public Long getLastLogonTime() {
        return this.lastLogonTime;
    }

    public final ImmutableUaaUser withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableUaaUser(newValue, this.schemas, this.meta, this.name, this.emails, this.externalId, this.userName, this.groups, this.approvals, this.active, this.verified, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withSchemas(String ... elements) {
        List<String> newValue = ImmutableUaaUser.createUnmodifiableList(false, ImmutableUaaUser.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUaaUser(this.id, newValue, this.meta, this.name, this.emails, this.externalId, this.userName, this.groups, this.approvals, this.active, this.verified, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withSchemas(Iterable<String> elements) {
        if (this.schemas == elements) {
            return this;
        }
        List<String> newValue = ImmutableUaaUser.createUnmodifiableList(false, ImmutableUaaUser.createSafeList(elements, true, false));
        return new ImmutableUaaUser(this.id, newValue, this.meta, this.name, this.emails, this.externalId, this.userName, this.groups, this.approvals, this.active, this.verified, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withMeta(UaaMeta value) {
        if (this.meta == value) {
            return this;
        }
        return new ImmutableUaaUser(this.id, this.schemas, value, this.name, this.emails, this.externalId, this.userName, this.groups, this.approvals, this.active, this.verified, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withName(UaaUser.Name value) {
        if (this.name == value) {
            return this;
        }
        return new ImmutableUaaUser(this.id, this.schemas, this.meta, value, this.emails, this.externalId, this.userName, this.groups, this.approvals, this.active, this.verified, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withEmails(UaaUser.Email ... elements) {
        List<UaaUser.Email> newValue = ImmutableUaaUser.createUnmodifiableList(false, ImmutableUaaUser.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUaaUser(this.id, this.schemas, this.meta, this.name, newValue, this.externalId, this.userName, this.groups, this.approvals, this.active, this.verified, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withEmails(Iterable<? extends UaaUser.Email> elements) {
        if (this.emails == elements) {
            return this;
        }
        List<UaaUser.Email> newValue = ImmutableUaaUser.createUnmodifiableList(false, ImmutableUaaUser.createSafeList(elements, true, false));
        return new ImmutableUaaUser(this.id, this.schemas, this.meta, this.name, newValue, this.externalId, this.userName, this.groups, this.approvals, this.active, this.verified, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withExternalId(String value) {
        if (Objects.equals(this.externalId, value)) {
            return this;
        }
        return new ImmutableUaaUser(this.id, this.schemas, this.meta, this.name, this.emails, value, this.userName, this.groups, this.approvals, this.active, this.verified, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withUserName(String value) {
        if (Objects.equals(this.userName, value)) {
            return this;
        }
        return new ImmutableUaaUser(this.id, this.schemas, this.meta, this.name, this.emails, this.externalId, value, this.groups, this.approvals, this.active, this.verified, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withGroups(UaaUser.Group ... elements) {
        List<UaaUser.Group> newValue = ImmutableUaaUser.createUnmodifiableList(false, ImmutableUaaUser.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUaaUser(this.id, this.schemas, this.meta, this.name, this.emails, this.externalId, this.userName, newValue, this.approvals, this.active, this.verified, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withGroups(Iterable<? extends UaaUser.Group> elements) {
        if (this.groups == elements) {
            return this;
        }
        List<UaaUser.Group> newValue = ImmutableUaaUser.createUnmodifiableList(false, ImmutableUaaUser.createSafeList(elements, true, false));
        return new ImmutableUaaUser(this.id, this.schemas, this.meta, this.name, this.emails, this.externalId, this.userName, newValue, this.approvals, this.active, this.verified, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withApprovals(UaaUser.Approval ... elements) {
        List<UaaUser.Approval> newValue = ImmutableUaaUser.createUnmodifiableList(false, ImmutableUaaUser.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUaaUser(this.id, this.schemas, this.meta, this.name, this.emails, this.externalId, this.userName, this.groups, newValue, this.active, this.verified, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withApprovals(Iterable<? extends UaaUser.Approval> elements) {
        if (this.approvals == elements) {
            return this;
        }
        List<UaaUser.Approval> newValue = ImmutableUaaUser.createUnmodifiableList(false, ImmutableUaaUser.createSafeList(elements, true, false));
        return new ImmutableUaaUser(this.id, this.schemas, this.meta, this.name, this.emails, this.externalId, this.userName, this.groups, newValue, this.active, this.verified, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withActive(Boolean value) {
        if (Objects.equals(this.active, value)) {
            return this;
        }
        return new ImmutableUaaUser(this.id, this.schemas, this.meta, this.name, this.emails, this.externalId, this.userName, this.groups, this.approvals, value, this.verified, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withVerified(Boolean value) {
        if (Objects.equals(this.verified, value)) {
            return this;
        }
        return new ImmutableUaaUser(this.id, this.schemas, this.meta, this.name, this.emails, this.externalId, this.userName, this.groups, this.approvals, this.active, value, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withOrigin(String value) {
        if (Objects.equals(this.origin, value)) {
            return this;
        }
        return new ImmutableUaaUser(this.id, this.schemas, this.meta, this.name, this.emails, this.externalId, this.userName, this.groups, this.approvals, this.active, this.verified, value, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withZoneId(String value) {
        if (Objects.equals(this.zoneId, value)) {
            return this;
        }
        return new ImmutableUaaUser(this.id, this.schemas, this.meta, this.name, this.emails, this.externalId, this.userName, this.groups, this.approvals, this.active, this.verified, this.origin, value, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withPasswordLastModified(OffsetDateTime value) {
        if (this.passwordLastModified == value) {
            return this;
        }
        return new ImmutableUaaUser(this.id, this.schemas, this.meta, this.name, this.emails, this.externalId, this.userName, this.groups, this.approvals, this.active, this.verified, this.origin, this.zoneId, value, this.previousLogonTime, this.lastLogonTime);
    }

    public final ImmutableUaaUser withPreviousLogonTime(Long value) {
        if (Objects.equals(this.previousLogonTime, value)) {
            return this;
        }
        return new ImmutableUaaUser(this.id, this.schemas, this.meta, this.name, this.emails, this.externalId, this.userName, this.groups, this.approvals, this.active, this.verified, this.origin, this.zoneId, this.passwordLastModified, value, this.lastLogonTime);
    }

    public final ImmutableUaaUser withLastLogonTime(Long value) {
        if (Objects.equals(this.lastLogonTime, value)) {
            return this;
        }
        return new ImmutableUaaUser(this.id, this.schemas, this.meta, this.name, this.emails, this.externalId, this.userName, this.groups, this.approvals, this.active, this.verified, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUaaUser && this.equalTo((ImmutableUaaUser)another);
    }

    private boolean equalTo(ImmutableUaaUser another) {
        return this.id.equals(another.id) && this.schemas.equals(another.schemas) && Objects.equals(this.meta, another.meta) && Objects.equals(this.name, another.name) && this.emails.equals(another.emails) && Objects.equals(this.externalId, another.externalId) && Objects.equals(this.userName, another.userName) && this.groups.equals(another.groups) && this.approvals.equals(another.approvals) && Objects.equals(this.active, another.active) && Objects.equals(this.verified, another.verified) && Objects.equals(this.origin, another.origin) && Objects.equals(this.zoneId, another.zoneId) && Objects.equals(this.passwordLastModified, another.passwordLastModified) && Objects.equals(this.previousLogonTime, another.previousLogonTime) && Objects.equals(this.lastLogonTime, another.lastLogonTime);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.schemas.hashCode();
        h += (h << 5) + Objects.hashCode(this.meta);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + this.emails.hashCode();
        h += (h << 5) + Objects.hashCode(this.externalId);
        h += (h << 5) + Objects.hashCode(this.userName);
        h += (h << 5) + this.groups.hashCode();
        h += (h << 5) + this.approvals.hashCode();
        h += (h << 5) + Objects.hashCode(this.active);
        h += (h << 5) + Objects.hashCode(this.verified);
        h += (h << 5) + Objects.hashCode(this.origin);
        h += (h << 5) + Objects.hashCode(this.zoneId);
        h += (h << 5) + Objects.hashCode(this.passwordLastModified);
        h += (h << 5) + Objects.hashCode(this.previousLogonTime);
        h += (h << 5) + Objects.hashCode(this.lastLogonTime);
        return h;
    }

    public String toString() {
        return "UaaUser{id=" + this.id + ", schemas=" + this.schemas + ", meta=" + this.meta + ", name=" + this.name + ", emails=" + this.emails + ", externalId=" + this.externalId + ", userName=" + this.userName + ", groups=" + this.groups + ", approvals=" + this.approvals + ", active=" + this.active + ", verified=" + this.verified + ", origin=" + this.origin + ", zoneId=" + this.zoneId + ", passwordLastModified=" + this.passwordLastModified + ", previousLogonTime=" + this.previousLogonTime + ", lastLogonTime=" + this.lastLogonTime + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableUaaUser fromJson(Json json) {
        Builder builder = ImmutableUaaUser.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.schemas != null) {
            builder.addAllSchemas(json.schemas);
        }
        if (json.meta != null) {
            builder.meta(json.meta);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.emails != null) {
            builder.addAllEmails(json.emails);
        }
        if (json.externalId != null) {
            builder.externalId(json.externalId);
        }
        if (json.userName != null) {
            builder.userName(json.userName);
        }
        if (json.groups != null) {
            builder.addAllGroups(json.groups);
        }
        if (json.approvals != null) {
            builder.addAllApprovals(json.approvals);
        }
        if (json.active != null) {
            builder.active(json.active);
        }
        if (json.verified != null) {
            builder.verified(json.verified);
        }
        if (json.origin != null) {
            builder.origin(json.origin);
        }
        if (json.zoneId != null) {
            builder.zoneId(json.zoneId);
        }
        if (json.passwordLastModified != null) {
            builder.passwordLastModified(json.passwordLastModified);
        }
        if (json.previousLogonTime != null) {
            builder.previousLogonTime(json.previousLogonTime);
        }
        if (json.lastLogonTime != null) {
            builder.lastLogonTime(json.lastLogonTime);
        }
        return builder.build();
    }

    public static ImmutableUaaUser copyOf(UaaUser instance) {
        if (instance instanceof ImmutableUaaUser) {
            return (ImmutableUaaUser)instance;
        }
        return ImmutableUaaUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Generated(from="UaaUser.Email", generator="Immutables")
    @Immutable
    public static final class Email
    implements UaaUser.Email {
        private final String value;
        private final Boolean primary;

        private Email(String value, Boolean primary) {
            this.value = value;
            this.primary = primary;
        }

        @Override
        @JsonProperty(value="value")
        public String getValue() {
            return this.value;
        }

        @Override
        @JsonProperty(value="primary")
        public Boolean getPrimary() {
            return this.primary;
        }

        public final Email withValue(String value) {
            if (Objects.equals(this.value, value)) {
                return this;
            }
            return new Email(value, this.primary);
        }

        public final Email withPrimary(Boolean value) {
            if (Objects.equals(this.primary, value)) {
                return this;
            }
            return new Email(this.value, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Email && this.equalTo((Email)another);
        }

        private boolean equalTo(Email another) {
            return Objects.equals(this.value, another.value) && Objects.equals(this.primary, another.primary);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.value);
            h += (h << 5) + Objects.hashCode(this.primary);
            return h;
        }

        public String toString() {
            return "Email{value=" + this.value + ", primary=" + this.primary + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static Email fromJson(Json json) {
            Builder builder = Email.builder();
            if (json.value != null) {
                builder.value(json.value);
            }
            if (json.primary != null) {
                builder.primary(json.primary);
            }
            return builder.build();
        }

        public static Email copyOf(UaaUser.Email instance) {
            if (instance instanceof Email) {
                return (Email)instance;
            }
            return Email.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="UaaUser.Email", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            @Nullable
            private String value;
            @Nullable
            private Boolean primary;

            private Builder() {
            }

            public final Builder from(UaaUser.Email instance) {
                Boolean primaryValue;
                Objects.requireNonNull(instance, "instance");
                String valueValue = instance.getValue();
                if (valueValue != null) {
                    this.value(valueValue);
                }
                if ((primaryValue = instance.getPrimary()) != null) {
                    this.primary(primaryValue);
                }
                return this;
            }

            @JsonProperty(value="value")
            public final Builder value(String value) {
                this.value = value;
                return this;
            }

            @JsonProperty(value="primary")
            public final Builder primary(Boolean primary) {
                this.primary = primary;
                return this;
            }

            public Email build() {
                return new Email(this.value, this.primary);
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="UaaUser.Email", generator="Immutables")
        static final class Json
        implements UaaUser.Email {
            @Nullable
            String value;
            @Nullable
            Boolean primary;

            Json() {
            }

            @JsonProperty(value="value")
            public void setValue(String value) {
                this.value = value;
            }

            @JsonProperty(value="primary")
            public void setPrimary(Boolean primary) {
                this.primary = primary;
            }

            @Override
            public String getValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Boolean getPrimary() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Generated(from="UaaUser.Name", generator="Immutables")
    @Immutable
    public static final class Name
    implements UaaUser.Name {
        private final String familyName;
        private final String givenName;

        private Name(String familyName, String givenName) {
            this.familyName = familyName;
            this.givenName = givenName;
        }

        @Override
        @JsonProperty(value="familyName")
        public String getFamilyName() {
            return this.familyName;
        }

        @Override
        @JsonProperty(value="givenName")
        public String getGivenName() {
            return this.givenName;
        }

        public final Name withFamilyName(String value) {
            if (Objects.equals(this.familyName, value)) {
                return this;
            }
            return new Name(value, this.givenName);
        }

        public final Name withGivenName(String value) {
            if (Objects.equals(this.givenName, value)) {
                return this;
            }
            return new Name(this.familyName, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Name && this.equalTo((Name)another);
        }

        private boolean equalTo(Name another) {
            return Objects.equals(this.familyName, another.familyName) && Objects.equals(this.givenName, another.givenName);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.familyName);
            h += (h << 5) + Objects.hashCode(this.givenName);
            return h;
        }

        public String toString() {
            return "Name{familyName=" + this.familyName + ", givenName=" + this.givenName + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static Name fromJson(Json json) {
            Builder builder = Name.builder();
            if (json.familyName != null) {
                builder.familyName(json.familyName);
            }
            if (json.givenName != null) {
                builder.givenName(json.givenName);
            }
            return builder.build();
        }

        public static Name copyOf(UaaUser.Name instance) {
            if (instance instanceof Name) {
                return (Name)instance;
            }
            return Name.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="UaaUser.Name", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            @Nullable
            private String familyName;
            @Nullable
            private String givenName;

            private Builder() {
            }

            public final Builder from(UaaUser.Name instance) {
                String givenNameValue;
                Objects.requireNonNull(instance, "instance");
                String familyNameValue = instance.getFamilyName();
                if (familyNameValue != null) {
                    this.familyName(familyNameValue);
                }
                if ((givenNameValue = instance.getGivenName()) != null) {
                    this.givenName(givenNameValue);
                }
                return this;
            }

            @JsonProperty(value="familyName")
            public final Builder familyName(String familyName) {
                this.familyName = familyName;
                return this;
            }

            @JsonProperty(value="givenName")
            public final Builder givenName(String givenName) {
                this.givenName = givenName;
                return this;
            }

            public Name build() {
                return new Name(this.familyName, this.givenName);
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="UaaUser.Name", generator="Immutables")
        static final class Json
        implements UaaUser.Name {
            @Nullable
            String familyName;
            @Nullable
            String givenName;

            Json() {
            }

            @JsonProperty(value="familyName")
            public void setFamilyName(String familyName) {
                this.familyName = familyName;
            }

            @JsonProperty(value="givenName")
            public void setGivenName(String givenName) {
                this.givenName = givenName;
            }

            @Override
            public String getFamilyName() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getGivenName() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Generated(from="UaaUser.Approval", generator="Immutables")
    @Immutable
    public static final class Approval
    implements UaaUser.Approval {
        private final String userId;
        private final String clientId;
        private final String scope;
        private final String status;
        private final OffsetDateTime lastUpdatedAt;
        private final OffsetDateTime expiresAt;

        private Approval(String userId, String clientId, String scope, String status, OffsetDateTime lastUpdatedAt, OffsetDateTime expiresAt) {
            this.userId = userId;
            this.clientId = clientId;
            this.scope = scope;
            this.status = status;
            this.lastUpdatedAt = lastUpdatedAt;
            this.expiresAt = expiresAt;
        }

        @Override
        @JsonProperty(value="userId")
        public String getUserId() {
            return this.userId;
        }

        @Override
        @JsonProperty(value="clientId")
        public String getClientId() {
            return this.clientId;
        }

        @Override
        @JsonProperty(value="scope")
        public String getScope() {
            return this.scope;
        }

        @Override
        @JsonProperty(value="status")
        public String getStatus() {
            return this.status;
        }

        @Override
        @JsonProperty(value="lastUpdatedAt")
        public OffsetDateTime getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        @JsonProperty(value="expiresAt")
        public OffsetDateTime getExpiresAt() {
            return this.expiresAt;
        }

        public final Approval withUserId(String value) {
            if (Objects.equals(this.userId, value)) {
                return this;
            }
            return new Approval(value, this.clientId, this.scope, this.status, this.lastUpdatedAt, this.expiresAt);
        }

        public final Approval withClientId(String value) {
            if (Objects.equals(this.clientId, value)) {
                return this;
            }
            return new Approval(this.userId, value, this.scope, this.status, this.lastUpdatedAt, this.expiresAt);
        }

        public final Approval withScope(String value) {
            if (Objects.equals(this.scope, value)) {
                return this;
            }
            return new Approval(this.userId, this.clientId, value, this.status, this.lastUpdatedAt, this.expiresAt);
        }

        public final Approval withStatus(String value) {
            if (Objects.equals(this.status, value)) {
                return this;
            }
            return new Approval(this.userId, this.clientId, this.scope, value, this.lastUpdatedAt, this.expiresAt);
        }

        public final Approval withLastUpdatedAt(OffsetDateTime value) {
            if (this.lastUpdatedAt == value) {
                return this;
            }
            return new Approval(this.userId, this.clientId, this.scope, this.status, value, this.expiresAt);
        }

        public final Approval withExpiresAt(OffsetDateTime value) {
            if (this.expiresAt == value) {
                return this;
            }
            return new Approval(this.userId, this.clientId, this.scope, this.status, this.lastUpdatedAt, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Approval && this.equalTo((Approval)another);
        }

        private boolean equalTo(Approval another) {
            return Objects.equals(this.userId, another.userId) && Objects.equals(this.clientId, another.clientId) && Objects.equals(this.scope, another.scope) && Objects.equals(this.status, another.status) && Objects.equals(this.lastUpdatedAt, another.lastUpdatedAt) && Objects.equals(this.expiresAt, another.expiresAt);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.userId);
            h += (h << 5) + Objects.hashCode(this.clientId);
            h += (h << 5) + Objects.hashCode(this.scope);
            h += (h << 5) + Objects.hashCode(this.status);
            h += (h << 5) + Objects.hashCode(this.lastUpdatedAt);
            h += (h << 5) + Objects.hashCode(this.expiresAt);
            return h;
        }

        public String toString() {
            return "Approval{userId=" + this.userId + ", clientId=" + this.clientId + ", scope=" + this.scope + ", status=" + this.status + ", lastUpdatedAt=" + this.lastUpdatedAt + ", expiresAt=" + this.expiresAt + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static Approval fromJson(Json json) {
            Builder builder = Approval.builder();
            if (json.userId != null) {
                builder.userId(json.userId);
            }
            if (json.clientId != null) {
                builder.clientId(json.clientId);
            }
            if (json.scope != null) {
                builder.scope(json.scope);
            }
            if (json.status != null) {
                builder.status(json.status);
            }
            if (json.lastUpdatedAt != null) {
                builder.lastUpdatedAt(json.lastUpdatedAt);
            }
            if (json.expiresAt != null) {
                builder.expiresAt(json.expiresAt);
            }
            return builder.build();
        }

        public static Approval copyOf(UaaUser.Approval instance) {
            if (instance instanceof Approval) {
                return (Approval)instance;
            }
            return Approval.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="UaaUser.Approval", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            @Nullable
            private String userId;
            @Nullable
            private String clientId;
            @Nullable
            private String scope;
            @Nullable
            private String status;
            @Nullable
            private OffsetDateTime lastUpdatedAt;
            @Nullable
            private OffsetDateTime expiresAt;

            private Builder() {
            }

            public final Builder from(UaaUser.Approval instance) {
                OffsetDateTime expiresAtValue;
                OffsetDateTime lastUpdatedAtValue;
                String statusValue;
                String scopeValue;
                String clientIdValue;
                Objects.requireNonNull(instance, "instance");
                String userIdValue = instance.getUserId();
                if (userIdValue != null) {
                    this.userId(userIdValue);
                }
                if ((clientIdValue = instance.getClientId()) != null) {
                    this.clientId(clientIdValue);
                }
                if ((scopeValue = instance.getScope()) != null) {
                    this.scope(scopeValue);
                }
                if ((statusValue = instance.getStatus()) != null) {
                    this.status(statusValue);
                }
                if ((lastUpdatedAtValue = instance.getLastUpdatedAt()) != null) {
                    this.lastUpdatedAt(lastUpdatedAtValue);
                }
                if ((expiresAtValue = instance.getExpiresAt()) != null) {
                    this.expiresAt(expiresAtValue);
                }
                return this;
            }

            @JsonProperty(value="userId")
            public final Builder userId(String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="clientId")
            public final Builder clientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            @JsonProperty(value="scope")
            public final Builder scope(String scope) {
                this.scope = scope;
                return this;
            }

            @JsonProperty(value="status")
            public final Builder status(String status) {
                this.status = status;
                return this;
            }

            @JsonProperty(value="lastUpdatedAt")
            public final Builder lastUpdatedAt(OffsetDateTime lastUpdatedAt) {
                this.lastUpdatedAt = lastUpdatedAt;
                return this;
            }

            @JsonProperty(value="expiresAt")
            public final Builder expiresAt(OffsetDateTime expiresAt) {
                this.expiresAt = expiresAt;
                return this;
            }

            public Approval build() {
                return new Approval(this.userId, this.clientId, this.scope, this.status, this.lastUpdatedAt, this.expiresAt);
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="UaaUser.Approval", generator="Immutables")
        static final class Json
        implements UaaUser.Approval {
            @Nullable
            String userId;
            @Nullable
            String clientId;
            @Nullable
            String scope;
            @Nullable
            String status;
            @Nullable
            OffsetDateTime lastUpdatedAt;
            @Nullable
            OffsetDateTime expiresAt;

            Json() {
            }

            @JsonProperty(value="userId")
            public void setUserId(String userId) {
                this.userId = userId;
            }

            @JsonProperty(value="clientId")
            public void setClientId(String clientId) {
                this.clientId = clientId;
            }

            @JsonProperty(value="scope")
            public void setScope(String scope) {
                this.scope = scope;
            }

            @JsonProperty(value="status")
            public void setStatus(String status) {
                this.status = status;
            }

            @JsonProperty(value="lastUpdatedAt")
            public void setLastUpdatedAt(OffsetDateTime lastUpdatedAt) {
                this.lastUpdatedAt = lastUpdatedAt;
            }

            @JsonProperty(value="expiresAt")
            public void setExpiresAt(OffsetDateTime expiresAt) {
                this.expiresAt = expiresAt;
            }

            @Override
            public String getUserId() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getClientId() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getScope() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getStatus() {
                throw new UnsupportedOperationException();
            }

            @Override
            public OffsetDateTime getLastUpdatedAt() {
                throw new UnsupportedOperationException();
            }

            @Override
            public OffsetDateTime getExpiresAt() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Generated(from="UaaUser.Group", generator="Immutables")
    @Immutable
    public static final class Group
    implements UaaUser.Group {
        private final String value;
        private final String display;
        private final String type;

        private Group(String value, String display, String type) {
            this.value = value;
            this.display = display;
            this.type = type;
        }

        @Override
        @JsonProperty(value="value")
        public String getValue() {
            return this.value;
        }

        @Override
        @JsonProperty(value="display")
        public String getDisplay() {
            return this.display;
        }

        @Override
        @JsonProperty(value="type")
        public String getType() {
            return this.type;
        }

        public final Group withValue(String value) {
            if (Objects.equals(this.value, value)) {
                return this;
            }
            return new Group(value, this.display, this.type);
        }

        public final Group withDisplay(String value) {
            if (Objects.equals(this.display, value)) {
                return this;
            }
            return new Group(this.value, value, this.type);
        }

        public final Group withType(String value) {
            if (Objects.equals(this.type, value)) {
                return this;
            }
            return new Group(this.value, this.display, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Group && this.equalTo((Group)another);
        }

        private boolean equalTo(Group another) {
            return Objects.equals(this.value, another.value) && Objects.equals(this.display, another.display) && Objects.equals(this.type, another.type);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.value);
            h += (h << 5) + Objects.hashCode(this.display);
            h += (h << 5) + Objects.hashCode(this.type);
            return h;
        }

        public String toString() {
            return "Group{value=" + this.value + ", display=" + this.display + ", type=" + this.type + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static Group fromJson(Json json) {
            Builder builder = Group.builder();
            if (json.value != null) {
                builder.value(json.value);
            }
            if (json.display != null) {
                builder.display(json.display);
            }
            if (json.type != null) {
                builder.type(json.type);
            }
            return builder.build();
        }

        public static Group copyOf(UaaUser.Group instance) {
            if (instance instanceof Group) {
                return (Group)instance;
            }
            return Group.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="UaaUser.Group", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            @Nullable
            private String value;
            @Nullable
            private String display;
            @Nullable
            private String type;

            private Builder() {
            }

            public final Builder from(UaaUser.Group instance) {
                String typeValue;
                String displayValue;
                Objects.requireNonNull(instance, "instance");
                String valueValue = instance.getValue();
                if (valueValue != null) {
                    this.value(valueValue);
                }
                if ((displayValue = instance.getDisplay()) != null) {
                    this.display(displayValue);
                }
                if ((typeValue = instance.getType()) != null) {
                    this.type(typeValue);
                }
                return this;
            }

            @JsonProperty(value="value")
            public final Builder value(String value) {
                this.value = value;
                return this;
            }

            @JsonProperty(value="display")
            public final Builder display(String display) {
                this.display = display;
                return this;
            }

            @JsonProperty(value="type")
            public final Builder type(String type) {
                this.type = type;
                return this;
            }

            public Group build() {
                return new Group(this.value, this.display, this.type);
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="UaaUser.Group", generator="Immutables")
        static final class Json
        implements UaaUser.Group {
            @Nullable
            String value;
            @Nullable
            String display;
            @Nullable
            String type;

            Json() {
            }

            @JsonProperty(value="value")
            public void setValue(String value) {
                this.value = value;
            }

            @JsonProperty(value="display")
            public void setDisplay(String display) {
                this.display = display;
            }

            @JsonProperty(value="type")
            public void setType(String type) {
                this.type = type;
            }

            @Override
            public String getValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getDisplay() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getType() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Generated(from="UaaUser", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        private List<String> schemas = new ArrayList<String>();
        @Nullable
        private UaaMeta meta;
        @Nullable
        private UaaUser.Name name;
        private List<UaaUser.Email> emails = new ArrayList<UaaUser.Email>();
        @Nullable
        private String externalId;
        @Nullable
        private String userName;
        private List<UaaUser.Group> groups = new ArrayList<UaaUser.Group>();
        private List<UaaUser.Approval> approvals = new ArrayList<UaaUser.Approval>();
        @Nullable
        private Boolean active;
        @Nullable
        private Boolean verified;
        @Nullable
        private String origin;
        @Nullable
        private String zoneId;
        @Nullable
        private OffsetDateTime passwordLastModified;
        @Nullable
        private Long previousLogonTime;
        @Nullable
        private Long lastLogonTime;

        private Builder() {
        }

        public final Builder from(UaaUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UaaEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UaaEntity instance;
            if (object instanceof UaaUser) {
                OffsetDateTime passwordLastModifiedValue;
                String zoneIdValue;
                UaaUser.Name nameValue;
                UaaMeta metaValue;
                String userNameValue;
                String externalIdValue;
                Boolean verifiedValue;
                instance = (UaaUser)object;
                String originValue = instance.getOrigin();
                if (originValue != null) {
                    this.origin(originValue);
                }
                if ((verifiedValue = instance.getVerified()) != null) {
                    this.verified(verifiedValue);
                }
                if ((externalIdValue = instance.getExternalId()) != null) {
                    this.externalId(externalIdValue);
                }
                this.addAllGroups(instance.getGroups());
                Boolean activeValue = instance.getActive();
                if (activeValue != null) {
                    this.active(activeValue);
                }
                if ((userNameValue = instance.getUserName()) != null) {
                    this.userName(userNameValue);
                }
                this.addAllEmails(instance.getEmails());
                Long lastLogonTimeValue = instance.getLastLogonTime();
                if (lastLogonTimeValue != null) {
                    this.lastLogonTime(lastLogonTimeValue);
                }
                if ((metaValue = instance.getMeta()) != null) {
                    this.meta(metaValue);
                }
                this.addAllApprovals(instance.getApprovals());
                Long previousLogonTimeValue = instance.getPreviousLogonTime();
                if (previousLogonTimeValue != null) {
                    this.previousLogonTime(previousLogonTimeValue);
                }
                if ((nameValue = instance.getName()) != null) {
                    this.name(nameValue);
                }
                if ((zoneIdValue = instance.getZoneId()) != null) {
                    this.zoneId(zoneIdValue);
                }
                if ((passwordLastModifiedValue = instance.getPasswordLastModified()) != null) {
                    this.passwordLastModified(passwordLastModifiedValue);
                }
            }
            if (object instanceof UaaEntity) {
                instance = (UaaEntity)object;
                this.addAllSchemas(instance.getSchemas());
                this.id(instance.getId());
            }
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addSchemas(String element) {
            this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            return this;
        }

        public final Builder addSchemas(String ... elements) {
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            return this;
        }

        @JsonProperty(value="schemas")
        public final Builder schemas(Iterable<String> elements) {
            this.schemas.clear();
            return this.addAllSchemas(elements);
        }

        public final Builder addAllSchemas(Iterable<String> elements) {
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            return this;
        }

        @JsonProperty(value="meta")
        public final Builder meta(UaaMeta meta) {
            this.meta = meta;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(UaaUser.Name name) {
            this.name = name;
            return this;
        }

        public final Builder addEmails(UaaUser.Email element) {
            this.emails.add(Objects.requireNonNull(element, "emails element"));
            return this;
        }

        public final Builder addEmails(UaaUser.Email ... elements) {
            for (UaaUser.Email element : elements) {
                this.emails.add(Objects.requireNonNull(element, "emails element"));
            }
            return this;
        }

        @JsonProperty(value="emails")
        public final Builder emails(Iterable<? extends UaaUser.Email> elements) {
            this.emails.clear();
            return this.addAllEmails(elements);
        }

        public final Builder addAllEmails(Iterable<? extends UaaUser.Email> elements) {
            for (UaaUser.Email email : elements) {
                this.emails.add(Objects.requireNonNull(email, "emails element"));
            }
            return this;
        }

        @JsonProperty(value="externalId")
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        @JsonProperty(value="userName")
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final Builder addGroups(UaaUser.Group element) {
            this.groups.add(Objects.requireNonNull(element, "groups element"));
            return this;
        }

        public final Builder addGroups(UaaUser.Group ... elements) {
            for (UaaUser.Group element : elements) {
                this.groups.add(Objects.requireNonNull(element, "groups element"));
            }
            return this;
        }

        @JsonProperty(value="groups")
        public final Builder groups(Iterable<? extends UaaUser.Group> elements) {
            this.groups.clear();
            return this.addAllGroups(elements);
        }

        public final Builder addAllGroups(Iterable<? extends UaaUser.Group> elements) {
            for (UaaUser.Group group : elements) {
                this.groups.add(Objects.requireNonNull(group, "groups element"));
            }
            return this;
        }

        public final Builder addApprovals(UaaUser.Approval element) {
            this.approvals.add(Objects.requireNonNull(element, "approvals element"));
            return this;
        }

        public final Builder addApprovals(UaaUser.Approval ... elements) {
            for (UaaUser.Approval element : elements) {
                this.approvals.add(Objects.requireNonNull(element, "approvals element"));
            }
            return this;
        }

        @JsonProperty(value="approvals")
        public final Builder approvals(Iterable<? extends UaaUser.Approval> elements) {
            this.approvals.clear();
            return this.addAllApprovals(elements);
        }

        public final Builder addAllApprovals(Iterable<? extends UaaUser.Approval> elements) {
            for (UaaUser.Approval approval : elements) {
                this.approvals.add(Objects.requireNonNull(approval, "approvals element"));
            }
            return this;
        }

        @JsonProperty(value="active")
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        @JsonProperty(value="verified")
        public final Builder verified(Boolean verified) {
            this.verified = verified;
            return this;
        }

        @JsonProperty(value="origin")
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @JsonProperty(value="zoneId")
        public final Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        @JsonProperty(value="passwordLastModified")
        public final Builder passwordLastModified(OffsetDateTime passwordLastModified) {
            this.passwordLastModified = passwordLastModified;
            return this;
        }

        @JsonProperty(value="previousLogonTime")
        public final Builder previousLogonTime(Long previousLogonTime) {
            this.previousLogonTime = previousLogonTime;
            return this;
        }

        @JsonProperty(value="lastLogonTime")
        public final Builder lastLogonTime(Long lastLogonTime) {
            this.lastLogonTime = lastLogonTime;
            return this;
        }

        public ImmutableUaaUser build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUaaUser(this.id, ImmutableUaaUser.createUnmodifiableList(true, this.schemas), this.meta, this.name, ImmutableUaaUser.createUnmodifiableList(true, this.emails), this.externalId, this.userName, ImmutableUaaUser.createUnmodifiableList(true, this.groups), ImmutableUaaUser.createUnmodifiableList(true, this.approvals), this.active, this.verified, this.origin, this.zoneId, this.passwordLastModified, this.previousLogonTime, this.lastLogonTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build UaaUser, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UaaUser", generator="Immutables")
    static final class Json
    implements UaaUser {
        @Nullable
        String id;
        @Nullable
        List<String> schemas = Collections.emptyList();
        @Nullable
        UaaMeta meta;
        @Nullable
        UaaUser.Name name;
        @Nullable
        List<UaaUser.Email> emails = Collections.emptyList();
        @Nullable
        String externalId;
        @Nullable
        String userName;
        @Nullable
        List<UaaUser.Group> groups = Collections.emptyList();
        @Nullable
        List<UaaUser.Approval> approvals = Collections.emptyList();
        @Nullable
        Boolean active;
        @Nullable
        Boolean verified;
        @Nullable
        String origin;
        @Nullable
        String zoneId;
        @Nullable
        OffsetDateTime passwordLastModified;
        @Nullable
        Long previousLogonTime;
        @Nullable
        Long lastLogonTime;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="schemas")
        public void setSchemas(List<String> schemas) {
            this.schemas = schemas;
        }

        @JsonProperty(value="meta")
        public void setMeta(UaaMeta meta) {
            this.meta = meta;
        }

        @JsonProperty(value="name")
        public void setName(UaaUser.Name name) {
            this.name = name;
        }

        @JsonProperty(value="emails")
        public void setEmails(List<UaaUser.Email> emails) {
            this.emails = emails;
        }

        @JsonProperty(value="externalId")
        public void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @JsonProperty(value="userName")
        public void setUserName(String userName) {
            this.userName = userName;
        }

        @JsonProperty(value="groups")
        public void setGroups(List<UaaUser.Group> groups) {
            this.groups = groups;
        }

        @JsonProperty(value="approvals")
        public void setApprovals(List<UaaUser.Approval> approvals) {
            this.approvals = approvals;
        }

        @JsonProperty(value="active")
        public void setActive(Boolean active) {
            this.active = active;
        }

        @JsonProperty(value="verified")
        public void setVerified(Boolean verified) {
            this.verified = verified;
        }

        @JsonProperty(value="origin")
        public void setOrigin(String origin) {
            this.origin = origin;
        }

        @JsonProperty(value="zoneId")
        public void setZoneId(String zoneId) {
            this.zoneId = zoneId;
        }

        @JsonProperty(value="passwordLastModified")
        public void setPasswordLastModified(OffsetDateTime passwordLastModified) {
            this.passwordLastModified = passwordLastModified;
        }

        @JsonProperty(value="previousLogonTime")
        public void setPreviousLogonTime(Long previousLogonTime) {
            this.previousLogonTime = previousLogonTime;
        }

        @JsonProperty(value="lastLogonTime")
        public void setLastLogonTime(Long lastLogonTime) {
            this.lastLogonTime = lastLogonTime;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSchemas() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UaaMeta getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UaaUser.Name getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<UaaUser.Email> getEmails() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExternalId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<UaaUser.Group> getGroups() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<UaaUser.Approval> getApprovals() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getActive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getVerified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getOrigin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getZoneId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OffsetDateTime getPasswordLastModified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getPreviousLogonTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getLastLogonTime() {
            throw new UnsupportedOperationException();
        }
    }
}

