/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security.uaa.spi.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.security.uaa.spi.model.UaaEntity;
import io.dialob.security.uaa.spi.model.UaaGroup;
import io.dialob.security.uaa.spi.model.UaaMeta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="UaaGroup", generator="Immutables")
@Immutable
public final class ImmutableUaaGroup
implements UaaGroup {
    private final String id;
    private final List<String> schemas;
    private final String displayName;
    private final String description;
    private final List<UaaGroup.Member> members;
    private final String zoneId;
    private final UaaMeta meta;

    private ImmutableUaaGroup(String id, List<String> schemas, String displayName, String description, List<UaaGroup.Member> members, String zoneId, UaaMeta meta) {
        this.id = id;
        this.schemas = schemas;
        this.displayName = displayName;
        this.description = description;
        this.members = members;
        this.zoneId = zoneId;
        this.meta = meta;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="members")
    public List<UaaGroup.Member> getMembers() {
        return this.members;
    }

    @Override
    @JsonProperty(value="zoneId")
    public String getZoneId() {
        return this.zoneId;
    }

    @Override
    @JsonProperty(value="meta")
    public UaaMeta getMeta() {
        return this.meta;
    }

    public final ImmutableUaaGroup withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableUaaGroup(newValue, this.schemas, this.displayName, this.description, this.members, this.zoneId, this.meta);
    }

    public final ImmutableUaaGroup withSchemas(String ... elements) {
        List<String> newValue = ImmutableUaaGroup.createUnmodifiableList(false, ImmutableUaaGroup.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUaaGroup(this.id, newValue, this.displayName, this.description, this.members, this.zoneId, this.meta);
    }

    public final ImmutableUaaGroup withSchemas(Iterable<String> elements) {
        if (this.schemas == elements) {
            return this;
        }
        List<String> newValue = ImmutableUaaGroup.createUnmodifiableList(false, ImmutableUaaGroup.createSafeList(elements, true, false));
        return new ImmutableUaaGroup(this.id, newValue, this.displayName, this.description, this.members, this.zoneId, this.meta);
    }

    public final ImmutableUaaGroup withDisplayName(String value) {
        String newValue = Objects.requireNonNull(value, "displayName");
        if (this.displayName.equals(newValue)) {
            return this;
        }
        return new ImmutableUaaGroup(this.id, this.schemas, newValue, this.description, this.members, this.zoneId, this.meta);
    }

    public final ImmutableUaaGroup withDescription(String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableUaaGroup(this.id, this.schemas, this.displayName, value, this.members, this.zoneId, this.meta);
    }

    public final ImmutableUaaGroup withMembers(UaaGroup.Member ... elements) {
        List<UaaGroup.Member> newValue = ImmutableUaaGroup.createUnmodifiableList(false, ImmutableUaaGroup.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUaaGroup(this.id, this.schemas, this.displayName, this.description, newValue, this.zoneId, this.meta);
    }

    public final ImmutableUaaGroup withMembers(Iterable<? extends UaaGroup.Member> elements) {
        if (this.members == elements) {
            return this;
        }
        List<UaaGroup.Member> newValue = ImmutableUaaGroup.createUnmodifiableList(false, ImmutableUaaGroup.createSafeList(elements, true, false));
        return new ImmutableUaaGroup(this.id, this.schemas, this.displayName, this.description, newValue, this.zoneId, this.meta);
    }

    public final ImmutableUaaGroup withZoneId(String value) {
        if (Objects.equals(this.zoneId, value)) {
            return this;
        }
        return new ImmutableUaaGroup(this.id, this.schemas, this.displayName, this.description, this.members, value, this.meta);
    }

    public final ImmutableUaaGroup withMeta(UaaMeta value) {
        if (this.meta == value) {
            return this;
        }
        return new ImmutableUaaGroup(this.id, this.schemas, this.displayName, this.description, this.members, this.zoneId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUaaGroup && this.equalTo((ImmutableUaaGroup)another);
    }

    private boolean equalTo(ImmutableUaaGroup another) {
        return this.id.equals(another.id) && this.schemas.equals(another.schemas) && this.displayName.equals(another.displayName) && Objects.equals(this.description, another.description) && this.members.equals(another.members) && Objects.equals(this.zoneId, another.zoneId) && Objects.equals(this.meta, another.meta);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.schemas.hashCode();
        h += (h << 5) + this.displayName.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.members.hashCode();
        h += (h << 5) + Objects.hashCode(this.zoneId);
        h += (h << 5) + Objects.hashCode(this.meta);
        return h;
    }

    public String toString() {
        return "UaaGroup{id=" + this.id + ", schemas=" + this.schemas + ", displayName=" + this.displayName + ", description=" + this.description + ", members=" + this.members + ", zoneId=" + this.zoneId + ", meta=" + this.meta + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableUaaGroup fromJson(Json json) {
        Builder builder = ImmutableUaaGroup.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.schemas != null) {
            builder.addAllSchemas(json.schemas);
        }
        if (json.displayName != null) {
            builder.displayName(json.displayName);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.members != null) {
            builder.addAllMembers(json.members);
        }
        if (json.zoneId != null) {
            builder.zoneId(json.zoneId);
        }
        if (json.meta != null) {
            builder.meta(json.meta);
        }
        return builder.build();
    }

    public static ImmutableUaaGroup copyOf(UaaGroup instance) {
        if (instance instanceof ImmutableUaaGroup) {
            return (ImmutableUaaGroup)instance;
        }
        return ImmutableUaaGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Generated(from="UaaGroup.Member", generator="Immutables")
    @Immutable
    public static final class Member
    implements UaaGroup.Member {
        private final String value;
        private final String type;
        private final String origin;

        private Member(String value, String type, String origin) {
            this.value = value;
            this.type = type;
            this.origin = origin;
        }

        @Override
        @JsonProperty(value="value")
        public String getValue() {
            return this.value;
        }

        @Override
        @JsonProperty(value="type")
        public String getType() {
            return this.type;
        }

        @Override
        @JsonProperty(value="origin")
        public String getOrigin() {
            return this.origin;
        }

        public final Member withValue(String value) {
            if (Objects.equals(this.value, value)) {
                return this;
            }
            return new Member(value, this.type, this.origin);
        }

        public final Member withType(String value) {
            if (Objects.equals(this.type, value)) {
                return this;
            }
            return new Member(this.value, value, this.origin);
        }

        public final Member withOrigin(String value) {
            if (Objects.equals(this.origin, value)) {
                return this;
            }
            return new Member(this.value, this.type, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Member && this.equalTo((Member)another);
        }

        private boolean equalTo(Member another) {
            return Objects.equals(this.value, another.value) && Objects.equals(this.type, another.type) && Objects.equals(this.origin, another.origin);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.value);
            h += (h << 5) + Objects.hashCode(this.type);
            h += (h << 5) + Objects.hashCode(this.origin);
            return h;
        }

        public String toString() {
            return "Member{value=" + this.value + ", type=" + this.type + ", origin=" + this.origin + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static Member fromJson(Json json) {
            Builder builder = Member.builder();
            if (json.value != null) {
                builder.value(json.value);
            }
            if (json.type != null) {
                builder.type(json.type);
            }
            if (json.origin != null) {
                builder.origin(json.origin);
            }
            return builder.build();
        }

        public static Member copyOf(UaaGroup.Member instance) {
            if (instance instanceof Member) {
                return (Member)instance;
            }
            return Member.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="UaaGroup.Member", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            @Nullable
            private String value;
            @Nullable
            private String type;
            @Nullable
            private String origin;

            private Builder() {
            }

            public final Builder from(UaaGroup.Member instance) {
                String originValue;
                String typeValue;
                Objects.requireNonNull(instance, "instance");
                String valueValue = instance.getValue();
                if (valueValue != null) {
                    this.value(valueValue);
                }
                if ((typeValue = instance.getType()) != null) {
                    this.type(typeValue);
                }
                if ((originValue = instance.getOrigin()) != null) {
                    this.origin(originValue);
                }
                return this;
            }

            @JsonProperty(value="value")
            public final Builder value(String value) {
                this.value = value;
                return this;
            }

            @JsonProperty(value="type")
            public final Builder type(String type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="origin")
            public final Builder origin(String origin) {
                this.origin = origin;
                return this;
            }

            public Member build() {
                return new Member(this.value, this.type, this.origin);
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="UaaGroup.Member", generator="Immutables")
        static final class Json
        implements UaaGroup.Member {
            @Nullable
            String value;
            @Nullable
            String type;
            @Nullable
            String origin;

            Json() {
            }

            @JsonProperty(value="value")
            public void setValue(String value) {
                this.value = value;
            }

            @JsonProperty(value="type")
            public void setType(String type) {
                this.type = type;
            }

            @JsonProperty(value="origin")
            public void setOrigin(String origin) {
                this.origin = origin;
            }

            @Override
            public String getValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getType() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getOrigin() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Generated(from="UaaGroup", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_DISPLAY_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        private List<String> schemas = new ArrayList<String>();
        @Nullable
        private String displayName;
        @Nullable
        private String description;
        private List<UaaGroup.Member> members = new ArrayList<UaaGroup.Member>();
        @Nullable
        private String zoneId;
        @Nullable
        private UaaMeta meta;

        private Builder() {
        }

        public final Builder from(UaaEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UaaGroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            UaaEntity instance;
            if (object instanceof UaaEntity) {
                instance = (UaaEntity)object;
                this.addAllSchemas(instance.getSchemas());
                this.id(instance.getId());
            }
            if (object instanceof UaaGroup) {
                String zoneIdValue;
                instance = (UaaGroup)object;
                String descriptionValue = instance.getDescription();
                if (descriptionValue != null) {
                    this.description(descriptionValue);
                }
                if ((zoneIdValue = instance.getZoneId()) != null) {
                    this.zoneId(zoneIdValue);
                }
                this.displayName(instance.getDisplayName());
                UaaMeta metaValue = instance.getMeta();
                if (metaValue != null) {
                    this.meta(metaValue);
                }
                this.addAllMembers(instance.getMembers());
            }
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addSchemas(String element) {
            this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            return this;
        }

        public final Builder addSchemas(String ... elements) {
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            return this;
        }

        @JsonProperty(value="schemas")
        public final Builder schemas(Iterable<String> elements) {
            this.schemas.clear();
            return this.addAllSchemas(elements);
        }

        public final Builder addAllSchemas(Iterable<String> elements) {
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            return this;
        }

        @JsonProperty(value="displayName")
        public final Builder displayName(String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Builder addMembers(UaaGroup.Member element) {
            this.members.add(Objects.requireNonNull(element, "members element"));
            return this;
        }

        public final Builder addMembers(UaaGroup.Member ... elements) {
            for (UaaGroup.Member element : elements) {
                this.members.add(Objects.requireNonNull(element, "members element"));
            }
            return this;
        }

        @JsonProperty(value="members")
        public final Builder members(Iterable<? extends UaaGroup.Member> elements) {
            this.members.clear();
            return this.addAllMembers(elements);
        }

        public final Builder addAllMembers(Iterable<? extends UaaGroup.Member> elements) {
            for (UaaGroup.Member member : elements) {
                this.members.add(Objects.requireNonNull(member, "members element"));
            }
            return this;
        }

        @JsonProperty(value="zoneId")
        public final Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        @JsonProperty(value="meta")
        public final Builder meta(UaaMeta meta) {
            this.meta = meta;
            return this;
        }

        public ImmutableUaaGroup build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUaaGroup(this.id, ImmutableUaaGroup.createUnmodifiableList(true, this.schemas), this.displayName, this.description, ImmutableUaaGroup.createUnmodifiableList(true, this.members), this.zoneId, this.meta);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("displayName");
            }
            return "Cannot build UaaGroup, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UaaGroup", generator="Immutables")
    static final class Json
    implements UaaGroup {
        @Nullable
        String id;
        @Nullable
        List<String> schemas = Collections.emptyList();
        @Nullable
        String displayName;
        @Nullable
        String description;
        @Nullable
        List<UaaGroup.Member> members = Collections.emptyList();
        @Nullable
        String zoneId;
        @Nullable
        UaaMeta meta;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="schemas")
        public void setSchemas(List<String> schemas) {
            this.schemas = schemas;
        }

        @JsonProperty(value="displayName")
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="members")
        public void setMembers(List<UaaGroup.Member> members) {
            this.members = members;
        }

        @JsonProperty(value="zoneId")
        public void setZoneId(String zoneId) {
            this.zoneId = zoneId;
        }

        @JsonProperty(value="meta")
        public void setMeta(UaaMeta meta) {
            this.meta = meta;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSchemas() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<UaaGroup.Member> getMembers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getZoneId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UaaMeta getMeta() {
            throw new UnsupportedOperationException();
        }
    }
}

