package io.dialob.security.uaa.spi.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UaaMeta}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUaaMeta.builder()}.
 */
@Generated(from = "UaaMeta", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableUaaMeta implements UaaMeta {
  private final @Nullable Integer version;
  private final @Nullable OffsetDateTime created;
  private final @Nullable OffsetDateTime lastModified;

  private ImmutableUaaMeta(
      @Nullable Integer version,
      @Nullable OffsetDateTime created,
      @Nullable OffsetDateTime lastModified) {
    this.version = version;
    this.created = created;
    this.lastModified = lastModified;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public @Nullable Integer getVersion() {
    return version;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public @Nullable OffsetDateTime getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code lastModified} attribute
   */
  @JsonProperty("lastModified")
  @Override
  public @Nullable OffsetDateTime getLastModified() {
    return lastModified;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaMeta#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaMeta withVersion(@Nullable Integer value) {
    if (Objects.equals(this.version, value)) return this;
    return new ImmutableUaaMeta(value, this.created, this.lastModified);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaMeta#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaMeta withCreated(@Nullable OffsetDateTime value) {
    if (this.created == value) return this;
    return new ImmutableUaaMeta(this.version, value, this.lastModified);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaMeta#getLastModified() lastModified} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lastModified (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaMeta withLastModified(@Nullable OffsetDateTime value) {
    if (this.lastModified == value) return this;
    return new ImmutableUaaMeta(this.version, this.created, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUaaMeta} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUaaMeta
        && equalTo((ImmutableUaaMeta) another);
  }

  private boolean equalTo(ImmutableUaaMeta another) {
    return Objects.equals(version, another.version)
        && Objects.equals(created, another.created)
        && Objects.equals(lastModified, another.lastModified);
  }

  /**
   * Computes a hash code from attributes: {@code version}, {@code created}, {@code lastModified}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + Objects.hashCode(created);
    h += (h << 5) + Objects.hashCode(lastModified);
    return h;
  }

  /**
   * Prints the immutable value {@code UaaMeta} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UaaMeta{"
        + "version=" + version
        + ", created=" + created
        + ", lastModified=" + lastModified
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "UaaMeta", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UaaMeta {
    @javax.annotation.Nullable Integer version;
    @javax.annotation.Nullable OffsetDateTime created;
    @javax.annotation.Nullable OffsetDateTime lastModified;
    @JsonProperty("version")
    public void setVersion(@Nullable Integer version) {
      this.version = version;
    }
    @JsonProperty("created")
    public void setCreated(@Nullable OffsetDateTime created) {
      this.created = created;
    }
    @JsonProperty("lastModified")
    public void setLastModified(@Nullable OffsetDateTime lastModified) {
      this.lastModified = lastModified;
    }
    @Override
    public Integer getVersion() { throw new UnsupportedOperationException(); }
    @Override
    public OffsetDateTime getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public OffsetDateTime getLastModified() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableUaaMeta fromJson(Json json) {
    ImmutableUaaMeta.Builder builder = ImmutableUaaMeta.builder();
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.lastModified != null) {
      builder.lastModified(json.lastModified);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UaaMeta} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UaaMeta instance
   */
  public static ImmutableUaaMeta copyOf(UaaMeta instance) {
    if (instance instanceof ImmutableUaaMeta) {
      return (ImmutableUaaMeta) instance;
    }
    return ImmutableUaaMeta.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUaaMeta ImmutableUaaMeta}.
   * <pre>
   * ImmutableUaaMeta.builder()
   *    .version(Integer | null) // nullable {@link UaaMeta#getVersion() version}
   *    .created(java.time.OffsetDateTime | null) // nullable {@link UaaMeta#getCreated() created}
   *    .lastModified(java.time.OffsetDateTime | null) // nullable {@link UaaMeta#getLastModified() lastModified}
   *    .build();
   * </pre>
   * @return A new ImmutableUaaMeta builder
   */
  public static ImmutableUaaMeta.Builder builder() {
    return new ImmutableUaaMeta.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUaaMeta ImmutableUaaMeta}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UaaMeta", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable Integer version;
    private @javax.annotation.Nullable OffsetDateTime created;
    private @javax.annotation.Nullable OffsetDateTime lastModified;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UaaMeta} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UaaMeta instance) {
      Objects.requireNonNull(instance, "instance");
      Integer versionValue = instance.getVersion();
      if (versionValue != null) {
        version(versionValue);
      }
      OffsetDateTime createdValue = instance.getCreated();
      if (createdValue != null) {
        created(createdValue);
      }
      OffsetDateTime lastModifiedValue = instance.getLastModified();
      if (lastModifiedValue != null) {
        lastModified(lastModifiedValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UaaMeta#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final Builder version(@Nullable Integer version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link UaaMeta#getCreated() created} attribute.
     * @param created The value for created (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created")
    public final Builder created(@Nullable OffsetDateTime created) {
      this.created = created;
      return this;
    }

    /**
     * Initializes the value for the {@link UaaMeta#getLastModified() lastModified} attribute.
     * @param lastModified The value for lastModified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lastModified")
    public final Builder lastModified(@Nullable OffsetDateTime lastModified) {
      this.lastModified = lastModified;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUaaMeta ImmutableUaaMeta}.
     * @return An immutable instance of UaaMeta
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUaaMeta build() {
      return new ImmutableUaaMeta(version, created, lastModified);
    }
  }
}
