package io.dialob.security.uaa.spi.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UaaGroup}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUaaGroup.builder()}.
 */
@Generated(from = "UaaGroup", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableUaaGroup implements UaaGroup {
  private final String id;
  private final List<String> schemas;
  private final String displayName;
  private final @Nullable String description;
  private final List<UaaGroup.Member> members;
  private final @Nullable String zoneId;
  private final @Nullable UaaMeta meta;

  private ImmutableUaaGroup(
      String id,
      List<String> schemas,
      String displayName,
      @Nullable String description,
      List<UaaGroup.Member> members,
      @Nullable String zoneId,
      @Nullable UaaMeta meta) {
    this.id = id;
    this.schemas = schemas;
    this.displayName = displayName;
    this.description = description;
    this.members = members;
    this.zoneId = zoneId;
    this.meta = meta;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code schemas} attribute
   */
  @JsonProperty("schemas")
  @Override
  public List<String> getSchemas() {
    return schemas;
  }

  /**
   * @return The value of the {@code displayName} attribute
   */
  @JsonProperty("displayName")
  @Override
  public String getDisplayName() {
    return displayName;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code members} attribute
   */
  @JsonProperty("members")
  @Override
  public List<UaaGroup.Member> getMembers() {
    return members;
  }

  /**
   * @return The value of the {@code zoneId} attribute
   */
  @JsonProperty("zoneId")
  @Override
  public @Nullable String getZoneId() {
    return zoneId;
  }

  /**
   * @return The value of the {@code meta} attribute
   */
  @JsonProperty("meta")
  @Override
  public @Nullable UaaMeta getMeta() {
    return meta;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaGroup#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaGroup withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableUaaGroup(
        newValue,
        this.schemas,
        this.displayName,
        this.description,
        this.members,
        this.zoneId,
        this.meta);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UaaGroup#getSchemas() schemas}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUaaGroup withSchemas(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableUaaGroup(this.id, newValue, this.displayName, this.description, this.members, this.zoneId, this.meta);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UaaGroup#getSchemas() schemas}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of schemas elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUaaGroup withSchemas(Iterable<String> elements) {
    if (this.schemas == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableUaaGroup(this.id, newValue, this.displayName, this.description, this.members, this.zoneId, this.meta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaGroup#getDisplayName() displayName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for displayName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaGroup withDisplayName(String value) {
    String newValue = Objects.requireNonNull(value, "displayName");
    if (this.displayName.equals(newValue)) return this;
    return new ImmutableUaaGroup(this.id, this.schemas, newValue, this.description, this.members, this.zoneId, this.meta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaGroup#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaGroup withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableUaaGroup(this.id, this.schemas, this.displayName, value, this.members, this.zoneId, this.meta);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UaaGroup#getMembers() members}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUaaGroup withMembers(UaaGroup.Member... elements) {
    List<UaaGroup.Member> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableUaaGroup(this.id, this.schemas, this.displayName, this.description, newValue, this.zoneId, this.meta);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UaaGroup#getMembers() members}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of members elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUaaGroup withMembers(Iterable<? extends UaaGroup.Member> elements) {
    if (this.members == elements) return this;
    List<UaaGroup.Member> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableUaaGroup(this.id, this.schemas, this.displayName, this.description, newValue, this.zoneId, this.meta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaGroup#getZoneId() zoneId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zoneId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaGroup withZoneId(@Nullable String value) {
    if (Objects.equals(this.zoneId, value)) return this;
    return new ImmutableUaaGroup(this.id, this.schemas, this.displayName, this.description, this.members, value, this.meta);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaGroup#getMeta() meta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for meta (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaGroup withMeta(@Nullable UaaMeta value) {
    if (this.meta == value) return this;
    return new ImmutableUaaGroup(this.id, this.schemas, this.displayName, this.description, this.members, this.zoneId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUaaGroup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUaaGroup
        && equalTo((ImmutableUaaGroup) another);
  }

  private boolean equalTo(ImmutableUaaGroup another) {
    return id.equals(another.id)
        && schemas.equals(another.schemas)
        && displayName.equals(another.displayName)
        && Objects.equals(description, another.description)
        && members.equals(another.members)
        && Objects.equals(zoneId, another.zoneId)
        && Objects.equals(meta, another.meta);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code schemas}, {@code displayName}, {@code description}, {@code members}, {@code zoneId}, {@code meta}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + schemas.hashCode();
    h += (h << 5) + displayName.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + members.hashCode();
    h += (h << 5) + Objects.hashCode(zoneId);
    h += (h << 5) + Objects.hashCode(meta);
    return h;
  }

  /**
   * Prints the immutable value {@code UaaGroup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UaaGroup{"
        + "id=" + id
        + ", schemas=" + schemas
        + ", displayName=" + displayName
        + ", description=" + description
        + ", members=" + members
        + ", zoneId=" + zoneId
        + ", meta=" + meta
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "UaaGroup", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UaaGroup {
    @javax.annotation.Nullable String id;
    @javax.annotation.Nullable List<String> schemas = Collections.emptyList();
    @javax.annotation.Nullable String displayName;
    @javax.annotation.Nullable String description;
    @javax.annotation.Nullable List<UaaGroup.Member> members = Collections.emptyList();
    @javax.annotation.Nullable String zoneId;
    @javax.annotation.Nullable UaaMeta meta;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("schemas")
    public void setSchemas(List<String> schemas) {
      this.schemas = schemas;
    }
    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
      this.displayName = displayName;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("members")
    public void setMembers(List<UaaGroup.Member> members) {
      this.members = members;
    }
    @JsonProperty("zoneId")
    public void setZoneId(@Nullable String zoneId) {
      this.zoneId = zoneId;
    }
    @JsonProperty("meta")
    public void setMeta(@Nullable UaaMeta meta) {
      this.meta = meta;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSchemas() { throw new UnsupportedOperationException(); }
    @Override
    public String getDisplayName() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public List<UaaGroup.Member> getMembers() { throw new UnsupportedOperationException(); }
    @Override
    public String getZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public UaaMeta getMeta() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableUaaGroup fromJson(Json json) {
    ImmutableUaaGroup.Builder builder = ImmutableUaaGroup.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.schemas != null) {
      builder.addAllSchemas(json.schemas);
    }
    if (json.displayName != null) {
      builder.displayName(json.displayName);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.members != null) {
      builder.addAllMembers(json.members);
    }
    if (json.zoneId != null) {
      builder.zoneId(json.zoneId);
    }
    if (json.meta != null) {
      builder.meta(json.meta);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UaaGroup} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UaaGroup instance
   */
  public static ImmutableUaaGroup copyOf(UaaGroup instance) {
    if (instance instanceof ImmutableUaaGroup) {
      return (ImmutableUaaGroup) instance;
    }
    return ImmutableUaaGroup.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUaaGroup ImmutableUaaGroup}.
   * <pre>
   * ImmutableUaaGroup.builder()
   *    .id(String) // required {@link UaaGroup#getId() id}
   *    .addSchemas|addAllSchemas(String) // {@link UaaGroup#getSchemas() schemas} elements
   *    .displayName(String) // required {@link UaaGroup#getDisplayName() displayName}
   *    .description(String | null) // nullable {@link UaaGroup#getDescription() description}
   *    .addMembers|addAllMembers(io.dialob.security.uaa.spi.model.UaaGroup.Member) // {@link UaaGroup#getMembers() members} elements
   *    .zoneId(String | null) // nullable {@link UaaGroup#getZoneId() zoneId}
   *    .meta(io.dialob.security.uaa.spi.model.UaaMeta | null) // nullable {@link UaaGroup#getMeta() meta}
   *    .build();
   * </pre>
   * @return A new ImmutableUaaGroup builder
   */
  public static ImmutableUaaGroup.Builder builder() {
    return new ImmutableUaaGroup.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUaaGroup ImmutableUaaGroup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UaaGroup", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_DISPLAY_NAME = 0x2L;
    private long initBits = 0x3L;

    private @javax.annotation.Nullable String id;
    private List<String> schemas = new ArrayList<String>();
    private @javax.annotation.Nullable String displayName;
    private @javax.annotation.Nullable String description;
    private List<UaaGroup.Member> members = new ArrayList<UaaGroup.Member>();
    private @javax.annotation.Nullable String zoneId;
    private @javax.annotation.Nullable UaaMeta meta;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.security.uaa.spi.model.UaaEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UaaEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.security.uaa.spi.model.UaaGroup} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UaaGroup instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof UaaEntity) {
        UaaEntity instance = (UaaEntity) object;
        addAllSchemas(instance.getSchemas());
        id(instance.getId());
      }
      if (object instanceof UaaGroup) {
        UaaGroup instance = (UaaGroup) object;
        String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        String zoneIdValue = instance.getZoneId();
        if (zoneIdValue != null) {
          zoneId(zoneIdValue);
        }
        displayName(instance.getDisplayName());
        UaaMeta metaValue = instance.getMeta();
        if (metaValue != null) {
          meta(metaValue);
        }
        addAllMembers(instance.getMembers());
      }
    }

    /**
     * Initializes the value for the {@link UaaGroup#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Adds one element to {@link UaaGroup#getSchemas() schemas} list.
     * @param element A schemas element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSchemas(String element) {
      this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      return this;
    }

    /**
     * Adds elements to {@link UaaGroup#getSchemas() schemas} list.
     * @param elements An array of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSchemas(String... elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UaaGroup#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schemas")
    public final Builder schemas(Iterable<String> elements) {
      this.schemas.clear();
      return addAllSchemas(elements);
    }

    /**
     * Adds elements to {@link UaaGroup#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSchemas(Iterable<String> elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UaaGroup#getDisplayName() displayName} attribute.
     * @param displayName The value for displayName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("displayName")
    public final Builder displayName(String displayName) {
      this.displayName = Objects.requireNonNull(displayName, "displayName");
      initBits &= ~INIT_BIT_DISPLAY_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UaaGroup#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Adds one element to {@link UaaGroup#getMembers() members} list.
     * @param element A members element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMembers(UaaGroup.Member element) {
      this.members.add(Objects.requireNonNull(element, "members element"));
      return this;
    }

    /**
     * Adds elements to {@link UaaGroup#getMembers() members} list.
     * @param elements An array of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMembers(UaaGroup.Member... elements) {
      for (UaaGroup.Member element : elements) {
        this.members.add(Objects.requireNonNull(element, "members element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UaaGroup#getMembers() members} list.
     * @param elements An iterable of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("members")
    public final Builder members(Iterable<? extends UaaGroup.Member> elements) {
      this.members.clear();
      return addAllMembers(elements);
    }

    /**
     * Adds elements to {@link UaaGroup#getMembers() members} list.
     * @param elements An iterable of members elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMembers(Iterable<? extends UaaGroup.Member> elements) {
      for (UaaGroup.Member element : elements) {
        this.members.add(Objects.requireNonNull(element, "members element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UaaGroup#getZoneId() zoneId} attribute.
     * @param zoneId The value for zoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("zoneId")
    public final Builder zoneId(@Nullable String zoneId) {
      this.zoneId = zoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link UaaGroup#getMeta() meta} attribute.
     * @param meta The value for meta (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("meta")
    public final Builder meta(@Nullable UaaMeta meta) {
      this.meta = meta;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUaaGroup ImmutableUaaGroup}.
     * @return An immutable instance of UaaGroup
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUaaGroup build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUaaGroup(
          id,
          createUnmodifiableList(true, schemas),
          displayName,
          description,
          createUnmodifiableList(true, members),
          zoneId,
          meta);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_DISPLAY_NAME) != 0) attributes.add("displayName");
      return "Cannot build UaaGroup, some of required attributes are not set " + attributes;
    }
  }

  /**
   * Immutable implementation of {@link UaaGroup.Member}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableUaaGroup.Member.builder()}.
   */
  @Generated(from = "UaaGroup.Member", generator = "Immutables")
  @Immutable
  @JsonIgnoreProperties(ignoreUnknown = true)
  public static final class Member implements UaaGroup.Member {
    private final @Nullable String value;
    private final @Nullable String type;
    private final @Nullable String origin;

    private Member(
        @Nullable String value,
        @Nullable String type,
        @Nullable String origin) {
      this.value = value;
      this.type = type;
      this.origin = origin;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @JsonProperty("value")
    @Override
    public @Nullable String getValue() {
      return value;
    }

    /**
     * @return The value of the {@code type} attribute
     */
    @JsonProperty("type")
    @Override
    public @Nullable String getType() {
      return type;
    }

    /**
     * @return The value of the {@code origin} attribute
     */
    @JsonProperty("origin")
    @Override
    public @Nullable String getOrigin() {
      return origin;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link UaaGroup.Member#getValue() value} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableUaaGroup.Member withValue(@Nullable String value) {
      if (Objects.equals(this.value, value)) return this;
      return new ImmutableUaaGroup.Member(value, this.type, this.origin);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link UaaGroup.Member#getType() type} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for type (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableUaaGroup.Member withType(@Nullable String value) {
      if (Objects.equals(this.type, value)) return this;
      return new ImmutableUaaGroup.Member(this.value, value, this.origin);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link UaaGroup.Member#getOrigin() origin} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for origin (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableUaaGroup.Member withOrigin(@Nullable String value) {
      if (Objects.equals(this.origin, value)) return this;
      return new ImmutableUaaGroup.Member(this.value, this.type, value);
    }

    /**
     * This instance is equal to all instances of {@code Member} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@javax.annotation.Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableUaaGroup.Member
          && equalTo((ImmutableUaaGroup.Member) another);
    }

    private boolean equalTo(ImmutableUaaGroup.Member another) {
      return Objects.equals(value, another.value)
          && Objects.equals(type, another.type)
          && Objects.equals(origin, another.origin);
    }

    /**
     * Computes a hash code from attributes: {@code value}, {@code type}, {@code origin}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + Objects.hashCode(value);
      h += (h << 5) + Objects.hashCode(type);
      h += (h << 5) + Objects.hashCode(origin);
      return h;
    }

    /**
     * Prints the immutable value {@code Member} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Member{"
          + "value=" + value
          + ", type=" + type
          + ", origin=" + origin
          + "}";
    }

    /**
     * Utility type used to correctly read immutable object from JSON representation.
     * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Generated(from = "UaaGroup.Member", generator = "Immutables")
    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
    static final class Json implements UaaGroup.Member {
      @javax.annotation.Nullable String value;
      @javax.annotation.Nullable String type;
      @javax.annotation.Nullable String origin;
      @JsonProperty("value")
      public void setValue(@Nullable String value) {
        this.value = value;
      }
      @JsonProperty("type")
      public void setType(@Nullable String type) {
        this.type = type;
      }
      @JsonProperty("origin")
      public void setOrigin(@Nullable String origin) {
        this.origin = origin;
      }
      @Override
      public String getValue() { throw new UnsupportedOperationException(); }
      @Override
      public String getType() { throw new UnsupportedOperationException(); }
      @Override
      public String getOrigin() { throw new UnsupportedOperationException(); }
    }

    /**
     * @param json A JSON-bindable data structure
     * @return An immutable value type
     * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Deprecated
    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    static ImmutableUaaGroup.Member fromJson(Json json) {
      ImmutableUaaGroup.Member.Builder builder = ImmutableUaaGroup.Member.builder();
      if (json.value != null) {
        builder.value(json.value);
      }
      if (json.type != null) {
        builder.type(json.type);
      }
      if (json.origin != null) {
        builder.origin(json.origin);
      }
      return builder.build();
    }

    /**
     * Creates an immutable copy of a {@link UaaGroup.Member} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Member instance
     */
    public static ImmutableUaaGroup.Member copyOf(UaaGroup.Member instance) {
      if (instance instanceof ImmutableUaaGroup.Member) {
        return (ImmutableUaaGroup.Member) instance;
      }
      return ImmutableUaaGroup.Member.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableUaaGroup.Member Member}.
     * <pre>
     * ImmutableUaaGroup.Member.builder()
     *    .value(String | null) // nullable {@link UaaGroup.Member#getValue() value}
     *    .type(String | null) // nullable {@link UaaGroup.Member#getType() type}
     *    .origin(String | null) // nullable {@link UaaGroup.Member#getOrigin() origin}
     *    .build();
     * </pre>
     * @return A new Member builder
     */
    public static ImmutableUaaGroup.Member.Builder builder() {
      return new ImmutableUaaGroup.Member.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableUaaGroup.Member Member}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "UaaGroup.Member", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private @javax.annotation.Nullable String value;
      private @javax.annotation.Nullable String type;
      private @javax.annotation.Nullable String origin;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Member} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(UaaGroup.Member instance) {
        Objects.requireNonNull(instance, "instance");
        String valueValue = instance.getValue();
        if (valueValue != null) {
          value(valueValue);
        }
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
        String originValue = instance.getOrigin();
        if (originValue != null) {
          origin(originValue);
        }
        return this;
      }

      /**
       * Initializes the value for the {@link UaaGroup.Member#getValue() value} attribute.
       * @param value The value for value (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("value")
      public final Builder value(@Nullable String value) {
        this.value = value;
        return this;
      }

      /**
       * Initializes the value for the {@link UaaGroup.Member#getType() type} attribute.
       * @param type The value for type (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("type")
      public final Builder type(@Nullable String type) {
        this.type = type;
        return this;
      }

      /**
       * Initializes the value for the {@link UaaGroup.Member#getOrigin() origin} attribute.
       * @param origin The value for origin (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("origin")
      public final Builder origin(@Nullable String origin) {
        this.origin = origin;
        return this;
      }

      /**
       * Builds a new {@link ImmutableUaaGroup.Member Member}.
       * @return An immutable instance of Member
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableUaaGroup.Member build() {
        return new ImmutableUaaGroup.Member(value, type, origin);
      }
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
