package io.dialob.security.uaa.spi.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UaaUser}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUaaUser.builder()}.
 */
@Generated(from = "UaaUser", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableUaaUser implements UaaUser {
  private final String id;
  private final List<String> schemas;
  private final @Nullable UaaMeta meta;
  private final @Nullable UaaUser.Name name;
  private final List<UaaUser.Email> emails;
  private final @Nullable String externalId;
  private final @Nullable String userName;
  private final List<UaaUser.Group> groups;
  private final List<UaaUser.Approval> approvals;
  private final @Nullable Boolean active;
  private final @Nullable Boolean verified;
  private final @Nullable String origin;
  private final @Nullable String zoneId;
  private final @Nullable OffsetDateTime passwordLastModified;
  private final @Nullable Long previousLogonTime;
  private final @Nullable Long lastLogonTime;

  private ImmutableUaaUser(
      String id,
      List<String> schemas,
      @Nullable UaaMeta meta,
      @Nullable UaaUser.Name name,
      List<UaaUser.Email> emails,
      @Nullable String externalId,
      @Nullable String userName,
      List<UaaUser.Group> groups,
      List<UaaUser.Approval> approvals,
      @Nullable Boolean active,
      @Nullable Boolean verified,
      @Nullable String origin,
      @Nullable String zoneId,
      @Nullable OffsetDateTime passwordLastModified,
      @Nullable Long previousLogonTime,
      @Nullable Long lastLogonTime) {
    this.id = id;
    this.schemas = schemas;
    this.meta = meta;
    this.name = name;
    this.emails = emails;
    this.externalId = externalId;
    this.userName = userName;
    this.groups = groups;
    this.approvals = approvals;
    this.active = active;
    this.verified = verified;
    this.origin = origin;
    this.zoneId = zoneId;
    this.passwordLastModified = passwordLastModified;
    this.previousLogonTime = previousLogonTime;
    this.lastLogonTime = lastLogonTime;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code schemas} attribute
   */
  @JsonProperty("schemas")
  @Override
  public List<String> getSchemas() {
    return schemas;
  }

  /**
   * @return The value of the {@code meta} attribute
   */
  @JsonProperty("meta")
  @Override
  public @Nullable UaaMeta getMeta() {
    return meta;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable UaaUser.Name getName() {
    return name;
  }

  /**
   * @return The value of the {@code emails} attribute
   */
  @JsonProperty("emails")
  @Override
  public List<UaaUser.Email> getEmails() {
    return emails;
  }

  /**
   * @return The value of the {@code externalId} attribute
   */
  @JsonProperty("externalId")
  @Override
  public @Nullable String getExternalId() {
    return externalId;
  }

  /**
   * @return The value of the {@code userName} attribute
   */
  @JsonProperty("userName")
  @Override
  public @Nullable String getUserName() {
    return userName;
  }

  /**
   * @return The value of the {@code groups} attribute
   */
  @JsonProperty("groups")
  @Override
  public List<UaaUser.Group> getGroups() {
    return groups;
  }

  /**
   * @return The value of the {@code approvals} attribute
   */
  @JsonProperty("approvals")
  @Override
  public List<UaaUser.Approval> getApprovals() {
    return approvals;
  }

  /**
   * @return The value of the {@code active} attribute
   */
  @JsonProperty("active")
  @Override
  public @Nullable Boolean getActive() {
    return active;
  }

  /**
   * @return The value of the {@code verified} attribute
   */
  @JsonProperty("verified")
  @Override
  public @Nullable Boolean getVerified() {
    return verified;
  }

  /**
   * @return The value of the {@code origin} attribute
   */
  @JsonProperty("origin")
  @Override
  public @Nullable String getOrigin() {
    return origin;
  }

  /**
   * @return The value of the {@code zoneId} attribute
   */
  @JsonProperty("zoneId")
  @Override
  public @Nullable String getZoneId() {
    return zoneId;
  }

  /**
   * @return The value of the {@code passwordLastModified} attribute
   */
  @JsonProperty("passwordLastModified")
  @Override
  public @Nullable OffsetDateTime getPasswordLastModified() {
    return passwordLastModified;
  }

  /**
   * @return The value of the {@code previousLogonTime} attribute
   */
  @JsonProperty("previousLogonTime")
  @Override
  public @Nullable Long getPreviousLogonTime() {
    return previousLogonTime;
  }

  /**
   * @return The value of the {@code lastLogonTime} attribute
   */
  @JsonProperty("lastLogonTime")
  @Override
  public @Nullable Long getLastLogonTime() {
    return lastLogonTime;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaUser#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaUser withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableUaaUser(
        newValue,
        this.schemas,
        this.meta,
        this.name,
        this.emails,
        this.externalId,
        this.userName,
        this.groups,
        this.approvals,
        this.active,
        this.verified,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UaaUser#getSchemas() schemas}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUaaUser withSchemas(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableUaaUser(
        this.id,
        newValue,
        this.meta,
        this.name,
        this.emails,
        this.externalId,
        this.userName,
        this.groups,
        this.approvals,
        this.active,
        this.verified,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UaaUser#getSchemas() schemas}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of schemas elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUaaUser withSchemas(Iterable<String> elements) {
    if (this.schemas == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableUaaUser(
        this.id,
        newValue,
        this.meta,
        this.name,
        this.emails,
        this.externalId,
        this.userName,
        this.groups,
        this.approvals,
        this.active,
        this.verified,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaUser#getMeta() meta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for meta (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaUser withMeta(@Nullable UaaMeta value) {
    if (this.meta == value) return this;
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        value,
        this.name,
        this.emails,
        this.externalId,
        this.userName,
        this.groups,
        this.approvals,
        this.active,
        this.verified,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaUser#getName() name} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaUser withName(@Nullable UaaUser.Name value) {
    if (this.name == value) return this;
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        this.meta,
        value,
        this.emails,
        this.externalId,
        this.userName,
        this.groups,
        this.approvals,
        this.active,
        this.verified,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UaaUser#getEmails() emails}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUaaUser withEmails(UaaUser.Email... elements) {
    List<UaaUser.Email> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        this.meta,
        this.name,
        newValue,
        this.externalId,
        this.userName,
        this.groups,
        this.approvals,
        this.active,
        this.verified,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UaaUser#getEmails() emails}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of emails elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUaaUser withEmails(Iterable<? extends UaaUser.Email> elements) {
    if (this.emails == elements) return this;
    List<UaaUser.Email> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        this.meta,
        this.name,
        newValue,
        this.externalId,
        this.userName,
        this.groups,
        this.approvals,
        this.active,
        this.verified,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaUser#getExternalId() externalId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for externalId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaUser withExternalId(@Nullable String value) {
    if (Objects.equals(this.externalId, value)) return this;
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        this.meta,
        this.name,
        this.emails,
        value,
        this.userName,
        this.groups,
        this.approvals,
        this.active,
        this.verified,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaUser#getUserName() userName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaUser withUserName(@Nullable String value) {
    if (Objects.equals(this.userName, value)) return this;
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        this.meta,
        this.name,
        this.emails,
        this.externalId,
        value,
        this.groups,
        this.approvals,
        this.active,
        this.verified,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UaaUser#getGroups() groups}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUaaUser withGroups(UaaUser.Group... elements) {
    List<UaaUser.Group> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        this.meta,
        this.name,
        this.emails,
        this.externalId,
        this.userName,
        newValue,
        this.approvals,
        this.active,
        this.verified,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UaaUser#getGroups() groups}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of groups elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUaaUser withGroups(Iterable<? extends UaaUser.Group> elements) {
    if (this.groups == elements) return this;
    List<UaaUser.Group> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        this.meta,
        this.name,
        this.emails,
        this.externalId,
        this.userName,
        newValue,
        this.approvals,
        this.active,
        this.verified,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UaaUser#getApprovals() approvals}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUaaUser withApprovals(UaaUser.Approval... elements) {
    List<UaaUser.Approval> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        this.meta,
        this.name,
        this.emails,
        this.externalId,
        this.userName,
        this.groups,
        newValue,
        this.active,
        this.verified,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UaaUser#getApprovals() approvals}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of approvals elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUaaUser withApprovals(Iterable<? extends UaaUser.Approval> elements) {
    if (this.approvals == elements) return this;
    List<UaaUser.Approval> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        this.meta,
        this.name,
        this.emails,
        this.externalId,
        this.userName,
        this.groups,
        newValue,
        this.active,
        this.verified,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaUser#getActive() active} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for active (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaUser withActive(@Nullable Boolean value) {
    if (Objects.equals(this.active, value)) return this;
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        this.meta,
        this.name,
        this.emails,
        this.externalId,
        this.userName,
        this.groups,
        this.approvals,
        value,
        this.verified,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaUser#getVerified() verified} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verified (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaUser withVerified(@Nullable Boolean value) {
    if (Objects.equals(this.verified, value)) return this;
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        this.meta,
        this.name,
        this.emails,
        this.externalId,
        this.userName,
        this.groups,
        this.approvals,
        this.active,
        value,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaUser#getOrigin() origin} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for origin (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaUser withOrigin(@Nullable String value) {
    if (Objects.equals(this.origin, value)) return this;
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        this.meta,
        this.name,
        this.emails,
        this.externalId,
        this.userName,
        this.groups,
        this.approvals,
        this.active,
        this.verified,
        value,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaUser#getZoneId() zoneId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zoneId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaUser withZoneId(@Nullable String value) {
    if (Objects.equals(this.zoneId, value)) return this;
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        this.meta,
        this.name,
        this.emails,
        this.externalId,
        this.userName,
        this.groups,
        this.approvals,
        this.active,
        this.verified,
        this.origin,
        value,
        this.passwordLastModified,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaUser#getPasswordLastModified() passwordLastModified} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for passwordLastModified (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaUser withPasswordLastModified(@Nullable OffsetDateTime value) {
    if (this.passwordLastModified == value) return this;
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        this.meta,
        this.name,
        this.emails,
        this.externalId,
        this.userName,
        this.groups,
        this.approvals,
        this.active,
        this.verified,
        this.origin,
        this.zoneId,
        value,
        this.previousLogonTime,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaUser#getPreviousLogonTime() previousLogonTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for previousLogonTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaUser withPreviousLogonTime(@Nullable Long value) {
    if (Objects.equals(this.previousLogonTime, value)) return this;
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        this.meta,
        this.name,
        this.emails,
        this.externalId,
        this.userName,
        this.groups,
        this.approvals,
        this.active,
        this.verified,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        value,
        this.lastLogonTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UaaUser#getLastLogonTime() lastLogonTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lastLogonTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUaaUser withLastLogonTime(@Nullable Long value) {
    if (Objects.equals(this.lastLogonTime, value)) return this;
    return new ImmutableUaaUser(
        this.id,
        this.schemas,
        this.meta,
        this.name,
        this.emails,
        this.externalId,
        this.userName,
        this.groups,
        this.approvals,
        this.active,
        this.verified,
        this.origin,
        this.zoneId,
        this.passwordLastModified,
        this.previousLogonTime,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUaaUser} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUaaUser
        && equalTo((ImmutableUaaUser) another);
  }

  private boolean equalTo(ImmutableUaaUser another) {
    return id.equals(another.id)
        && schemas.equals(another.schemas)
        && Objects.equals(meta, another.meta)
        && Objects.equals(name, another.name)
        && emails.equals(another.emails)
        && Objects.equals(externalId, another.externalId)
        && Objects.equals(userName, another.userName)
        && groups.equals(another.groups)
        && approvals.equals(another.approvals)
        && Objects.equals(active, another.active)
        && Objects.equals(verified, another.verified)
        && Objects.equals(origin, another.origin)
        && Objects.equals(zoneId, another.zoneId)
        && Objects.equals(passwordLastModified, another.passwordLastModified)
        && Objects.equals(previousLogonTime, another.previousLogonTime)
        && Objects.equals(lastLogonTime, another.lastLogonTime);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code schemas}, {@code meta}, {@code name}, {@code emails}, {@code externalId}, {@code userName}, {@code groups}, {@code approvals}, {@code active}, {@code verified}, {@code origin}, {@code zoneId}, {@code passwordLastModified}, {@code previousLogonTime}, {@code lastLogonTime}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + schemas.hashCode();
    h += (h << 5) + Objects.hashCode(meta);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + emails.hashCode();
    h += (h << 5) + Objects.hashCode(externalId);
    h += (h << 5) + Objects.hashCode(userName);
    h += (h << 5) + groups.hashCode();
    h += (h << 5) + approvals.hashCode();
    h += (h << 5) + Objects.hashCode(active);
    h += (h << 5) + Objects.hashCode(verified);
    h += (h << 5) + Objects.hashCode(origin);
    h += (h << 5) + Objects.hashCode(zoneId);
    h += (h << 5) + Objects.hashCode(passwordLastModified);
    h += (h << 5) + Objects.hashCode(previousLogonTime);
    h += (h << 5) + Objects.hashCode(lastLogonTime);
    return h;
  }

  /**
   * Prints the immutable value {@code UaaUser} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UaaUser{"
        + "id=" + id
        + ", schemas=" + schemas
        + ", meta=" + meta
        + ", name=" + name
        + ", emails=" + emails
        + ", externalId=" + externalId
        + ", userName=" + userName
        + ", groups=" + groups
        + ", approvals=" + approvals
        + ", active=" + active
        + ", verified=" + verified
        + ", origin=" + origin
        + ", zoneId=" + zoneId
        + ", passwordLastModified=" + passwordLastModified
        + ", previousLogonTime=" + previousLogonTime
        + ", lastLogonTime=" + lastLogonTime
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "UaaUser", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UaaUser {
    @javax.annotation.Nullable String id;
    @javax.annotation.Nullable List<String> schemas = Collections.emptyList();
    @javax.annotation.Nullable UaaMeta meta;
    @javax.annotation.Nullable UaaUser.Name name;
    @javax.annotation.Nullable List<UaaUser.Email> emails = Collections.emptyList();
    @javax.annotation.Nullable String externalId;
    @javax.annotation.Nullable String userName;
    @javax.annotation.Nullable List<UaaUser.Group> groups = Collections.emptyList();
    @javax.annotation.Nullable List<UaaUser.Approval> approvals = Collections.emptyList();
    @javax.annotation.Nullable Boolean active;
    @javax.annotation.Nullable Boolean verified;
    @javax.annotation.Nullable String origin;
    @javax.annotation.Nullable String zoneId;
    @javax.annotation.Nullable OffsetDateTime passwordLastModified;
    @javax.annotation.Nullable Long previousLogonTime;
    @javax.annotation.Nullable Long lastLogonTime;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("schemas")
    public void setSchemas(List<String> schemas) {
      this.schemas = schemas;
    }
    @JsonProperty("meta")
    public void setMeta(@Nullable UaaMeta meta) {
      this.meta = meta;
    }
    @JsonProperty("name")
    public void setName(@Nullable UaaUser.Name name) {
      this.name = name;
    }
    @JsonProperty("emails")
    public void setEmails(List<UaaUser.Email> emails) {
      this.emails = emails;
    }
    @JsonProperty("externalId")
    public void setExternalId(@Nullable String externalId) {
      this.externalId = externalId;
    }
    @JsonProperty("userName")
    public void setUserName(@Nullable String userName) {
      this.userName = userName;
    }
    @JsonProperty("groups")
    public void setGroups(List<UaaUser.Group> groups) {
      this.groups = groups;
    }
    @JsonProperty("approvals")
    public void setApprovals(List<UaaUser.Approval> approvals) {
      this.approvals = approvals;
    }
    @JsonProperty("active")
    public void setActive(@Nullable Boolean active) {
      this.active = active;
    }
    @JsonProperty("verified")
    public void setVerified(@Nullable Boolean verified) {
      this.verified = verified;
    }
    @JsonProperty("origin")
    public void setOrigin(@Nullable String origin) {
      this.origin = origin;
    }
    @JsonProperty("zoneId")
    public void setZoneId(@Nullable String zoneId) {
      this.zoneId = zoneId;
    }
    @JsonProperty("passwordLastModified")
    public void setPasswordLastModified(@Nullable OffsetDateTime passwordLastModified) {
      this.passwordLastModified = passwordLastModified;
    }
    @JsonProperty("previousLogonTime")
    public void setPreviousLogonTime(@Nullable Long previousLogonTime) {
      this.previousLogonTime = previousLogonTime;
    }
    @JsonProperty("lastLogonTime")
    public void setLastLogonTime(@Nullable Long lastLogonTime) {
      this.lastLogonTime = lastLogonTime;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSchemas() { throw new UnsupportedOperationException(); }
    @Override
    public UaaMeta getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public UaaUser.Name getName() { throw new UnsupportedOperationException(); }
    @Override
    public List<UaaUser.Email> getEmails() { throw new UnsupportedOperationException(); }
    @Override
    public String getExternalId() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserName() { throw new UnsupportedOperationException(); }
    @Override
    public List<UaaUser.Group> getGroups() { throw new UnsupportedOperationException(); }
    @Override
    public List<UaaUser.Approval> getApprovals() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getActive() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getVerified() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public String getZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public OffsetDateTime getPasswordLastModified() { throw new UnsupportedOperationException(); }
    @Override
    public Long getPreviousLogonTime() { throw new UnsupportedOperationException(); }
    @Override
    public Long getLastLogonTime() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableUaaUser fromJson(Json json) {
    ImmutableUaaUser.Builder builder = ImmutableUaaUser.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.schemas != null) {
      builder.addAllSchemas(json.schemas);
    }
    if (json.meta != null) {
      builder.meta(json.meta);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.emails != null) {
      builder.addAllEmails(json.emails);
    }
    if (json.externalId != null) {
      builder.externalId(json.externalId);
    }
    if (json.userName != null) {
      builder.userName(json.userName);
    }
    if (json.groups != null) {
      builder.addAllGroups(json.groups);
    }
    if (json.approvals != null) {
      builder.addAllApprovals(json.approvals);
    }
    if (json.active != null) {
      builder.active(json.active);
    }
    if (json.verified != null) {
      builder.verified(json.verified);
    }
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.zoneId != null) {
      builder.zoneId(json.zoneId);
    }
    if (json.passwordLastModified != null) {
      builder.passwordLastModified(json.passwordLastModified);
    }
    if (json.previousLogonTime != null) {
      builder.previousLogonTime(json.previousLogonTime);
    }
    if (json.lastLogonTime != null) {
      builder.lastLogonTime(json.lastLogonTime);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UaaUser} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UaaUser instance
   */
  public static ImmutableUaaUser copyOf(UaaUser instance) {
    if (instance instanceof ImmutableUaaUser) {
      return (ImmutableUaaUser) instance;
    }
    return ImmutableUaaUser.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUaaUser ImmutableUaaUser}.
   * <pre>
   * ImmutableUaaUser.builder()
   *    .id(String) // required {@link UaaUser#getId() id}
   *    .addSchemas|addAllSchemas(String) // {@link UaaUser#getSchemas() schemas} elements
   *    .meta(io.dialob.security.uaa.spi.model.UaaMeta | null) // nullable {@link UaaUser#getMeta() meta}
   *    .name(io.dialob.security.uaa.spi.model.UaaUser.Name | null) // nullable {@link UaaUser#getName() name}
   *    .addEmails|addAllEmails(io.dialob.security.uaa.spi.model.UaaUser.Email) // {@link UaaUser#getEmails() emails} elements
   *    .externalId(String | null) // nullable {@link UaaUser#getExternalId() externalId}
   *    .userName(String | null) // nullable {@link UaaUser#getUserName() userName}
   *    .addGroups|addAllGroups(io.dialob.security.uaa.spi.model.UaaUser.Group) // {@link UaaUser#getGroups() groups} elements
   *    .addApprovals|addAllApprovals(io.dialob.security.uaa.spi.model.UaaUser.Approval) // {@link UaaUser#getApprovals() approvals} elements
   *    .active(Boolean | null) // nullable {@link UaaUser#getActive() active}
   *    .verified(Boolean | null) // nullable {@link UaaUser#getVerified() verified}
   *    .origin(String | null) // nullable {@link UaaUser#getOrigin() origin}
   *    .zoneId(String | null) // nullable {@link UaaUser#getZoneId() zoneId}
   *    .passwordLastModified(java.time.OffsetDateTime | null) // nullable {@link UaaUser#getPasswordLastModified() passwordLastModified}
   *    .previousLogonTime(Long | null) // nullable {@link UaaUser#getPreviousLogonTime() previousLogonTime}
   *    .lastLogonTime(Long | null) // nullable {@link UaaUser#getLastLogonTime() lastLogonTime}
   *    .build();
   * </pre>
   * @return A new ImmutableUaaUser builder
   */
  public static ImmutableUaaUser.Builder builder() {
    return new ImmutableUaaUser.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUaaUser ImmutableUaaUser}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UaaUser", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable String id;
    private List<String> schemas = new ArrayList<String>();
    private @javax.annotation.Nullable UaaMeta meta;
    private @javax.annotation.Nullable UaaUser.Name name;
    private List<UaaUser.Email> emails = new ArrayList<UaaUser.Email>();
    private @javax.annotation.Nullable String externalId;
    private @javax.annotation.Nullable String userName;
    private List<UaaUser.Group> groups = new ArrayList<UaaUser.Group>();
    private List<UaaUser.Approval> approvals = new ArrayList<UaaUser.Approval>();
    private @javax.annotation.Nullable Boolean active;
    private @javax.annotation.Nullable Boolean verified;
    private @javax.annotation.Nullable String origin;
    private @javax.annotation.Nullable String zoneId;
    private @javax.annotation.Nullable OffsetDateTime passwordLastModified;
    private @javax.annotation.Nullable Long previousLogonTime;
    private @javax.annotation.Nullable Long lastLogonTime;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.security.uaa.spi.model.UaaUser} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UaaUser instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.security.uaa.spi.model.UaaEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UaaEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof UaaUser) {
        UaaUser instance = (UaaUser) object;
        String originValue = instance.getOrigin();
        if (originValue != null) {
          origin(originValue);
        }
        Boolean verifiedValue = instance.getVerified();
        if (verifiedValue != null) {
          verified(verifiedValue);
        }
        String externalIdValue = instance.getExternalId();
        if (externalIdValue != null) {
          externalId(externalIdValue);
        }
        addAllGroups(instance.getGroups());
        Boolean activeValue = instance.getActive();
        if (activeValue != null) {
          active(activeValue);
        }
        String userNameValue = instance.getUserName();
        if (userNameValue != null) {
          userName(userNameValue);
        }
        addAllEmails(instance.getEmails());
        Long lastLogonTimeValue = instance.getLastLogonTime();
        if (lastLogonTimeValue != null) {
          lastLogonTime(lastLogonTimeValue);
        }
        UaaMeta metaValue = instance.getMeta();
        if (metaValue != null) {
          meta(metaValue);
        }
        addAllApprovals(instance.getApprovals());
        Long previousLogonTimeValue = instance.getPreviousLogonTime();
        if (previousLogonTimeValue != null) {
          previousLogonTime(previousLogonTimeValue);
        }
        UaaUser.Name nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        String zoneIdValue = instance.getZoneId();
        if (zoneIdValue != null) {
          zoneId(zoneIdValue);
        }
        OffsetDateTime passwordLastModifiedValue = instance.getPasswordLastModified();
        if (passwordLastModifiedValue != null) {
          passwordLastModified(passwordLastModifiedValue);
        }
      }
      if (object instanceof UaaEntity) {
        UaaEntity instance = (UaaEntity) object;
        addAllSchemas(instance.getSchemas());
        id(instance.getId());
      }
    }

    /**
     * Initializes the value for the {@link UaaUser#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Adds one element to {@link UaaUser#getSchemas() schemas} list.
     * @param element A schemas element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSchemas(String element) {
      this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      return this;
    }

    /**
     * Adds elements to {@link UaaUser#getSchemas() schemas} list.
     * @param elements An array of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSchemas(String... elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UaaUser#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schemas")
    public final Builder schemas(Iterable<String> elements) {
      this.schemas.clear();
      return addAllSchemas(elements);
    }

    /**
     * Adds elements to {@link UaaUser#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSchemas(Iterable<String> elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UaaUser#getMeta() meta} attribute.
     * @param meta The value for meta (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("meta")
    public final Builder meta(@Nullable UaaMeta meta) {
      this.meta = meta;
      return this;
    }

    /**
     * Initializes the value for the {@link UaaUser#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable UaaUser.Name name) {
      this.name = name;
      return this;
    }

    /**
     * Adds one element to {@link UaaUser#getEmails() emails} list.
     * @param element A emails element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEmails(UaaUser.Email element) {
      this.emails.add(Objects.requireNonNull(element, "emails element"));
      return this;
    }

    /**
     * Adds elements to {@link UaaUser#getEmails() emails} list.
     * @param elements An array of emails elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEmails(UaaUser.Email... elements) {
      for (UaaUser.Email element : elements) {
        this.emails.add(Objects.requireNonNull(element, "emails element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UaaUser#getEmails() emails} list.
     * @param elements An iterable of emails elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("emails")
    public final Builder emails(Iterable<? extends UaaUser.Email> elements) {
      this.emails.clear();
      return addAllEmails(elements);
    }

    /**
     * Adds elements to {@link UaaUser#getEmails() emails} list.
     * @param elements An iterable of emails elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmails(Iterable<? extends UaaUser.Email> elements) {
      for (UaaUser.Email element : elements) {
        this.emails.add(Objects.requireNonNull(element, "emails element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UaaUser#getExternalId() externalId} attribute.
     * @param externalId The value for externalId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("externalId")
    public final Builder externalId(@Nullable String externalId) {
      this.externalId = externalId;
      return this;
    }

    /**
     * Initializes the value for the {@link UaaUser#getUserName() userName} attribute.
     * @param userName The value for userName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userName")
    public final Builder userName(@Nullable String userName) {
      this.userName = userName;
      return this;
    }

    /**
     * Adds one element to {@link UaaUser#getGroups() groups} list.
     * @param element A groups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGroups(UaaUser.Group element) {
      this.groups.add(Objects.requireNonNull(element, "groups element"));
      return this;
    }

    /**
     * Adds elements to {@link UaaUser#getGroups() groups} list.
     * @param elements An array of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGroups(UaaUser.Group... elements) {
      for (UaaUser.Group element : elements) {
        this.groups.add(Objects.requireNonNull(element, "groups element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UaaUser#getGroups() groups} list.
     * @param elements An iterable of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groups")
    public final Builder groups(Iterable<? extends UaaUser.Group> elements) {
      this.groups.clear();
      return addAllGroups(elements);
    }

    /**
     * Adds elements to {@link UaaUser#getGroups() groups} list.
     * @param elements An iterable of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllGroups(Iterable<? extends UaaUser.Group> elements) {
      for (UaaUser.Group element : elements) {
        this.groups.add(Objects.requireNonNull(element, "groups element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link UaaUser#getApprovals() approvals} list.
     * @param element A approvals element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addApprovals(UaaUser.Approval element) {
      this.approvals.add(Objects.requireNonNull(element, "approvals element"));
      return this;
    }

    /**
     * Adds elements to {@link UaaUser#getApprovals() approvals} list.
     * @param elements An array of approvals elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addApprovals(UaaUser.Approval... elements) {
      for (UaaUser.Approval element : elements) {
        this.approvals.add(Objects.requireNonNull(element, "approvals element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UaaUser#getApprovals() approvals} list.
     * @param elements An iterable of approvals elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("approvals")
    public final Builder approvals(Iterable<? extends UaaUser.Approval> elements) {
      this.approvals.clear();
      return addAllApprovals(elements);
    }

    /**
     * Adds elements to {@link UaaUser#getApprovals() approvals} list.
     * @param elements An iterable of approvals elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApprovals(Iterable<? extends UaaUser.Approval> elements) {
      for (UaaUser.Approval element : elements) {
        this.approvals.add(Objects.requireNonNull(element, "approvals element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UaaUser#getActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("active")
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Initializes the value for the {@link UaaUser#getVerified() verified} attribute.
     * @param verified The value for verified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("verified")
    public final Builder verified(@Nullable Boolean verified) {
      this.verified = verified;
      return this;
    }

    /**
     * Initializes the value for the {@link UaaUser#getOrigin() origin} attribute.
     * @param origin The value for origin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("origin")
    public final Builder origin(@Nullable String origin) {
      this.origin = origin;
      return this;
    }

    /**
     * Initializes the value for the {@link UaaUser#getZoneId() zoneId} attribute.
     * @param zoneId The value for zoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("zoneId")
    public final Builder zoneId(@Nullable String zoneId) {
      this.zoneId = zoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link UaaUser#getPasswordLastModified() passwordLastModified} attribute.
     * @param passwordLastModified The value for passwordLastModified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("passwordLastModified")
    public final Builder passwordLastModified(@Nullable OffsetDateTime passwordLastModified) {
      this.passwordLastModified = passwordLastModified;
      return this;
    }

    /**
     * Initializes the value for the {@link UaaUser#getPreviousLogonTime() previousLogonTime} attribute.
     * @param previousLogonTime The value for previousLogonTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("previousLogonTime")
    public final Builder previousLogonTime(@Nullable Long previousLogonTime) {
      this.previousLogonTime = previousLogonTime;
      return this;
    }

    /**
     * Initializes the value for the {@link UaaUser#getLastLogonTime() lastLogonTime} attribute.
     * @param lastLogonTime The value for lastLogonTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lastLogonTime")
    public final Builder lastLogonTime(@Nullable Long lastLogonTime) {
      this.lastLogonTime = lastLogonTime;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUaaUser ImmutableUaaUser}.
     * @return An immutable instance of UaaUser
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUaaUser build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUaaUser(
          id,
          createUnmodifiableList(true, schemas),
          meta,
          name,
          createUnmodifiableList(true, emails),
          externalId,
          userName,
          createUnmodifiableList(true, groups),
          createUnmodifiableList(true, approvals),
          active,
          verified,
          origin,
          zoneId,
          passwordLastModified,
          previousLogonTime,
          lastLogonTime);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build UaaUser, some of required attributes are not set " + attributes;
    }
  }

  /**
   * Immutable implementation of {@link UaaUser.Group}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableUaaUser.Group.builder()}.
   */
  @Generated(from = "UaaUser.Group", generator = "Immutables")
  @Immutable
  @JsonIgnoreProperties(ignoreUnknown = true)
  public static final class Group implements UaaUser.Group {
    private final @Nullable String value;
    private final @Nullable String display;
    private final @Nullable String type;

    private Group(
        @Nullable String value,
        @Nullable String display,
        @Nullable String type) {
      this.value = value;
      this.display = display;
      this.type = type;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @JsonProperty("value")
    @Override
    public @Nullable String getValue() {
      return value;
    }

    /**
     * @return The value of the {@code display} attribute
     */
    @JsonProperty("display")
    @Override
    public @Nullable String getDisplay() {
      return display;
    }

    /**
     * @return The value of the {@code type} attribute
     */
    @JsonProperty("type")
    @Override
    public @Nullable String getType() {
      return type;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link UaaUser.Group#getValue() value} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableUaaUser.Group withValue(@Nullable String value) {
      if (Objects.equals(this.value, value)) return this;
      return new ImmutableUaaUser.Group(value, this.display, this.type);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link UaaUser.Group#getDisplay() display} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for display (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableUaaUser.Group withDisplay(@Nullable String value) {
      if (Objects.equals(this.display, value)) return this;
      return new ImmutableUaaUser.Group(this.value, value, this.type);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link UaaUser.Group#getType() type} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for type (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableUaaUser.Group withType(@Nullable String value) {
      if (Objects.equals(this.type, value)) return this;
      return new ImmutableUaaUser.Group(this.value, this.display, value);
    }

    /**
     * This instance is equal to all instances of {@code Group} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@javax.annotation.Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableUaaUser.Group
          && equalTo((ImmutableUaaUser.Group) another);
    }

    private boolean equalTo(ImmutableUaaUser.Group another) {
      return Objects.equals(value, another.value)
          && Objects.equals(display, another.display)
          && Objects.equals(type, another.type);
    }

    /**
     * Computes a hash code from attributes: {@code value}, {@code display}, {@code type}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + Objects.hashCode(value);
      h += (h << 5) + Objects.hashCode(display);
      h += (h << 5) + Objects.hashCode(type);
      return h;
    }

    /**
     * Prints the immutable value {@code Group} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Group{"
          + "value=" + value
          + ", display=" + display
          + ", type=" + type
          + "}";
    }

    /**
     * Utility type used to correctly read immutable object from JSON representation.
     * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Generated(from = "UaaUser.Group", generator = "Immutables")
    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
    static final class Json implements UaaUser.Group {
      @javax.annotation.Nullable String value;
      @javax.annotation.Nullable String display;
      @javax.annotation.Nullable String type;
      @JsonProperty("value")
      public void setValue(@Nullable String value) {
        this.value = value;
      }
      @JsonProperty("display")
      public void setDisplay(@Nullable String display) {
        this.display = display;
      }
      @JsonProperty("type")
      public void setType(@Nullable String type) {
        this.type = type;
      }
      @Override
      public String getValue() { throw new UnsupportedOperationException(); }
      @Override
      public String getDisplay() { throw new UnsupportedOperationException(); }
      @Override
      public String getType() { throw new UnsupportedOperationException(); }
    }

    /**
     * @param json A JSON-bindable data structure
     * @return An immutable value type
     * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Deprecated
    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    static ImmutableUaaUser.Group fromJson(Json json) {
      ImmutableUaaUser.Group.Builder builder = ImmutableUaaUser.Group.builder();
      if (json.value != null) {
        builder.value(json.value);
      }
      if (json.display != null) {
        builder.display(json.display);
      }
      if (json.type != null) {
        builder.type(json.type);
      }
      return builder.build();
    }

    /**
     * Creates an immutable copy of a {@link UaaUser.Group} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Group instance
     */
    public static ImmutableUaaUser.Group copyOf(UaaUser.Group instance) {
      if (instance instanceof ImmutableUaaUser.Group) {
        return (ImmutableUaaUser.Group) instance;
      }
      return ImmutableUaaUser.Group.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableUaaUser.Group Group}.
     * <pre>
     * ImmutableUaaUser.Group.builder()
     *    .value(String | null) // nullable {@link UaaUser.Group#getValue() value}
     *    .display(String | null) // nullable {@link UaaUser.Group#getDisplay() display}
     *    .type(String | null) // nullable {@link UaaUser.Group#getType() type}
     *    .build();
     * </pre>
     * @return A new Group builder
     */
    public static ImmutableUaaUser.Group.Builder builder() {
      return new ImmutableUaaUser.Group.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableUaaUser.Group Group}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "UaaUser.Group", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private @javax.annotation.Nullable String value;
      private @javax.annotation.Nullable String display;
      private @javax.annotation.Nullable String type;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Group} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(UaaUser.Group instance) {
        Objects.requireNonNull(instance, "instance");
        String valueValue = instance.getValue();
        if (valueValue != null) {
          value(valueValue);
        }
        String displayValue = instance.getDisplay();
        if (displayValue != null) {
          display(displayValue);
        }
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
        return this;
      }

      /**
       * Initializes the value for the {@link UaaUser.Group#getValue() value} attribute.
       * @param value The value for value (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("value")
      public final Builder value(@Nullable String value) {
        this.value = value;
        return this;
      }

      /**
       * Initializes the value for the {@link UaaUser.Group#getDisplay() display} attribute.
       * @param display The value for display (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("display")
      public final Builder display(@Nullable String display) {
        this.display = display;
        return this;
      }

      /**
       * Initializes the value for the {@link UaaUser.Group#getType() type} attribute.
       * @param type The value for type (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("type")
      public final Builder type(@Nullable String type) {
        this.type = type;
        return this;
      }

      /**
       * Builds a new {@link ImmutableUaaUser.Group Group}.
       * @return An immutable instance of Group
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableUaaUser.Group build() {
        return new ImmutableUaaUser.Group(value, display, type);
      }
    }
  }

  /**
   * Immutable implementation of {@link UaaUser.Approval}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableUaaUser.Approval.builder()}.
   */
  @Generated(from = "UaaUser.Approval", generator = "Immutables")
  @Immutable
  @JsonIgnoreProperties(ignoreUnknown = true)
  public static final class Approval implements UaaUser.Approval {
    private final @Nullable String userId;
    private final @Nullable String clientId;
    private final @Nullable String scope;
    private final @Nullable String status;
    private final @Nullable OffsetDateTime lastUpdatedAt;
    private final @Nullable OffsetDateTime expiresAt;

    private Approval(
        @Nullable String userId,
        @Nullable String clientId,
        @Nullable String scope,
        @Nullable String status,
        @Nullable OffsetDateTime lastUpdatedAt,
        @Nullable OffsetDateTime expiresAt) {
      this.userId = userId;
      this.clientId = clientId;
      this.scope = scope;
      this.status = status;
      this.lastUpdatedAt = lastUpdatedAt;
      this.expiresAt = expiresAt;
    }

    /**
     * @return The value of the {@code userId} attribute
     */
    @JsonProperty("userId")
    @Override
    public @Nullable String getUserId() {
      return userId;
    }

    /**
     * @return The value of the {@code clientId} attribute
     */
    @JsonProperty("clientId")
    @Override
    public @Nullable String getClientId() {
      return clientId;
    }

    /**
     * @return The value of the {@code scope} attribute
     */
    @JsonProperty("scope")
    @Override
    public @Nullable String getScope() {
      return scope;
    }

    /**
     * @return The value of the {@code status} attribute
     */
    @JsonProperty("status")
    @Override
    public @Nullable String getStatus() {
      return status;
    }

    /**
     * @return The value of the {@code lastUpdatedAt} attribute
     */
    @JsonProperty("lastUpdatedAt")
    @Override
    public @Nullable OffsetDateTime getLastUpdatedAt() {
      return lastUpdatedAt;
    }

    /**
     * @return The value of the {@code expiresAt} attribute
     */
    @JsonProperty("expiresAt")
    @Override
    public @Nullable OffsetDateTime getExpiresAt() {
      return expiresAt;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link UaaUser.Approval#getUserId() userId} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for userId (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableUaaUser.Approval withUserId(@Nullable String value) {
      if (Objects.equals(this.userId, value)) return this;
      return new ImmutableUaaUser.Approval(value, this.clientId, this.scope, this.status, this.lastUpdatedAt, this.expiresAt);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link UaaUser.Approval#getClientId() clientId} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for clientId (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableUaaUser.Approval withClientId(@Nullable String value) {
      if (Objects.equals(this.clientId, value)) return this;
      return new ImmutableUaaUser.Approval(this.userId, value, this.scope, this.status, this.lastUpdatedAt, this.expiresAt);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link UaaUser.Approval#getScope() scope} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for scope (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableUaaUser.Approval withScope(@Nullable String value) {
      if (Objects.equals(this.scope, value)) return this;
      return new ImmutableUaaUser.Approval(this.userId, this.clientId, value, this.status, this.lastUpdatedAt, this.expiresAt);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link UaaUser.Approval#getStatus() status} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for status (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableUaaUser.Approval withStatus(@Nullable String value) {
      if (Objects.equals(this.status, value)) return this;
      return new ImmutableUaaUser.Approval(this.userId, this.clientId, this.scope, value, this.lastUpdatedAt, this.expiresAt);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link UaaUser.Approval#getLastUpdatedAt() lastUpdatedAt} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for lastUpdatedAt (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableUaaUser.Approval withLastUpdatedAt(@Nullable OffsetDateTime value) {
      if (this.lastUpdatedAt == value) return this;
      return new ImmutableUaaUser.Approval(this.userId, this.clientId, this.scope, this.status, value, this.expiresAt);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link UaaUser.Approval#getExpiresAt() expiresAt} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for expiresAt (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableUaaUser.Approval withExpiresAt(@Nullable OffsetDateTime value) {
      if (this.expiresAt == value) return this;
      return new ImmutableUaaUser.Approval(this.userId, this.clientId, this.scope, this.status, this.lastUpdatedAt, value);
    }

    /**
     * This instance is equal to all instances of {@code Approval} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@javax.annotation.Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableUaaUser.Approval
          && equalTo((ImmutableUaaUser.Approval) another);
    }

    private boolean equalTo(ImmutableUaaUser.Approval another) {
      return Objects.equals(userId, another.userId)
          && Objects.equals(clientId, another.clientId)
          && Objects.equals(scope, another.scope)
          && Objects.equals(status, another.status)
          && Objects.equals(lastUpdatedAt, another.lastUpdatedAt)
          && Objects.equals(expiresAt, another.expiresAt);
    }

    /**
     * Computes a hash code from attributes: {@code userId}, {@code clientId}, {@code scope}, {@code status}, {@code lastUpdatedAt}, {@code expiresAt}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + Objects.hashCode(userId);
      h += (h << 5) + Objects.hashCode(clientId);
      h += (h << 5) + Objects.hashCode(scope);
      h += (h << 5) + Objects.hashCode(status);
      h += (h << 5) + Objects.hashCode(lastUpdatedAt);
      h += (h << 5) + Objects.hashCode(expiresAt);
      return h;
    }

    /**
     * Prints the immutable value {@code Approval} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Approval{"
          + "userId=" + userId
          + ", clientId=" + clientId
          + ", scope=" + scope
          + ", status=" + status
          + ", lastUpdatedAt=" + lastUpdatedAt
          + ", expiresAt=" + expiresAt
          + "}";
    }

    /**
     * Utility type used to correctly read immutable object from JSON representation.
     * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Generated(from = "UaaUser.Approval", generator = "Immutables")
    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
    static final class Json implements UaaUser.Approval {
      @javax.annotation.Nullable String userId;
      @javax.annotation.Nullable String clientId;
      @javax.annotation.Nullable String scope;
      @javax.annotation.Nullable String status;
      @javax.annotation.Nullable OffsetDateTime lastUpdatedAt;
      @javax.annotation.Nullable OffsetDateTime expiresAt;
      @JsonProperty("userId")
      public void setUserId(@Nullable String userId) {
        this.userId = userId;
      }
      @JsonProperty("clientId")
      public void setClientId(@Nullable String clientId) {
        this.clientId = clientId;
      }
      @JsonProperty("scope")
      public void setScope(@Nullable String scope) {
        this.scope = scope;
      }
      @JsonProperty("status")
      public void setStatus(@Nullable String status) {
        this.status = status;
      }
      @JsonProperty("lastUpdatedAt")
      public void setLastUpdatedAt(@Nullable OffsetDateTime lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
      }
      @JsonProperty("expiresAt")
      public void setExpiresAt(@Nullable OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
      }
      @Override
      public String getUserId() { throw new UnsupportedOperationException(); }
      @Override
      public String getClientId() { throw new UnsupportedOperationException(); }
      @Override
      public String getScope() { throw new UnsupportedOperationException(); }
      @Override
      public String getStatus() { throw new UnsupportedOperationException(); }
      @Override
      public OffsetDateTime getLastUpdatedAt() { throw new UnsupportedOperationException(); }
      @Override
      public OffsetDateTime getExpiresAt() { throw new UnsupportedOperationException(); }
    }

    /**
     * @param json A JSON-bindable data structure
     * @return An immutable value type
     * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Deprecated
    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    static ImmutableUaaUser.Approval fromJson(Json json) {
      ImmutableUaaUser.Approval.Builder builder = ImmutableUaaUser.Approval.builder();
      if (json.userId != null) {
        builder.userId(json.userId);
      }
      if (json.clientId != null) {
        builder.clientId(json.clientId);
      }
      if (json.scope != null) {
        builder.scope(json.scope);
      }
      if (json.status != null) {
        builder.status(json.status);
      }
      if (json.lastUpdatedAt != null) {
        builder.lastUpdatedAt(json.lastUpdatedAt);
      }
      if (json.expiresAt != null) {
        builder.expiresAt(json.expiresAt);
      }
      return builder.build();
    }

    /**
     * Creates an immutable copy of a {@link UaaUser.Approval} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Approval instance
     */
    public static ImmutableUaaUser.Approval copyOf(UaaUser.Approval instance) {
      if (instance instanceof ImmutableUaaUser.Approval) {
        return (ImmutableUaaUser.Approval) instance;
      }
      return ImmutableUaaUser.Approval.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableUaaUser.Approval Approval}.
     * <pre>
     * ImmutableUaaUser.Approval.builder()
     *    .userId(String | null) // nullable {@link UaaUser.Approval#getUserId() userId}
     *    .clientId(String | null) // nullable {@link UaaUser.Approval#getClientId() clientId}
     *    .scope(String | null) // nullable {@link UaaUser.Approval#getScope() scope}
     *    .status(String | null) // nullable {@link UaaUser.Approval#getStatus() status}
     *    .lastUpdatedAt(java.time.OffsetDateTime | null) // nullable {@link UaaUser.Approval#getLastUpdatedAt() lastUpdatedAt}
     *    .expiresAt(java.time.OffsetDateTime | null) // nullable {@link UaaUser.Approval#getExpiresAt() expiresAt}
     *    .build();
     * </pre>
     * @return A new Approval builder
     */
    public static ImmutableUaaUser.Approval.Builder builder() {
      return new ImmutableUaaUser.Approval.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableUaaUser.Approval Approval}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "UaaUser.Approval", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private @javax.annotation.Nullable String userId;
      private @javax.annotation.Nullable String clientId;
      private @javax.annotation.Nullable String scope;
      private @javax.annotation.Nullable String status;
      private @javax.annotation.Nullable OffsetDateTime lastUpdatedAt;
      private @javax.annotation.Nullable OffsetDateTime expiresAt;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Approval} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(UaaUser.Approval instance) {
        Objects.requireNonNull(instance, "instance");
        String userIdValue = instance.getUserId();
        if (userIdValue != null) {
          userId(userIdValue);
        }
        String clientIdValue = instance.getClientId();
        if (clientIdValue != null) {
          clientId(clientIdValue);
        }
        String scopeValue = instance.getScope();
        if (scopeValue != null) {
          scope(scopeValue);
        }
        String statusValue = instance.getStatus();
        if (statusValue != null) {
          status(statusValue);
        }
        OffsetDateTime lastUpdatedAtValue = instance.getLastUpdatedAt();
        if (lastUpdatedAtValue != null) {
          lastUpdatedAt(lastUpdatedAtValue);
        }
        OffsetDateTime expiresAtValue = instance.getExpiresAt();
        if (expiresAtValue != null) {
          expiresAt(expiresAtValue);
        }
        return this;
      }

      /**
       * Initializes the value for the {@link UaaUser.Approval#getUserId() userId} attribute.
       * @param userId The value for userId (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("userId")
      public final Builder userId(@Nullable String userId) {
        this.userId = userId;
        return this;
      }

      /**
       * Initializes the value for the {@link UaaUser.Approval#getClientId() clientId} attribute.
       * @param clientId The value for clientId (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("clientId")
      public final Builder clientId(@Nullable String clientId) {
        this.clientId = clientId;
        return this;
      }

      /**
       * Initializes the value for the {@link UaaUser.Approval#getScope() scope} attribute.
       * @param scope The value for scope (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("scope")
      public final Builder scope(@Nullable String scope) {
        this.scope = scope;
        return this;
      }

      /**
       * Initializes the value for the {@link UaaUser.Approval#getStatus() status} attribute.
       * @param status The value for status (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("status")
      public final Builder status(@Nullable String status) {
        this.status = status;
        return this;
      }

      /**
       * Initializes the value for the {@link UaaUser.Approval#getLastUpdatedAt() lastUpdatedAt} attribute.
       * @param lastUpdatedAt The value for lastUpdatedAt (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("lastUpdatedAt")
      public final Builder lastUpdatedAt(@Nullable OffsetDateTime lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
        return this;
      }

      /**
       * Initializes the value for the {@link UaaUser.Approval#getExpiresAt() expiresAt} attribute.
       * @param expiresAt The value for expiresAt (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("expiresAt")
      public final Builder expiresAt(@Nullable OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
      }

      /**
       * Builds a new {@link ImmutableUaaUser.Approval Approval}.
       * @return An immutable instance of Approval
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableUaaUser.Approval build() {
        return new ImmutableUaaUser.Approval(userId, clientId, scope, status, lastUpdatedAt, expiresAt);
      }
    }
  }

  /**
   * Immutable implementation of {@link UaaUser.Name}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableUaaUser.Name.builder()}.
   */
  @Generated(from = "UaaUser.Name", generator = "Immutables")
  @Immutable
  @JsonIgnoreProperties(ignoreUnknown = true)
  public static final class Name implements UaaUser.Name {
    private final @Nullable String familyName;
    private final @Nullable String givenName;

    private Name(
        @Nullable String familyName,
        @Nullable String givenName) {
      this.familyName = familyName;
      this.givenName = givenName;
    }

    /**
     * @return The value of the {@code familyName} attribute
     */
    @JsonProperty("familyName")
    @Override
    public @Nullable String getFamilyName() {
      return familyName;
    }

    /**
     * @return The value of the {@code givenName} attribute
     */
    @JsonProperty("givenName")
    @Override
    public @Nullable String getGivenName() {
      return givenName;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link UaaUser.Name#getFamilyName() familyName} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for familyName (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableUaaUser.Name withFamilyName(@Nullable String value) {
      if (Objects.equals(this.familyName, value)) return this;
      return new ImmutableUaaUser.Name(value, this.givenName);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link UaaUser.Name#getGivenName() givenName} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for givenName (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableUaaUser.Name withGivenName(@Nullable String value) {
      if (Objects.equals(this.givenName, value)) return this;
      return new ImmutableUaaUser.Name(this.familyName, value);
    }

    /**
     * This instance is equal to all instances of {@code Name} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@javax.annotation.Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableUaaUser.Name
          && equalTo((ImmutableUaaUser.Name) another);
    }

    private boolean equalTo(ImmutableUaaUser.Name another) {
      return Objects.equals(familyName, another.familyName)
          && Objects.equals(givenName, another.givenName);
    }

    /**
     * Computes a hash code from attributes: {@code familyName}, {@code givenName}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + Objects.hashCode(familyName);
      h += (h << 5) + Objects.hashCode(givenName);
      return h;
    }

    /**
     * Prints the immutable value {@code Name} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Name{"
          + "familyName=" + familyName
          + ", givenName=" + givenName
          + "}";
    }

    /**
     * Utility type used to correctly read immutable object from JSON representation.
     * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Generated(from = "UaaUser.Name", generator = "Immutables")
    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
    static final class Json implements UaaUser.Name {
      @javax.annotation.Nullable String familyName;
      @javax.annotation.Nullable String givenName;
      @JsonProperty("familyName")
      public void setFamilyName(@Nullable String familyName) {
        this.familyName = familyName;
      }
      @JsonProperty("givenName")
      public void setGivenName(@Nullable String givenName) {
        this.givenName = givenName;
      }
      @Override
      public String getFamilyName() { throw new UnsupportedOperationException(); }
      @Override
      public String getGivenName() { throw new UnsupportedOperationException(); }
    }

    /**
     * @param json A JSON-bindable data structure
     * @return An immutable value type
     * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Deprecated
    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    static ImmutableUaaUser.Name fromJson(Json json) {
      ImmutableUaaUser.Name.Builder builder = ImmutableUaaUser.Name.builder();
      if (json.familyName != null) {
        builder.familyName(json.familyName);
      }
      if (json.givenName != null) {
        builder.givenName(json.givenName);
      }
      return builder.build();
    }

    /**
     * Creates an immutable copy of a {@link UaaUser.Name} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Name instance
     */
    public static ImmutableUaaUser.Name copyOf(UaaUser.Name instance) {
      if (instance instanceof ImmutableUaaUser.Name) {
        return (ImmutableUaaUser.Name) instance;
      }
      return ImmutableUaaUser.Name.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableUaaUser.Name Name}.
     * <pre>
     * ImmutableUaaUser.Name.builder()
     *    .familyName(String | null) // nullable {@link UaaUser.Name#getFamilyName() familyName}
     *    .givenName(String | null) // nullable {@link UaaUser.Name#getGivenName() givenName}
     *    .build();
     * </pre>
     * @return A new Name builder
     */
    public static ImmutableUaaUser.Name.Builder builder() {
      return new ImmutableUaaUser.Name.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableUaaUser.Name Name}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "UaaUser.Name", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private @javax.annotation.Nullable String familyName;
      private @javax.annotation.Nullable String givenName;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Name} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(UaaUser.Name instance) {
        Objects.requireNonNull(instance, "instance");
        String familyNameValue = instance.getFamilyName();
        if (familyNameValue != null) {
          familyName(familyNameValue);
        }
        String givenNameValue = instance.getGivenName();
        if (givenNameValue != null) {
          givenName(givenNameValue);
        }
        return this;
      }

      /**
       * Initializes the value for the {@link UaaUser.Name#getFamilyName() familyName} attribute.
       * @param familyName The value for familyName (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("familyName")
      public final Builder familyName(@Nullable String familyName) {
        this.familyName = familyName;
        return this;
      }

      /**
       * Initializes the value for the {@link UaaUser.Name#getGivenName() givenName} attribute.
       * @param givenName The value for givenName (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("givenName")
      public final Builder givenName(@Nullable String givenName) {
        this.givenName = givenName;
        return this;
      }

      /**
       * Builds a new {@link ImmutableUaaUser.Name Name}.
       * @return An immutable instance of Name
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableUaaUser.Name build() {
        return new ImmutableUaaUser.Name(familyName, givenName);
      }
    }
  }

  /**
   * Immutable implementation of {@link UaaUser.Email}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableUaaUser.Email.builder()}.
   */
  @Generated(from = "UaaUser.Email", generator = "Immutables")
  @Immutable
  @JsonIgnoreProperties(ignoreUnknown = true)
  public static final class Email implements UaaUser.Email {
    private final @Nullable String value;
    private final @Nullable Boolean primary;

    private Email(
        @Nullable String value,
        @Nullable Boolean primary) {
      this.value = value;
      this.primary = primary;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @JsonProperty("value")
    @Override
    public @Nullable String getValue() {
      return value;
    }

    /**
     * @return The value of the {@code primary} attribute
     */
    @JsonProperty("primary")
    @Override
    public @Nullable Boolean getPrimary() {
      return primary;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link UaaUser.Email#getValue() value} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableUaaUser.Email withValue(@Nullable String value) {
      if (Objects.equals(this.value, value)) return this;
      return new ImmutableUaaUser.Email(value, this.primary);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link UaaUser.Email#getPrimary() primary} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for primary (can be {@code null})
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableUaaUser.Email withPrimary(@Nullable Boolean value) {
      if (Objects.equals(this.primary, value)) return this;
      return new ImmutableUaaUser.Email(this.value, value);
    }

    /**
     * This instance is equal to all instances of {@code Email} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@javax.annotation.Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableUaaUser.Email
          && equalTo((ImmutableUaaUser.Email) another);
    }

    private boolean equalTo(ImmutableUaaUser.Email another) {
      return Objects.equals(value, another.value)
          && Objects.equals(primary, another.primary);
    }

    /**
     * Computes a hash code from attributes: {@code value}, {@code primary}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + Objects.hashCode(value);
      h += (h << 5) + Objects.hashCode(primary);
      return h;
    }

    /**
     * Prints the immutable value {@code Email} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Email{"
          + "value=" + value
          + ", primary=" + primary
          + "}";
    }

    /**
     * Utility type used to correctly read immutable object from JSON representation.
     * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Generated(from = "UaaUser.Email", generator = "Immutables")
    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
    static final class Json implements UaaUser.Email {
      @javax.annotation.Nullable String value;
      @javax.annotation.Nullable Boolean primary;
      @JsonProperty("value")
      public void setValue(@Nullable String value) {
        this.value = value;
      }
      @JsonProperty("primary")
      public void setPrimary(@Nullable Boolean primary) {
        this.primary = primary;
      }
      @Override
      public String getValue() { throw new UnsupportedOperationException(); }
      @Override
      public Boolean getPrimary() { throw new UnsupportedOperationException(); }
    }

    /**
     * @param json A JSON-bindable data structure
     * @return An immutable value type
     * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Deprecated
    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    static ImmutableUaaUser.Email fromJson(Json json) {
      ImmutableUaaUser.Email.Builder builder = ImmutableUaaUser.Email.builder();
      if (json.value != null) {
        builder.value(json.value);
      }
      if (json.primary != null) {
        builder.primary(json.primary);
      }
      return builder.build();
    }

    /**
     * Creates an immutable copy of a {@link UaaUser.Email} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Email instance
     */
    public static ImmutableUaaUser.Email copyOf(UaaUser.Email instance) {
      if (instance instanceof ImmutableUaaUser.Email) {
        return (ImmutableUaaUser.Email) instance;
      }
      return ImmutableUaaUser.Email.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableUaaUser.Email Email}.
     * <pre>
     * ImmutableUaaUser.Email.builder()
     *    .value(String | null) // nullable {@link UaaUser.Email#getValue() value}
     *    .primary(Boolean | null) // nullable {@link UaaUser.Email#getPrimary() primary}
     *    .build();
     * </pre>
     * @return A new Email builder
     */
    public static ImmutableUaaUser.Email.Builder builder() {
      return new ImmutableUaaUser.Email.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableUaaUser.Email Email}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "UaaUser.Email", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private @javax.annotation.Nullable String value;
      private @javax.annotation.Nullable Boolean primary;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Email} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(UaaUser.Email instance) {
        Objects.requireNonNull(instance, "instance");
        String valueValue = instance.getValue();
        if (valueValue != null) {
          value(valueValue);
        }
        Boolean primaryValue = instance.getPrimary();
        if (primaryValue != null) {
          primary(primaryValue);
        }
        return this;
      }

      /**
       * Initializes the value for the {@link UaaUser.Email#getValue() value} attribute.
       * @param value The value for value (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("value")
      public final Builder value(@Nullable String value) {
        this.value = value;
        return this;
      }

      /**
       * Initializes the value for the {@link UaaUser.Email#getPrimary() primary} attribute.
       * @param primary The value for primary (can be {@code null})
       * @return {@code this} builder for use in a chained invocation
       */
      @JsonProperty("primary")
      public final Builder primary(@Nullable Boolean primary) {
        this.primary = primary;
        return this;
      }

      /**
       * Builds a new {@link ImmutableUaaUser.Email Email}.
       * @return An immutable instance of Email
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableUaaUser.Email build() {
        return new ImmutableUaaUser.Email(value, primary);
      }
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
