/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.security.uaa.spi;

import io.dialob.security.spring.oauth2.UsersAndGroupsService;
import io.dialob.security.spring.oauth2.model.Group;
import io.dialob.security.spring.oauth2.model.ImmutableGroup;
import io.dialob.security.spring.oauth2.model.ImmutableUser;
import io.dialob.security.spring.oauth2.model.User;
import io.dialob.security.uaa.spi.UaaClient;
import io.dialob.security.uaa.spi.UaaServiceBase;
import io.dialob.security.uaa.spi.model.UaaGroup;
import io.dialob.security.uaa.spi.model.UaaUser;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class UaaUsersAndGroupsService
extends UaaServiceBase
implements UsersAndGroupsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UaaUsersAndGroupsService.class);

    public UaaUsersAndGroupsService(@NonNull UaaClient uaaClient) {
        super(uaaClient);
    }

    public Optional<User> findUser(String userId) {
        LOGGER.debug("findUser('{}')", (Object)userId);
        if (userId == null) {
            return Optional.empty();
        }
        return this.get(client -> client.getUser(userId)).map(uaaUser -> {
            UaaUser.Name name = uaaUser.getName();
            String firstName = null;
            String lastName = null;
            if (name != null) {
                firstName = name.getGivenName();
                lastName = name.getFamilyName();
            }
            return ImmutableUser.builder().id(uaaUser.getId()).isAnonymous(false).userName(uaaUser.getUserName()).firstName(firstName).lastName(lastName).addAllGroups(uaaUser.getGroups().stream().map(group -> ImmutableGroup.builder().id(group.getValue()).name(group.getDisplay()).build())::iterator).build();
        });
    }

    public Optional<Group> findGroup(String groupId) {
        LOGGER.debug("findGroup('{}')", (Object)groupId);
        if (groupId == null) {
            return Optional.empty();
        }
        return this.get(client -> client.getGroup(groupId)).map(this::mapToGroup);
    }

    public List<Group> findGroupByName(String groupName) {
        LOGGER.debug("findGroupByName('{}')", (Object)groupName);
        if (groupName == null) {
            return Collections.emptyList();
        }
        return this.list(client -> client.findGroupsByDisplayName(groupName).getResources()).stream().map(this::mapToGroup).collect(Collectors.toList());
    }

    private Group mapToGroup(UaaGroup group) {
        return ImmutableGroup.builder().id(group.getId()).name(group.getDisplayName()).addAllMembers(group.getMembers().stream().map(UaaGroup.Member::getValue)::iterator).build();
    }
}

